/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.db.sql.execute.NullValue;
import org.netbeans.modules.db.sql.execute.SQLExecutionResults;
import org.netbeans.modules.db.sql.execute.ui.SQLResultPanelModel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;

public class SQLResultPanel
extends JPanel {
    private SQLExecutionResults executionResults;
    private JMenuItem copyCellValueMenuItem;
    private JMenuItem copyRowValuesMenuItem;
    private JScrollPane resultScrollPane;
    private JTable resultTable;
    private JPopupMenu tablePopupMenu;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$lang$Object;

    public SQLResultPanel() {
        this.initComponents();
    }

    public void setModel(SQLResultPanelModel model) {
        AbstractTableModel resultSetModel = null;
        resultSetModel = model != null ? (model.getResultSetModel() != null ? model.getResultSetModel() : new DefaultTableModel(0, 0)) : new DefaultTableModel(0, 0);
        this.resultTable.setModel(resultSetModel);
    }

    private void setClipboard(String contents) {
        ExClipboard clipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
        StringSelection strSel = new StringSelection(contents);
        clipboard.setContents((Transferable)strSel, (ClipboardOwner)strSel);
    }

    private void initComponents() {
        this.tablePopupMenu = new JPopupMenu();
        this.copyCellValueMenuItem = new JMenuItem();
        this.copyRowValuesMenuItem = new JMenuItem();
        this.resultScrollPane = new JScrollPane();
        this.resultTable = new SQLResultTable();
        this.copyCellValueMenuItem.setText(NbBundle.getMessage((Class)SQLResultPanel.class, (String)"LBL_CopyCellValue"));
        this.copyCellValueMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SQLResultPanel.this.copyCellValueMenuItemActionPerformed(evt);
            }
        });
        this.tablePopupMenu.add(this.copyCellValueMenuItem);
        this.copyCellValueMenuItem.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SQLResultPanel.class, (String)"ACSD_CopyCellValue"));
        this.copyRowValuesMenuItem.setText(NbBundle.getMessage((Class)SQLResultPanel.class, (String)"LBL_CopyRowValues"));
        this.copyRowValuesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SQLResultPanel.this.copyRowValuesMenuItemActionPerformed(evt);
            }
        });
        this.tablePopupMenu.add(this.copyRowValuesMenuItem);
        this.copyRowValuesMenuItem.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SQLResultPanel.class, (String)"ACSD_CopyRowValues"));
        this.setLayout(new BorderLayout());
        this.resultScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.resultScrollPane.getViewport().setBackground(UIManager.getDefaults().getColor("Table.background"));
        this.resultTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.resultTable.setAutoResizeMode(0);
        this.resultTable.setOpaque(false);
        this.resultTable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                SQLResultPanel.this.resultTableMouseReleased(evt);
            }
        });
        this.resultScrollPane.setViewportView(this.resultTable);
        this.add((Component)this.resultScrollPane, "Center");
    }

    private void copyRowValuesMenuItemActionPerformed(ActionEvent evt) {
        int[] rows = this.resultTable.getSelectedRows();
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < rows.length; ++i) {
            for (int col = 0; col < this.resultTable.getColumnCount(); ++col) {
                if (col > 0) {
                    output.append('\t');
                }
                Object o = this.resultTable.getValueAt(rows[i], col);
                output.append(o.toString());
            }
            output.append('\n');
        }
        this.setClipboard(output.toString());
    }

    private void copyCellValueMenuItemActionPerformed(ActionEvent evt) {
        Object o = this.resultTable.getValueAt(this.resultTable.getSelectedRow(), this.resultTable.getSelectedColumn());
        this.setClipboard(o.toString());
    }

    private void resultTableMouseReleased(MouseEvent evt) {
        if (evt.getButton() != 3) {
            return;
        }
        int row = this.resultTable.rowAtPoint(evt.getPoint());
        int column = this.resultTable.columnAtPoint(evt.getPoint());
        boolean inSelection = false;
        int[] rows = this.resultTable.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i] != row) continue;
            inSelection = true;
            break;
        }
        if (!inSelection) {
            this.resultTable.changeSelection(row, column, false, false);
        }
        this.tablePopupMenu.show(this.resultTable, evt.getX(), evt.getY());
    }

    static final class SQLResultTable
    extends JTable {
        public SQLResultTable() {
            this.setDefaultRenderer(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SQLResultPanel.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new DateTimeRenderer());
            this.setDefaultRenderer(class$java$sql$Time == null ? (class$java$sql$Time = SQLResultPanel.class$("java.sql.Time")) : class$java$sql$Time, new TimeRenderer());
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            Object value = this.getValueAt(row, column);
            if (value instanceof NullValue) {
                return this.getDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = SQLResultPanel.class$("java.lang.Object")) : class$java$lang$Object);
            }
            return super.getCellRenderer(row, column);
        }

        private static final class TimeRenderer
        extends DefaultTableCellRenderer.UIResource {
            DateFormat formatter;

            public void setValue(Object value) {
                if (this.formatter == null) {
                    this.formatter = DateFormat.getTimeInstance();
                }
                this.setText(value == null ? "" : this.formatter.format(value));
            }
        }

        private static final class DateTimeRenderer
        extends DefaultTableCellRenderer.UIResource {
            DateFormat formatter;

            public void setValue(Object value) {
                if (this.formatter == null) {
                    this.formatter = DateFormat.getDateTimeInstance();
                }
                this.setText(value == null ? "" : this.formatter.format(value));
            }
        }
    }
}

