/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Collection;
import java.util.List;
import javax.jmi.reflect.ConstraintViolationException;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.jmi.javamodel.JavaDoc;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.jmiimpl.javamodel.DiffElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.FeatureImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.parser.AttributeInfo;
import org.netbeans.modules.javacore.parser.ElementInfo;
import org.netbeans.modules.javacore.parser.FeatureInfo;
import org.netbeans.modules.javacore.parser.MDRParser;
import org.netbeans.modules.javacore.parser.TypeRef;
import org.openide.util.Utilities;

public abstract class AttributeImpl
extends FeatureImpl
implements Attribute {
    InitialValue defaultValue;
    String defaultValueText;
    TypeReference typeName;
    boolean defaultValueInited = false;
    protected TypeRef type;
    private static final ElementInfo DEFAULT_INFO = new AttributeInfo(null, 0, null, 0, null, null, null);
    private boolean elementsInited;

    public AttributeImpl(StorableObject s) {
        super(s);
    }

    protected void matchPersistent(ElementInfo info) {
        super.matchPersistent(info);
        AttributeInfo newInfo = (AttributeInfo)info;
        if (!this.isPersisted()) {
            this.setPersisted(true);
            this.persist();
            this.setTypeRef(newInfo.type);
            this.persistChildren(this.getPersistentList("annotations", this.super_getAnnotations()), ((FeatureInfo)info).annotations);
        } else {
            if (!Utilities.compareObjects((Object)newInfo.type, (Object)this.getTypeRef())) {
                this.setType(this.resolveType(newInfo.type));
            }
            this.processMembers(this.getAnnotations(), newInfo.annotations);
        }
    }

    protected void matchElementInfo(ElementInfo info) {
        super.matchElementInfo(info);
        this.resetASTElements();
    }

    public InitialValue getDefaultValue() {
        this.checkUpToDate();
        if (!this.defaultValueInited) {
            this.initDefaultValue();
        }
        return this.defaultValue;
    }

    public void setDefaultValue(InitialValue newValue) {
        if (!this.defaultValueInited) {
            this.initDefaultValue();
            this.defaultValueInited = true;
        }
        this.changeChild((Element)this.defaultValue, (Element)newValue);
        this.defaultValue = newValue;
        this.defaultValueText = null;
        this.objectChanged(32);
    }

    public String getDefaultValueText() {
        this.checkUpToDate();
        if (this.isChanged(32)) {
            if (this.defaultValue != null) {
                throw new ConstraintViolationException(null, null, "Cannot ask for default value text after the default value was changed.");
            }
            return this.defaultValueText;
        }
        return this.extractDefaultValueText();
    }

    public void setDefaultValueText(String newValue) {
        if (!this.elementsInited) {
            this.initASTElements();
        }
        if (this.defaultValueInited && this.defaultValue != null) {
            this.changeChild((Element)this.defaultValue, null);
        }
        this.objectChanged(32);
        this.defaultValueText = newValue;
        this.defaultValue = null;
        this.defaultValueInited = true;
    }

    public List getChildren() {
        List result = super.getChildren();
        AttributeImpl.addIfNotNull(result, this.getTypeName());
        if (!this.isChanged(32) || this.defaultValueText == null) {
            AttributeImpl.addIfNotNull(result, this.getDefaultValue());
        }
        return result;
    }

    protected List getInitedChildren() {
        List result = super.getInitedChildren();
        if (this.elementsInited) {
            AttributeImpl.addIfNotNull(result, this.getTypeName());
            if (this.defaultValueInited && (!this.isChanged(32) || this.defaultValueText == null)) {
                AttributeImpl.addIfNotNull(result, this.getDefaultValue());
            }
        }
        return result;
    }

    public Type getType() {
        this.checkUpToDate();
        return this.resolveType(this.getTypeRef());
    }

    private void fireTypeNameChange(TypeReference typeReference) {
        TypeReference oldValue = null;
        TypeReference newValue = null;
        if (this.elementsInited && !this.disableChanges) {
            oldValue = this.getTypeName();
            newValue = typeReference;
        }
        this.fireAttrChange("typeName", oldValue, newValue);
    }

    public void setType(Type newValue) {
        TypeRef tr = AttributeImpl.typeToTypeRef(newValue);
        TypeReference typeReference = (TypeReference)this.typeRefToTypeReference(tr, 0);
        this.fireTypeNameChange(typeReference);
        this._setTypeName(typeReference, tr);
    }

    public TypeReference getTypeName() {
        this.checkUpToDate();
        if (!this.elementsInited) {
            this.initASTElements();
        }
        return this.typeName;
    }

    public void setTypeName(TypeReference typeName) {
        this._setTypeName(typeName, AttributeImpl.typeReferenceToTypeRef((Element)typeName, 0));
    }

    private void _setTypeName(TypeReference typeName, TypeRef typeRef) {
        if (!this.disableChanges) {
            this.objectChanged(64);
            this.changeChild((Element)this.getTypeName(), (Element)typeName);
            this.typeName = typeName;
        }
        this.setTypeRef(typeRef);
    }

    public Collection getValues() {
        throw new UnsupportedOperationException("getValues()");
    }

    public String getSourceText() {
        String defValText;
        String origElem = this.checkChange();
        if (origElem != null) {
            return origElem;
        }
        StringBuffer buf = new StringBuffer(27);
        buf.append('\n');
        this.generateNewJavaDoc(buf);
        buf.append(this.getIndentation());
        buf.append(((MetadataElement)this.getTypeName()).getSourceText());
        buf.append(' ').append(this.getName());
        buf.append(this.formatElementPart(3));
        buf.append(this.formatElementPart(4));
        String string = defValText = this.defaultValue == null ? this.defaultValueText : ((MetadataElement)this.getDefaultValue()).getSourceText();
        if (defValText != null) {
            buf.append(" default ");
            buf.append(defValText);
        }
        buf.append(';');
        return buf.toString();
    }

    public void getDiff(List diff) {
        MetadataElement defaultValue;
        ASTree tree = this.getASTree();
        MDRParser parser = this.getParser();
        ASTree[] children = tree.getSubTrees();
        this.replaceJavaDoc(diff);
        if (this.isChanged(32772)) {
            this.diffModifiers(diff, children[1], parser);
        } else if (children[0] != null) {
            AttributeInfo astInfo = (AttributeInfo)this.getElementInfo();
            this.getCollectionDiff(diff, parser, 32768, astInfo.annotations, this.getAnnotations(), parser.getToken(children[0].getLastToken()).getEndOffset(), " ");
        }
        this.getChildDiff(diff, this.getParser(), tree.getSubTrees()[1], (MetadataElement)this.getTypeName(), 64);
        if (this.isChanged(2)) {
            Token identifier = (Token)tree.getSubTrees()[2];
            int startOffset = identifier.getStartOffset();
            int endOffset = identifier.getEndOffset();
            diff.add(new DiffElement(startOffset, endOffset, this.getName()));
        }
        if (this.isChanged(32)) {
            int startOffset;
            String newText = this.defaultValue == null ? this.defaultValueText : ((MetadataElement)this.getDefaultValue()).getSourceText();
            ASTree initValT = this.extractDefaultValue();
            int endOffset = parser.getToken(tree.getLastToken()).getStartOffset();
            if (initValT != null) {
                int initValFirstToken = initValT.getFirstToken();
                startOffset = newText != null ? parser.getToken(initValFirstToken).getStartOffset() : parser.getToken(initValFirstToken - 2).getEndOffset();
            } else {
                if (newText == null) {
                    return;
                }
                newText = " default " + newText;
                startOffset = endOffset;
            }
            diff.add(new DiffElement(startOffset, endOffset, newText == null ? "" : newText));
        } else if (this.isChanged(1) && (defaultValue = (MetadataElement)this.getDefaultValue()).isChanged()) {
            defaultValue.getDiff(diff);
        }
    }

    protected ElementInfo getDefaultInfo() {
        return DEFAULT_INFO;
    }

    protected void setData(List annotations, String javadocText, JavaDoc javadoc, TypeReference typeName, InitialValue defaultValue, String defaultValueText) {
        super.setData(annotations, javadocText, javadoc);
        if (defaultValueText == null) {
            this.changeChild(null, (Element)defaultValue);
            this.defaultValue = defaultValue;
        } else {
            if (defaultValue != null) {
                throw new ConstraintViolationException(null, null, "Cannot set both defaultValue and defaultValueText.");
            }
            this.defaultValueText = defaultValueText;
        }
        this.defaultValueInited = true;
        this.changeChild(null, (Element)typeName);
        this.typeName = typeName;
        this.elementsInited = true;
    }

    protected void initChildren() {
        this.childrenInited = false;
        super.initChildren();
        this.childrenInited = true;
        if (this.elementsInited) {
            this.initASTElements();
        }
        if (this.defaultValueInited) {
            JMManager.getTransactionMutex().addBFeatureToInitQueue((Object)this);
        }
    }

    protected void initASTElements() {
        this.elementsInited = false;
        if (!this.childrenInited) {
            this.initChildren();
        }
        AttributeInfo info = (AttributeInfo)this.getElementInfo();
        ASTree tree = info.getTypeAST(this);
        this.typeName = (TypeReference)this.initOrCreate((Element)this.typeName, tree);
        this.elementsInited = true;
    }

    protected void resetChildren() {
        super.resetChildren();
        this.resetASTElements();
    }

    protected void resetASTElements() {
        InitialValue temp;
        if (this.defaultValue != null) {
            temp = this.defaultValue;
            this.defaultValue = null;
            this.changeChild((Element)temp, null);
            temp.refDelete();
        }
        if (this.typeName != null) {
            temp = this.typeName;
            this.typeName = null;
            this.changeChild((Element)temp, null);
            temp.refDelete();
        }
        this.defaultValueInited = false;
        this.elementsInited = false;
    }

    public Element duplicate(JavaModelPackage targetExtent) {
        String defValText;
        InitialValue defVal;
        if (this.isChanged(32) && this.defaultValueText != null) {
            defVal = null;
            defValText = this.defaultValueText;
        } else {
            defVal = (InitialValue)AttributeImpl.duplicateElement((Element)this.getDefaultValue(), targetExtent);
            defValText = null;
        }
        return targetExtent.getAttribute().createAttribute(this.getName(), AttributeImpl.duplicateList(this.getAnnotations(), targetExtent), this.getModifiers(), null, (JavaDoc)AttributeImpl.duplicateElement((Element)this.getJavadoc(), targetExtent), (TypeReference)AttributeImpl.duplicateElement((Element)this.getTypeName(), targetExtent), defVal, defValText);
    }

    public void initDefaultValue() {
        AttributeInfo defaultValInfo;
        this.defaultValueInited = false;
        if (!this.elementsInited) {
            this.initASTElements();
        }
        if ((defaultValInfo = (AttributeInfo)this.getElementInfo()) != null) {
            defaultValInfo.doAttribution(this);
            this.defaultValue = (InitialValue)this.initOrCreate((Element)this.defaultValue, this.extractDefaultValue());
        }
        this.defaultValueInited = true;
    }

    private ASTree extractDefaultValue() {
        ASTree defValTree = this.getASTree().getSubTrees()[3];
        return defValTree == null ? null : defValTree.getSubTrees()[0];
    }

    private String extractDefaultValueText() {
        MDRParser parser = this.getParser();
        if (parser == null) {
            return null;
        }
        ASTree attributeDefaultValue = this.extractDefaultValue();
        if (attributeDefaultValue == null) {
            return null;
        }
        return parser.getText(attributeDefaultValue);
    }

    protected void _delete() {
        if (this.elementsInited) {
            this.deleteChild((Element)this.typeName);
        }
        if (this.defaultValueInited) {
            this.deleteChild((Element)this.defaultValue);
        }
        super._delete();
    }
}

