/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore;

import java.io.File;
import java.util.LinkedHashSet;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public class Util {
    private static FileSystem[] fileSystems;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static FileSystem[] getFileSystems() {
        if (fileSystems != null) {
            return fileSystems;
        }
        File[] roots = File.listRoots();
        LinkedHashSet<FileSystem> allRoots = new LinkedHashSet<FileSystem>();
        if (!($assertionsDisabled || roots != null && roots.length > 0)) {
            throw new AssertionError((Object)"Could not list file roots");
        }
        for (int i = 0; i < roots.length; ++i) {
            File root = roots[i];
            FileObject random = FileUtil.toFileObject((File)root);
            if (random == null) continue;
            try {
                FileSystem fs = random.getFileSystem();
                allRoots.add(fs);
                if (fs == null) continue;
                break;
            }
            catch (FileStateInvalidException e) {
                throw new AssertionError((Object)e);
            }
        }
        FileSystem[] retVal = new FileSystem[allRoots.size()];
        allRoots.toArray(retVal);
        if (!$assertionsDisabled && retVal.length <= 0) {
            throw new AssertionError((Object)"Could not get any filesystem");
        }
        fileSystems = retVal;
        return retVal;
    }

    public static void addFileSystemsListener(FileChangeListener l) {
        FileSystem[] fileSystems = Util.getFileSystems();
        for (int i = 0; i < fileSystems.length; ++i) {
            fileSystems[i].addFileChangeListener(l);
        }
    }

    public static void removeFileSystemsListener(FileChangeListener l) {
        FileSystem[] fileSystems = Util.getFileSystems();
        for (int i = 0; i < fileSystems.length; ++i) {
            fileSystems[i].removeFileChangeListener(l);
        }
    }

    public static FileObject getCPRoot(FileObject fo) {
        return ((JMManager)JavaMetamodel.getManager()).getMergedClassPathImpl().findOwnerRoot(fo);
    }

    public static boolean isJavaFile(FileObject fo) {
        return Util.isJavaFile(fo, false);
    }

    public static boolean isJavaFile(FileObject fo, boolean includeVirtuals) {
        if (!includeVirtuals && fo.isVirtual()) {
            return false;
        }
        if (fo.isFolder()) {
            return false;
        }
        String ext = fo.getExt();
        return ("java".equals(ext) || "class".equals(ext)) && Util.getCPRoot(fo) != null;
    }

    static {
        $assertionsDisabled = !Util.class.desiredAssertionStatus();
    }
}

