/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.search.types.DataObjectType;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ObjectTypeType
extends DataObjectType {
    private static final long serialVersionUID = 1L;
    private static final String NAMES_FIELD = "classNames";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("classNames", List.class)};
    private transient Class[] mask = new Class[0];

    protected String displayName() {
        return NbBundle.getMessage((Class)ObjectTypeType.class, (String)"TEXT_OBJECTTYPE_CRITERION");
    }

    public boolean testDataObject(DataObject dataObject) {
        Class<?> ld = dataObject.getLoader().getClass();
        for (int i = 0; i < this.mask.length; ++i) {
            if (!this.mask[i].isAssignableFrom(ld)) continue;
            return true;
        }
        return false;
    }

    public void setMask(Class[] mask) {
        this.mask = mask;
        this.firePropertyChange("mask", null, null);
        this.setValid(this.mask.length != 0);
    }

    public Class[] getMask() {
        return this.mask;
    }

    public void setMask(int i, Class m) {
        this.mask[i] = m;
        this.firePropertyChange("mask", null, null);
        this.setValid(true);
    }

    public Class getMask(int i) {
        return this.mask[i];
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ObjectTypeType.class);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ArrayList<String> classNames = new ArrayList<String>(this.mask == null ? 0 : this.mask.length);
        if (this.mask != null) {
            for (int i = 0; i < this.mask.length; ++i) {
                if (this.mask[i] == null) continue;
                classNames.add(this.mask[i].getName());
            }
        }
        out.putFields().put(NAMES_FIELD, classNames);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        List classNames = (List)in.readFields().get(NAMES_FIELD, new ArrayList());
        ArrayList classes = new ArrayList(classNames.size());
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        Iterator it = classNames.iterator();
        while (it.hasNext()) {
            try {
                classes.add(Class.forName((String)it.next(), false, classLoader));
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
        }
        this.mask = new Class[classes.size()];
        classes.toArray(this.mask);
        this.setValid(false);
    }
}

