/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.search.types.ObjectTypeType;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ObjectTypeCustomizer
extends JPanel
implements Customizer,
HierarchyListener {
    private static final String FOLDER_LOADER_NAME = "org.openide.loaders.DataFolder";
    private ObjectTypeType peer;
    private boolean setting = false;
    private boolean discovered = false;
    private transient Collection loaders;
    private JScrollPane jScrollPane1;
    private JLabel lblType;
    private JList typeList;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ObjectTypeCustomizer() {
        this.initComponents();
        this.initAccessibility();
        this.addHierarchyListener(this);
        TitledBorder tb = new TitledBorder(NbBundle.getBundle((Class)ObjectTypeCustomizer.class).getString("TEXT_LABEL_OBJECT_TYPE"));
        tb.setBorder(new CompoundBorder());
        this.setBorder(tb);
    }

    private void initAccessibility() {
        ResourceBundle bundle = NbBundle.getBundle((Class)ObjectTypeCustomizer.class);
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("TEXT_LABEL_OBJECT_TYPE"));
        this.typeList.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_TypeList"));
        this.typeList.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TypeList"));
        this.jScrollPane1.getHorizontalScrollBar().getAccessibleContext().setAccessibleName(bundle.getString("ACSN_HScrollBar"));
        this.jScrollPane1.getVerticalScrollBar().getAccessibleContext().setAccessibleName(bundle.getString("ACSN_VScrollBar"));
    }

    private void initComponents() {
        this.lblType = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.typeList = new JList();
        this.setLayout(new BorderLayout(0, 6));
        this.lblType.setLabelFor(this.typeList);
        Mnemonics.setLocalizedText((JLabel)this.lblType, (String)NbBundle.getMessage((Class)ObjectTypeCustomizer.class, (String)"LBL_Type"));
        this.add((Component)this.lblType, "North");
        this.typeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ObjectTypeCustomizer.this.typeListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.typeList);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void typeListValueChanged(ListSelectionEvent evt) {
        if (this.setting) {
            return;
        }
        if (this.loaders == null) {
            this.peer.setMask(new Class[0]);
            return;
        }
        ArrayList<DataLoader> toret = new ArrayList<DataLoader>();
        Object[] sel = this.typeList.getSelectedValues();
        Iterator i = this.loaders.iterator();
        block0: while (i.hasNext()) {
            DataLoader nextLoader = (DataLoader)i.next();
            String id = nextLoader.getDisplayName();
            if (id == null) continue;
            for (int j = 0; j < sel.length; ++j) {
                if (sel[j] == null || !id.equals((String)sel[j])) continue;
                toret.add(nextLoader);
                continue block0;
            }
        }
        Class[] ret = new Class[toret.size()];
        Iterator it = toret.iterator();
        int k = 0;
        while (it.hasNext()) {
            ret[k++] = it.next().getClass();
        }
        this.peer.setMask(ret);
    }

    public void setObject(Object obj) {
        this.peer = (ObjectTypeType)((Object)obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadObjectTypes() {
        if (!$assertionsDisabled && this.loaders != null) {
            throw new AssertionError();
        }
        this.setting = true;
        try {
            Enumeration en = ((DataLoaderPool)Lookup.getDefault().lookup(DataLoaderPool.class)).allLoaders();
            TreeSet<String> types = new TreeSet<String>();
            ArrayList<String> selected = new ArrayList<String>();
            boolean folderLoaderFound = false;
            Class[] mask = this.peer.getMask();
            if (mask != null && mask.length == 0) {
                mask = null;
            }
            int loadersToFind = mask != null ? mask.length : 0;
            this.loaders = new ArrayList();
            block5: while (en.hasMoreElements()) {
                Class repreClass;
                DataLoader nextLoader = (DataLoader)en.nextElement();
                this.loaders.add(nextLoader);
                if (!folderLoaderFound && FOLDER_LOADER_NAME.equals(nextLoader.getRepresentationClassName())) {
                    folderLoaderFound = true;
                    continue;
                }
                String displayName = nextLoader.getDisplayName();
                if (displayName == null) continue;
                types.add(displayName);
                if (loadersToFind <= 0 || (repreClass = nextLoader.getRepresentationClass()) == null) continue;
                for (int j = 0; j < mask.length; ++j) {
                    DataLoader loader;
                    if (mask[j] == null || (loader = DataLoader.getLoader((Class)mask[j])) == null || !repreClass.equals(loader.getRepresentationClass())) continue;
                    selected.add(displayName);
                    --loadersToFind;
                    mask[j] = null;
                    continue block5;
                }
            }
            ((ArrayList)this.loaders).trimToSize();
            this.typeList.setListData(types.toArray(new String[types.size()]));
            if (selected.size() > 0) {
                int[] indexes = new int[selected.size()];
                ArrayList typesList = new ArrayList(types);
                for (int i = 0; i < indexes.length; ++i) {
                    indexes[i] = typesList.indexOf(selected.get(i));
                }
                this.typeList.setSelectedIndices(indexes);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        finally {
            this.setting = false;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener p1) {
    }

    public void removePropertyChangeListener(PropertyChangeListener p1) {
    }

    public void hierarchyChanged(HierarchyEvent e) {
        if (this.discovered) {
            return;
        }
        if ((e.getChangeFlags() & 4L) != 0L && this.isShowing()) {
            this.discovered = true;
            this.loadObjectTypes();
        }
    }

    public void requestFocus() {
        this.typeList.requestFocus();
    }

    static {
        $assertionsDisabled = !ObjectTypeCustomizer.class.desiredAssertionStatus();
    }
}

