/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.io.Serializable;
import org.openide.src.Identifier;

public class Import
implements Serializable {
    public static final boolean PACKAGE = true;
    public static final boolean CLASS = false;
    private boolean wholePackage;
    private Identifier id;
    static final long serialVersionUID = -4111760314345461897L;

    public Import(Identifier id, boolean wholePackage) {
        this.wholePackage = wholePackage;
        this.id = id;
    }

    public boolean isPackage() {
        return this.wholePackage;
    }

    public boolean isClass() {
        return !this.wholePackage;
    }

    public Identifier getIdentifier() {
        return this.id;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("import ");
        buf.append(this.id.getFullName());
        if (this.wholePackage) {
            buf.append(".*");
        }
        return buf.toString();
    }

    public int hashCode() {
        return this.id.getFullName().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Import) {
            Import imp = (Import)o;
            return this.wholePackage == imp.wholePackage && this.id.equals(imp.id);
        }
        return false;
    }
}

