/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.UtilConvert;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.text.PositionBounds;

public abstract class Element
implements Serializable {
    private transient PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected PositionBounds bounds;

    protected Element(PositionBounds bounds) {
        this.bounds = bounds;
    }

    public PositionBounds getBounds() {
        return this.bounds;
    }

    void update(Element elem) {
        this.bounds = elem.bounds;
    }

    protected final void firePropertyChange(String name, Object o, Object n) {
        this.support.firePropertyChange(name, o, n);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    public final void print() {
        if (this.bounds == null) {
            return;
        }
        try {
            this.bounds.setText(this.getDocumentString());
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public abstract String getDocumentString();

    public String toString() {
        if (this.bounds == null) {
            return "(no bounds)";
        }
        return new StringBuffer(16).append('(').append(this.bounds.getBegin().getOffset()).append(", ").append(this.bounds.getEnd().getOffset()).append(')').toString();
    }

    public static class ItemElem
    extends Element
    implements Node.Cookie {
        private KeyElem key;
        private ValueElem value;
        private CommentElem comment;
        private PropertiesStructure parent;
        public static final String PROP_ITEM_KEY = "key";
        public static final String PROP_ITEM_VALUE = "value";
        public static final String PROP_ITEM_COMMENT = "comment";
        static final long serialVersionUID = 1078147817847520586L;

        protected ItemElem(PositionBounds bounds, KeyElem key, ValueElem value, CommentElem comment) {
            super(bounds);
            this.key = key;
            this.value = value;
            this.comment = comment;
        }

        void setParent(PropertiesStructure ps) {
            this.parent = ps;
        }

        private PropertiesStructure getParent() {
            if (this.parent == null) {
                throw new IllegalStateException("Resource Bundle: Parent is missing");
            }
            return this.parent;
        }

        public String toString() {
            return this.comment.toString() + "\n" + (this.key == null ? "" : this.key.toString()) + "\n" + (this.value == null ? "" : this.value.toString()) + "\n";
        }

        public KeyElem getKeyElem() {
            return this.key;
        }

        public ValueElem getValueElem() {
            return this.value;
        }

        public CommentElem getCommentElem() {
            return this.comment;
        }

        void update(Element elem) {
            super.update(elem);
            if (this.key == null) {
                this.key = ((ItemElem)elem).key;
            } else {
                this.key.update(((ItemElem)elem).key);
            }
            if (this.value == null) {
                this.value = ((ItemElem)elem).value;
            } else {
                this.value.update(((ItemElem)elem).value);
            }
            this.comment.update(((ItemElem)elem).comment);
        }

        public String getDocumentString() {
            return this.comment.getDocumentString() + (this.key == null ? "" : this.key.getDocumentString()) + (this.value == null ? "" : this.value.getDocumentString());
        }

        public String getKey() {
            return this.key == null ? null : this.key.getValue();
        }

        public void setKey(String newKey) {
            String oldKey = this.key.getValue();
            if (!oldKey.equals(newKey)) {
                this.key.setValue(newKey);
                this.getParent().itemKeyChanged(oldKey, this);
                this.firePropertyChange(PROP_ITEM_KEY, oldKey, newKey);
            }
        }

        public String getValue() {
            return this.value == null ? null : this.value.getValue();
        }

        public void setValue(String newValue) {
            String oldValue = this.value.getValue();
            if (!oldValue.equals(newValue)) {
                if (oldValue.equals("")) {
                    this.key.print();
                }
                this.value.setValue(newValue);
                this.getParent().itemChanged(this);
                this.firePropertyChange(PROP_ITEM_VALUE, oldValue, newValue);
            }
        }

        public String getComment() {
            return this.comment == null ? null : this.comment.getValue();
        }

        public void setComment(String newComment) {
            String oldComment = this.comment.getValue();
            if (!oldComment.equals(newComment)) {
                this.comment.setValue(newComment);
                this.getParent().itemChanged(this);
                this.firePropertyChange(PROP_ITEM_COMMENT, oldComment, newComment);
            }
        }

        public boolean equals(Object item) {
            if (item == null || !(item instanceof ItemElem)) {
                return false;
            }
            ItemElem ie = (ItemElem)item;
            return (this.key == null && ie.getKeyElem() == null || this.key != null && ie.getKeyElem() != null && this.getKey().equals(ie.getKey())) && (this.value == null && ie.getValueElem() == null || this.value != null && ie.getValueElem() != null && this.getValue().equals(ie.getValue())) && (this.comment == null && ie.getCommentElem() == null || this.comment != null && ie.getCommentElem() != null && this.getComment().equals(ie.getComment()));
        }
    }

    public static class CommentElem
    extends Basic {
        static final long serialVersionUID = 2418308580934815756L;

        protected CommentElem(PositionBounds bounds, String value) {
            super(bounds, value);
        }

        public String getDocumentString() {
            if (this.value == null || this.value.length() == 0) {
                return "";
            }
            StringBuffer sb = new StringBuffer(this.value);
            if (sb.charAt(sb.length() - 1) != '\n') {
                sb.append('\n');
            }
            int lineStart = 0;
            boolean hasCommentChar = false;
            for (int i = 0; i < sb.length(); ++i) {
                char aChar = sb.charAt(i);
                if (aChar == '\n') {
                    String line = sb.substring(lineStart, i);
                    String convertedLine = UtilConvert.saveConvert(line);
                    sb.replace(lineStart, i, convertedLine);
                    lineStart = (i += convertedLine.length() - line.length()) + 1;
                    hasCommentChar = false;
                    continue;
                }
                if (hasCommentChar || " \t\r\n\f".indexOf(aChar) != -1) continue;
                if (aChar == '#' || aChar == '!') {
                    lineStart = i + 1;
                } else {
                    sb.insert(lineStart, '#');
                    lineStart = ++i;
                }
                hasCommentChar = true;
            }
            return sb.toString();
        }
    }

    public static class ValueElem
    extends Basic {
        static final long serialVersionUID = 4662649023463958853L;

        protected ValueElem(PositionBounds bounds, String value) {
            super(bounds, value);
        }

        public String getDocumentString() {
            return UtilConvert.saveConvert(this.value) + "\n";
        }
    }

    public static class KeyElem
    extends Basic {
        static final long serialVersionUID = 6828294289485744331L;

        protected KeyElem(PositionBounds bounds, String value) {
            super(bounds, value);
        }

        public String getDocumentString() {
            return UtilConvert.saveConvert(this.value, true) + "=";
        }
    }

    public static abstract class Basic
    extends Element {
        protected String value;

        protected Basic(PositionBounds bounds, String value) {
            super(bounds);
            this.value = value;
        }

        void update(Element elem) {
            super.update(elem);
            this.value = ((Basic)elem).value;
        }

        public String toString() {
            return this.value + "   " + super.toString();
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
            this.print();
        }
    }
}

