/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.services;

import java.beans.PropertyVetoException;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.j2ee.sun.dd.api.VersionNotSupportedException;
import org.netbeans.modules.j2ee.sun.dd.api.common.MessageSecurityBinding;
import org.netbeans.modules.j2ee.sun.dd.api.common.PortInfo;
import org.netbeans.modules.j2ee.sun.dd.api.common.WebserviceEndpoint;
import org.netbeans.modules.j2ee.sun.dd.api.common.WsdlPort;
import org.netbeans.modules.j2ee.sun.dd.api.services.MessageSecurityProvider;
import org.netbeans.modules.j2ee.sun.share.configbean.ServiceRef;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.WebServiceDescriptor;
import org.netbeans.modules.j2ee.sun.share.configbean.WebServices;
import org.openide.ErrorManager;

public class MessageSecurityProviderImpl
implements MessageSecurityProvider {
    public MessageSecurityProviderImpl() {
        ErrorManager.getDefault().log(1, "MessageSecurityProvider implementation created.");
    }

    public MessageSecurityBinding getEndpointBinding(File sunDD, String endpointName, String portName) {
        WebserviceEndpoint endpoint;
        WebServiceDescriptor wsBean;
        MessageSecurityBinding result = null;
        this.validateEndpointParams(endpointName, portName);
        SunONEDeploymentConfiguration config = this.getConfiguration(sunDD);
        WebServices wsRoot = config.getWebServicesRoot();
        if (wsRoot != null && (wsBean = wsRoot.getWebServiceDescriptor(endpointName)) != null && (endpoint = wsBean.getWebServiceEndpoint(portName)) != null) {
            try {
                MessageSecurityBinding binding = endpoint.getMessageSecurityBinding();
                if (binding != null) {
                    result = (MessageSecurityBinding)binding.clone();
                }
            }
            catch (VersionNotSupportedException ex) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean setEndpointBinding(File sunDD, String endpointName, String portName, MessageSecurityBinding binding) {
        WebServiceDescriptor wsBean;
        boolean result = false;
        this.validateEndpointParams(endpointName, portName);
        SunONEDeploymentConfiguration config = this.getConfiguration(sunDD);
        WebServices wsRoot = config.getWebServicesRoot();
        if (wsRoot != null && (wsBean = wsRoot.getWebServiceDescriptor(endpointName)) != null) {
            try {
                wsBean.setMessageSecurityBinding(portName, binding);
                result = true;
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (PropertyVetoException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return result;
    }

    public MessageSecurityBinding getServiceRefBinding(File sunDD, String serviceRefName) {
        List portInfoList;
        MessageSecurityBinding result = null;
        this.validateServiceRefParams(serviceRefName);
        SunONEDeploymentConfiguration config = this.getConfiguration(sunDD);
        ServiceRef serviceRef = Utils.findServiceRef(config, serviceRefName);
        if (serviceRef != null && (portInfoList = serviceRef.getPortInfos()).size() > 0) {
            PortInfo portInfo = (PortInfo)portInfoList.get(0);
            try {
                MessageSecurityBinding binding = portInfo.getMessageSecurityBinding();
                if (binding != null) {
                    result = binding;
                }
            }
            catch (VersionNotSupportedException ex) {
                // empty catch block
            }
        }
        return result;
    }

    public MessageSecurityBinding getServiceRefBinding(File sunDD, String serviceRefName, String namespaceURI, String localpart) {
        MessageSecurityBinding result = null;
        this.validateServiceRefParams(serviceRefName, namespaceURI, localpart);
        SunONEDeploymentConfiguration config = this.getConfiguration(sunDD);
        ServiceRef serviceRef = Utils.findServiceRef(config, serviceRefName);
        if (serviceRef != null) {
            List portInfoList = serviceRef.getPortInfos();
            Iterator iter = portInfoList.iterator();
            while (iter.hasNext()) {
                PortInfo portInfo = (PortInfo)iter.next();
                WsdlPort port = portInfo.getWsdlPort();
                if (port == null || !namespaceURI.equals(port.getNamespaceURI()) || !localpart.equals(port.getLocalpart())) continue;
                try {
                    MessageSecurityBinding binding = portInfo.getMessageSecurityBinding();
                    if (binding == null) break;
                    result = binding;
                }
                catch (VersionNotSupportedException ex) {}
                break;
            }
        }
        return result;
    }

    public boolean setServiceRefBinding(File sunDD, String serviceRefName, MessageSecurityBinding binding) {
        boolean result = false;
        this.validateServiceRefParams(serviceRefName);
        SunONEDeploymentConfiguration config = this.getConfiguration(sunDD);
        ServiceRef serviceRef = Utils.findServiceRef(config, serviceRefName);
        if (serviceRef != null) {
            try {
                serviceRef.setMessageSecurityBinding(binding);
                result = true;
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (PropertyVetoException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return result;
    }

    public boolean setServiceRefBinding(File sunDD, String serviceRefName, String namespaceURI, String localpart, MessageSecurityBinding binding) {
        boolean result = false;
        this.validateServiceRefParams(serviceRefName, namespaceURI, localpart);
        SunONEDeploymentConfiguration config = this.getConfiguration(sunDD);
        ServiceRef serviceRef = Utils.findServiceRef(config, serviceRefName);
        if (serviceRef != null) {
            try {
                serviceRef.setMessageSecurityBinding(namespaceURI, localpart, binding);
                result = true;
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (PropertyVetoException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return result;
    }

    public MessageSecurityBinding newMessageSecurityBinding(File sunDD) {
        SunONEDeploymentConfiguration config = this.getConfiguration(sunDD);
        return config.getStorageFactory().createMessageSecurityBinding();
    }

    private SunONEDeploymentConfiguration getConfiguration(File sunDD) {
        SunONEDeploymentConfiguration cachedDC = SunONEDeploymentConfiguration.getConfiguration(sunDD);
        if (sunDD == null) {
            throw new IllegalArgumentException("Deployment descriptor file reference cannot be null.");
        }
        if (cachedDC == null) {
            throw new IllegalStateException("No Sun deployment configuration found for descriptor " + sunDD.getPath());
        }
        return cachedDC;
    }

    private void validateEndpointParams(String endpointName, String portName) {
        if (!Utils.notEmpty(endpointName)) {
            throw new IllegalArgumentException("Web service description name cannot be empty or null.");
        }
        if (!Utils.notEmpty(portName)) {
            throw new IllegalArgumentException("Web service port name cannot be empty or null.");
        }
    }

    private void validateServiceRefParams(String serviceRefName) {
        if (!Utils.notEmpty(serviceRefName)) {
            throw new IllegalArgumentException("Web service reference name cannot be empty or null.");
        }
    }

    private void validateServiceRefParams(String serviceRefName, String namespaceURI, String localpart) {
        if (!Utils.notEmpty(serviceRefName)) {
            throw new IllegalArgumentException("Web service reference name cannot be empty or null.");
        }
        if (!Utils.notEmpty(namespaceURI)) {
            throw new IllegalArgumentException("Wsdl-port namespaceURI for service-ref cannot be empty or null.");
        }
        if (!Utils.notEmpty(localpart)) {
            throw new IllegalArgumentException("Wsdl-port localpart for service-ref cannot be empty or null.");
        }
    }

    private WebserviceEndpoint getEndpoint(SunONEDeploymentConfiguration config, String endpointName, String portName) {
        WebServiceDescriptor wsBean;
        WebserviceEndpoint endpoint = null;
        WebServices wsRoot = config.getWebServicesRoot();
        if (wsRoot != null && (wsBean = wsRoot.getWebServiceDescriptor(endpointName)) != null) {
            endpoint = wsBean.getWebServiceEndpoint(portName);
        }
        return endpoint;
    }
}

