/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.ejbmodule;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.PmDescriptor;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;

public class PmDescriptorMapping {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private static final String formatPattern = "(id={0}, version={1})";
    private final PmDescriptor pmDescriptor;
    private String pmIdentifier;
    private String pmVersion;
    private String displayText;

    public PmDescriptorMapping(PmDescriptor pmDesc) {
        this.pmDescriptor = pmDesc;
        this.displayText = null;
    }

    public String toString() {
        if (this.textOutOfDate()) {
            this.buildDisplayText();
        }
        return this.displayText;
    }

    private void buildDisplayText() {
        if (this.pmDescriptor != null) {
            this.pmIdentifier = this.pmDescriptor.getPmIdentifier();
            this.pmVersion = this.pmDescriptor.getPmVersion();
            Object[] args = new Object[]{this.pmIdentifier, this.pmVersion};
            this.displayText = MessageFormat.format(formatPattern, args);
        } else {
            this.displayText = "";
        }
    }

    private boolean textOutOfDate() {
        if (this.displayText == null) {
            return true;
        }
        if (this.pmDescriptor == null) {
            return false;
        }
        if (!Utils.strEquals(this.pmIdentifier, this.pmDescriptor.getPmIdentifier())) {
            return true;
        }
        return !Utils.strEquals(this.pmVersion, this.pmDescriptor.getPmVersion());
    }

    public PmDescriptor getPmDescriptor() {
        return this.pmDescriptor;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof PmDescriptorMapping) {
            PmDescriptorMapping targetMapping = (PmDescriptorMapping)obj;
            result = this.pmDescriptor == targetMapping.pmDescriptor;
        }
        return result;
    }

    public int hashCode() {
        int hashCode = 37;
        if (this.pmDescriptor != null) {
            if (Utils.notEmpty(this.pmDescriptor.getPmIdentifier())) {
                hashCode += 37 * hashCode + this.pmDescriptor.getPmIdentifier().hashCode();
            }
            if (Utils.notEmpty(this.pmDescriptor.getPmVersion())) {
                hashCode += 37 * hashCode + this.pmDescriptor.getPmVersion().hashCode();
            }
        }
        return hashCode;
    }
}

