/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model.exporter;

import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.exporter.ExporterBase;
import com.sun.xml.rpc.processor.model.exporter.PGraph;
import com.sun.xml.rpc.processor.model.exporter.PObject;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class PGraphExporter
extends ExporterBase {
    public void doExport(PGraph g) {
        this.internalDoExport(g);
    }

    public PGraphExporter(OutputStream s) {
        super(s);
    }

    protected void failUnsupportedClass(Class klass) {
        throw new ModelException("model.exporter.unsupportedClass", klass.getName());
    }

    protected void internalDoExport(Object root) {
        this.initialize();
        PGraph graph = (PGraph)root;
        this.writer.startElement(graph.getName());
        if (graph.getVersion() != null) {
            this.writer.writeAttribute("version", graph.getVersion());
        }
        int id = this.getId(graph.getRoot());
        while (!this.obj2serializeStack.empty()) {
            Object obj = this.obj2serializeStack.pop();
            this.obj2serialize.remove(obj);
            this.visit(obj);
        }
        this.writer.endElement();
        this.writer.close();
    }

    protected void visit(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof PObject) {
            PObject anObject = (PObject)obj;
            Iterator iter = anObject.getPropertyNames();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Object value = anObject.getProperty(name);
                this.property(name, obj, value);
            }
        } else {
            super.visit(obj);
        }
    }

    protected QName getContainerName() {
        return null;
    }

    protected void define(Object obj, Integer id) {
        if (obj instanceof PObject) {
            PObject anObject = (PObject)obj;
            this.writer.startElement(this.getDefineObjectName());
            this.writer.writeAttribute("id", id.toString());
            this.writer.writeAttribute("type", anObject.getType());
            this.writer.endElement();
            this.obj2serialize.add(obj);
            this.obj2serializeStack.push(obj);
        } else {
            super.define(obj, id);
        }
    }
}

