/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.ui.nodes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.common.FQNSearch;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.ui.nodes.editors.TypeEditor;
import org.netbeans.modules.j2ee.common.ui.nodes.elements.ElementNode;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class MethodCustomizer
extends JPanel {
    public static final String OK_ENABLED = "ok_enabled";
    private MethodNameListener methodNameListener;
    private static final String[] COMMON_TYPES = TypeEditor.RVALUE_TYPES;
    private Method method;
    boolean isOK = true;
    private boolean isInitialized = false;
    private String methodName;
    private boolean waitingScanFinished = false;
    private JButton browseFQNButton;
    private JScrollPane ejbQlScrollBar;
    private JTextArea ejbQlText;
    private JTextField errorField;
    private JTabbedPane exceptionAndParameterPanel;
    private JPanel exceptionsPanel;
    private JPanel finderCardinalityPanel;
    private ButtonGroup finderReturnGroup;
    private JPanel interfacePanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JCheckBox localCheckbox;
    private JRadioButton manyRadioButton;
    private JPanel methodPanel;
    private JTextField nameTextField;
    private JRadioButton oneRadioButton;
    private JPanel paramsPanel;
    private JCheckBox remoteCheckbox;
    private JLabel returnLabel;
    private JComboBox returnTypeComboBox;
    private String patternStr;
    private String regexErrorMessage;
    private Method[] existingMethods;
    private String existingNameErrorMessage;

    public MethodCustomizer(Method element) {
        this.method = element;
        this.methodName = this.method.getName();
        this.initComponents();
        this.isInitialized = true;
        ResourceBundle bundle = NbBundle.getBundle(MethodCustomizer.class);
        Color c = UIManager.getColor("nb.errorForeground");
        this.errorField.setForeground(c == null ? new Color(89, 79, 191) : c);
        this.methodPanel.setBorder(new CompoundBorder(new TitledBorder(bundle.getString("CTL_MethodFrame")), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.nameTextField.setText(element.getName().toString());
        this.returnTypeComboBox.setSelectedItem(element.getType() == null ? this.returnTypeComboBox.getItemAt(0) : element.getType().getName());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        PropertyPanel paramsEditor = new PropertyPanel(ElementNode.createParametersProperty((CallableFeature)element, true), 2);
        Node.Property fd = paramsEditor.getProperty();
        fd.setValue("mnemonic_Add", bundle.getString("CTL_Parameters_Mnemonic_Add"));
        fd.setValue("mnemonic_Remove", bundle.getString("CTL_Parameters_Mnemonic_Remove"));
        fd.setValue("mnemonic_Up", bundle.getString("CTL_Parameters_Mnemonic_Up"));
        fd.setValue("mnemonic_Down", bundle.getString("CTL_Parameters_Mnemonic_Down"));
        fd.setValue("mnemonic_Edit", bundle.getString("CTL_Parameters_Mnemonic_Edit"));
        this.paramsPanel.add((Component)paramsEditor, gridBagConstraints);
        PropertyPanel exceptionsEditor = new PropertyPanel(ElementNode.createExceptionsProperty((CallableFeature)element, true), 2);
        fd = exceptionsEditor.getProperty();
        fd.setValue("mnemonic_Add", bundle.getString("CTL_Exceptions_Mnemonic_Add"));
        fd.setValue("mnemonic_Remove", bundle.getString("CTL_Exceptions_Mnemonic_Remove"));
        fd.setValue("mnemonic_Up", bundle.getString("CTL_Exceptions_Mnemonic_Up"));
        fd.setValue("mnemonic_Down", bundle.getString("CTL_Exceptions_Mnemonic_Down"));
        fd.setValue("mnemonic_Edit", bundle.getString("CTL_Exceptions_Mnemonic_Edit"));
        this.exceptionsPanel.add((Component)exceptionsEditor, gridBagConstraints);
        this.jLabel1.setDisplayedMnemonic(bundle.getString("CTL_Name_Mnemonic").charAt(0));
        this.returnLabel.setDisplayedMnemonic(bundle.getString("CTL_MethodType_Mnemonic").charAt(0));
        ((JTextComponent)this.returnTypeComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                MethodCustomizer.this.checkReturnType();
            }

            public void insertUpdate(DocumentEvent e) {
                MethodCustomizer.this.checkReturnType();
            }

            public void removeUpdate(DocumentEvent e) {
                MethodCustomizer.this.checkReturnType();
            }
        });
        this.initAccessibility();
    }

    public void setEjbQL(String ql) {
        this.ejbQlText.setText(ql);
    }

    public String getEjbQL() {
        return this.ejbQlText.getText();
    }

    public boolean publishToRemote() {
        return this.remoteCheckbox.isSelected();
    }

    public void setPublishToRemote(boolean publish) {
        this.remoteCheckbox.setSelected(publish);
    }

    public boolean publishToLocal() {
        return this.localCheckbox.isSelected();
    }

    public void setPublishToLocal(boolean publish) {
        this.localCheckbox.setSelected(publish);
    }

    public boolean finderReturnIsSingle() {
        return this.oneRadioButton.isSelected();
    }

    public void setFinderCardinality(boolean many) {
        if (many) {
            this.manyRadioButton.setSelected(true);
        } else {
            this.oneRadioButton.setSelected(true);
        }
    }

    void hideEJBQL() {
        this.ejbQlScrollBar.setVisible(false);
    }

    void hideExceptions() {
        this.exceptionAndParameterPanel.remove(this.exceptionsPanel);
    }

    void hideFinderReturn() {
        this.finderCardinalityPanel.setVisible(false);
    }

    void hideInterfaceSelection() {
        this.interfacePanel.setVisible(false);
    }

    void setAvailableInterface(boolean local, boolean remote) {
        this.remoteCheckbox.setEnabled(remote);
        this.remoteCheckbox.setSelected(remote);
        this.localCheckbox.setEnabled(local);
        this.localCheckbox.setSelected(local);
    }

    void setSelectedInterface(boolean local, boolean remote) {
        this.remoteCheckbox.setSelected(remote);
        this.localCheckbox.setSelected(local);
    }

    void hideReturn() {
        this.returnTypeComboBox.setVisible(false);
        this.browseFQNButton.setVisible(false);
        this.returnLabel.setVisible(false);
    }

    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MethodCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.finderReturnGroup = new ButtonGroup();
        this.methodPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.returnLabel = new JLabel();
        this.browseFQNButton = new JButton();
        this.returnTypeComboBox = new JComboBox<String>(COMMON_TYPES);
        this.exceptionAndParameterPanel = new JTabbedPane();
        this.paramsPanel = new JPanel();
        this.exceptionsPanel = new JPanel();
        this.interfacePanel = new JPanel();
        this.remoteCheckbox = new JCheckBox();
        this.localCheckbox = new JCheckBox();
        this.finderCardinalityPanel = new JPanel();
        this.oneRadioButton = new JRadioButton();
        this.manyRadioButton = new JRadioButton();
        this.ejbQlScrollBar = new JScrollPane();
        this.ejbQlText = new JTextArea();
        this.errorField = new JTextField();
        this.jLabel2 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.methodPanel.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.nameTextField);
        this.jLabel1.setText(NbBundle.getMessage(MethodCustomizer.class, (String)"CTL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 0, 8, 8);
        this.methodPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                MethodCustomizer.this.nameTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 8, 8);
        this.methodPanel.add((Component)this.nameTextField, gridBagConstraints);
        this.returnLabel.setLabelFor(this.returnTypeComboBox);
        this.returnLabel.setText(NbBundle.getMessage(MethodCustomizer.class, (String)"CTL_ReturnType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 8, 8);
        this.methodPanel.add((Component)this.returnLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseFQNButton, (String)NbBundle.getMessage(MethodCustomizer.class, (String)"LBL_Browse"));
        this.browseFQNButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MethodCustomizer.this.browseFQNButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 8, 8);
        this.methodPanel.add((Component)this.browseFQNButton, gridBagConstraints);
        this.returnTypeComboBox.setEditable(true);
        this.returnTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MethodCustomizer.this.returnTypeComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 8);
        this.methodPanel.add((Component)this.returnTypeComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.methodPanel, gridBagConstraints);
        this.paramsPanel.setLayout(new GridBagLayout());
        this.exceptionAndParameterPanel.addTab(NbBundle.getMessage(MethodCustomizer.class, (String)"CTL_Parameters"), this.paramsPanel);
        this.exceptionsPanel.setLayout(new GridBagLayout());
        this.exceptionAndParameterPanel.addTab(NbBundle.getMessage(MethodCustomizer.class, (String)"CTL_Exceptions"), this.exceptionsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.exceptionAndParameterPanel, gridBagConstraints);
        this.exceptionAndParameterPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MethodCustomizer.class, (String)"ACSN_Method_Declaration"));
        this.exceptionAndParameterPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodCustomizer.class, (String)"ACSD_Method_Declaration"));
        this.interfacePanel.setLayout(new GridLayout(1, 2, 8, 8));
        this.interfacePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MethodCustomizer.class, (String)"CTL_UseInInterface")));
        this.remoteCheckbox.setMnemonic(NbBundle.getMessage(MethodCustomizer.class, (String)"CTL_Remote_Mnemonic").charAt(0));
        this.remoteCheckbox.setText(NbBundle.getMessage(MethodCustomizer.class, (String)"CTL_Remote"));
        this.remoteCheckbox.setToolTipText(NbBundle.getMessage(MethodCustomizer.class, (String)"ACSD_REMOTE"));
        this.interfacePanel.add(this.remoteCheckbox);
        this.localCheckbox.setMnemonic(NbBundle.getMessage(MethodCustomizer.class, (String)"CTL_Local_Mnemonic").charAt(0));
        this.localCheckbox.setText(NbBundle.getMessage(MethodCustomizer.class, (String)"CTL_Local"));
        this.localCheckbox.setToolTipText(NbBundle.getMessage(MethodCustomizer.class, (String)"ACSD_LOCAL"));
        this.interfacePanel.add(this.localCheckbox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.add((Component)this.interfacePanel, gridBagConstraints);
        this.finderCardinalityPanel.setLayout(new GridLayout(1, 0));
        this.finderCardinalityPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MethodCustomizer.class, (String)"CTL_ReturnCardinality")));
        this.finderReturnGroup.add(this.oneRadioButton);
        this.oneRadioButton.setMnemonic(NbBundle.getMessage(MethodCustomizer.class, (String)"CTL_One_Mnemonic").charAt(0));
        this.oneRadioButton.setText(NbBundle.getMessage(MethodCustomizer.class, (String)"CTL_One"));
        this.finderCardinalityPanel.add(this.oneRadioButton);
        this.finderReturnGroup.add(this.manyRadioButton);
        this.manyRadioButton.setMnemonic(NbBundle.getMessage(MethodCustomizer.class, (String)"CTL_Many_Mneumonic").charAt(0));
        this.manyRadioButton.setSelected(true);
        this.manyRadioButton.setText(NbBundle.getMessage(MethodCustomizer.class, (String)"CTL_Many"));
        this.finderCardinalityPanel.add(this.manyRadioButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.add((Component)this.finderCardinalityPanel, gridBagConstraints);
        this.ejbQlScrollBar.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MethodCustomizer.class, (String)"CTL_EJBQL")));
        this.ejbQlScrollBar.setMinimumSize(new Dimension(32, 112));
        this.ejbQlScrollBar.setPreferredSize(new Dimension(32, 112));
        this.ejbQlText.setRows(3);
        this.ejbQlText.setBorder(BorderFactory.createEtchedBorder());
        this.ejbQlScrollBar.setViewportView(this.ejbQlText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 8);
        this.add((Component)this.ejbQlScrollBar, gridBagConstraints);
        this.errorField.setBackground(this.getBackground());
        this.errorField.setEditable(false);
        this.errorField.setBorder(null);
        this.errorField.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.errorField, gridBagConstraints);
        this.jLabel2.setLabelFor(this.exceptionAndParameterPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/common/ui/nodes/Bundle").getString("LBL_TypesAndExceptions"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 3, 6, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
    }

    private void returnTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.method == null) {
            return;
        }
        Type oldValue = this.method.getType();
        boolean ok = false;
        String returnTypeText = ((JTextComponent)this.returnTypeComboBox.getEditor().getEditorComponent()).getText();
        if (returnTypeText != null && !returnTypeText.equals("")) {
            try {
                Type newValue = JMIUtils.resolveType(returnTypeText);
                if (oldValue != null && oldValue.equals(newValue)) {
                    return;
                }
                this.method.setType(newValue);
                ok = true;
            }
            catch (IllegalArgumentException e) {
                ErrorManager.getDefault().annotate((Throwable)e, 256, null, NbBundle.getMessage(MethodCustomizer.class, (String)"MSG_Not_Valid_Type"), null, null);
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        this.isOK = ok;
    }

    private void browseFQNButtonActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FQNSearch.showFastOpen((JTextComponent)MethodCustomizer.this.returnTypeComboBox.getEditor().getEditorComponent());
            }
        });
    }

    private void nameTextFieldFocusLost(FocusEvent evt) {
        if (evt != null && evt.isTemporary() || this.method == null) {
            return;
        }
        String newName = this.nameTextField.getText();
        boolean ok = false;
        if (Utilities.isJavaIdentifier((String)newName)) {
            if (!this.methodName.equals(newName)) {
                this.method.setName(newName);
                this.methodName = newName;
                ok = true;
            } else {
                return;
            }
        }
        this.isOK = ok;
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MethodCustomizer.class, (String)"ACS_MethodNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodCustomizer.class, (String)"ACS_MethodNameTextField"));
        this.browseFQNButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodCustomizer.class, (String)"ACSD_BrowseFQN"));
        this.getAccessibleContext().setAccessibleDescription("ACSD_MethodCustomizerDialog");
    }

    public boolean isOK() {
        if (!this.isInitialized) {
            return false;
        }
        this.nameTextFieldFocusLost(null);
        this.returnTypeComboBoxActionPerformed(null);
        this.handleChangeAndNotify(this.nameTextField.getDocument());
        return this.isOK;
    }

    private static PropertyDescriptor findInfo(Object bean, String name) throws IllegalArgumentException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] descr = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < descr.length; ++i) {
                if (!descr[i].getName().equals(name)) continue;
                return descr[i];
            }
            throw new IllegalArgumentException("No property named " + name + " in class " + bean.getClass());
        }
        catch (IntrospectionException e) {
            IllegalArgumentException iae = new IllegalArgumentException();
            iae.initCause(e);
            throw iae;
        }
    }

    public void enablePrefixForName(String prefix, String errorMessage) {
        if (this.methodNameListener == null) {
            this.methodNameListener = new MethodNameListener();
            this.nameTextField.getDocument().addDocumentListener(this.methodNameListener);
        }
        if (prefix == null) {
            prefix = "";
        }
        if (this.patternStr == null) {
            this.patternStr = "";
        }
        this.patternStr = this.patternStr = prefix.equals("") ? "\\w+" : prefix + "\\w*";
        this.regexErrorMessage = errorMessage;
        this.nameTextField.setText(this.generateUniqueName(this.nameTextField.getText()));
        this.nameTextField.setCaretPosition(prefix.length());
        this.nameTextField.moveCaretPosition(this.nameTextField.getText().length());
    }

    public void enableCheckForSignature(Method[] existingMethods, String errorMessage) {
        ((MDRChangeSource)this.method).addListener(new MDRChangeListener(){

            public void change(MDRChangeEvent e) {
                if (e instanceof AttributeEvent && ((AttributeEvent)e).getAttributeName().equals("parameters")) {
                    MethodCustomizer.this.handleChangeAndNotify(MethodCustomizer.this.nameTextField.getDocument());
                }
            }
        });
        if (existingMethods == null) {
            existingMethods = new Method[]{};
        }
        this.existingMethods = existingMethods;
        this.existingNameErrorMessage = errorMessage;
    }

    private boolean checkReturnType() {
        String typeName = ((JTextComponent)this.returnTypeComboBox.getEditor().getEditorComponent()).getText();
        if (!MethodCustomizer.isValidTypeName(typeName)) {
            this.firePropertyChange(OK_ENABLED, true, false);
            return false;
        }
        this.firePropertyChange(OK_ENABLED, false, true);
        return true;
    }

    private static boolean isValidTypeName(String str) {
        while (str.endsWith("[]")) {
            str = str.substring(0, str.length() - 2);
        }
        String[] identifiers = str.split("\\.");
        for (int i = 0; i < identifiers.length; ++i) {
            if (MethodCustomizer.isJavaIdentifier(identifiers[i])) continue;
            return false;
        }
        return true;
    }

    private static final boolean isJavaIdentifier(String id) {
        if (id == null) {
            return false;
        }
        if (id.equals("")) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesRegex(String patternStr, String input) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    private String generateUniqueName(String name) {
        int uniquifier = 1;
        String newName = name;
        while (!this.handleChange(newName) && Utilities.isJavaIdentifier((String)newName)) {
            newName = name + String.valueOf(uniquifier++);
        }
        return newName;
    }

    private boolean methodExists(String name) {
        if (this.existingMethods == null) {
            return false;
        }
        for (int i = 0; i < this.existingMethods.length; ++i) {
            Method existingMethod = this.existingMethods[i];
            String existingName = existingMethod.getName();
            if (!existingName.equals(name) || !JMIUtils.signaturesEqual(existingMethod, this.method)) continue;
            return true;
        }
        return false;
    }

    private boolean handleChange(String editedName) {
        if (!Utilities.isJavaIdentifier((String)editedName)) {
            this.errorField.setText(NbBundle.getMessage(MethodCustomizer.class, (String)"MSG_Not_Valid_Identifier"));
            return false;
        }
        boolean result = false;
        boolean matches = MethodCustomizer.matchesRegex(this.patternStr, editedName);
        if (!matches) {
            this.errorField.setText(this.regexErrorMessage);
        } else if (this.methodExists(editedName)) {
            this.errorField.setText(this.existingNameErrorMessage);
        } else {
            this.errorField.setText("");
            result = true;
        }
        return result;
    }

    private void handleChangeAndNotify(Document document) {
        block8: {
            if (this.waitingScanFinished) {
                this.firePropertyChange(OK_ENABLED, true, false);
                return;
            }
            if (JavaMetamodel.getManager().isScanInProgress()) {
                this.waitingScanFinished = true;
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        JavaMetamodel.getManager().waitScanFinished();
                        MethodCustomizer.this.waitingScanFinished = false;
                        MethodCustomizer.this.handleChangeAndNotify(MethodCustomizer.this.nameTextField.getDocument());
                    }
                });
                this.firePropertyChange(OK_ENABLED, true, false);
                if (this.errorField != null) {
                    this.errorField.setText(NbBundle.getMessage(MethodCustomizer.class, (String)"LBL_ScanningInProgress"));
                    return;
                }
            }
            try {
                if (!this.checkReturnType()) {
                    return;
                }
                boolean isValid = this.handleChange(document.getText(0, document.getLength()));
                if (isValid) {
                    this.firePropertyChange(OK_ENABLED, false, true);
                } else {
                    this.firePropertyChange(OK_ENABLED, true, false);
                }
            }
            catch (BadLocationException ble) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)ble.getMessage());
            }
        }
    }

    public JCheckBox getLocalCheckbox() {
        return this.localCheckbox;
    }

    public JCheckBox getRemoteCheckbox() {
        return this.remoteCheckbox;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.isOK();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.addPropertyChangeListener(propertyName, listener);
        this.isOK();
    }

    private class MethodNameListener
    implements DocumentListener {
        private MethodNameListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            MethodCustomizer.this.handleChangeAndNotify(e.getDocument());
        }

        public void removeUpdate(DocumentEvent e) {
            MethodCustomizer.this.handleChangeAndNotify(e.getDocument());
        }

        public void changedUpdate(DocumentEvent e) {
            MethodCustomizer.this.handleChangeAndNotify(e.getDocument());
        }
    }
}

