/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ant.Util;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class AntBasedProjectFactorySingleton
implements ProjectFactory {
    public static final String PROJECT_XML_PATH = "nbproject/project.xml";
    public static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    private static final Map project2Helper;
    private static final Map helper2Project;
    private static final Map type2Projects;
    private static final Lookup.Result antBasedProjectTypes;
    private static Map antBasedProjectTypesByType;
    public static AntProjectHelperCallback HELPER_CALLBACK;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static void antBasedProjectTypesRemoved(Set removed) {
        Iterator i = removed.iterator();
        while (i.hasNext()) {
            AntBasedProjectType type = (AntBasedProjectType)i.next();
            List projects = (List)type2Projects.get(type);
            if (projects != null) {
                Iterator prjs = projects.iterator();
                while (prjs.hasNext()) {
                    Reference r = (Reference)prjs.next();
                    Object instance = r.get();
                    if (instance == null) continue;
                    AntProjectHelper helper = (AntProjectHelper)instance;
                    helper.notifyDeleted();
                }
            }
            type2Projects.remove(type);
        }
    }

    private static synchronized AntBasedProjectType findAntBasedProjectType(String type) {
        if (antBasedProjectTypesByType == null) {
            Iterator it = new ArrayList(antBasedProjectTypes.allInstances()).iterator();
            antBasedProjectTypesByType = new HashMap();
            while (it.hasNext()) {
                AntBasedProjectType abpt = (AntBasedProjectType)it.next();
                antBasedProjectTypesByType.put(abpt.getType(), abpt);
            }
        }
        return (AntBasedProjectType)antBasedProjectTypesByType.get(type);
    }

    public boolean isProject(FileObject dir) {
        File dirF = FileUtil.toFile((FileObject)dir);
        if (dirF == null) {
            return false;
        }
        File projectXmlF = new File(new File(dirF, "nbproject"), "project.xml");
        return projectXmlF.isFile();
    }

    public Project loadProject(FileObject projectDirectory, ProjectState state) throws IOException {
        Document projectXml;
        if (FileUtil.toFile((FileObject)projectDirectory) == null) {
            return null;
        }
        FileObject projectFile = projectDirectory.getFileObject(PROJECT_XML_PATH);
        if (projectFile == null || !projectFile.isData() || projectFile.isVirtual()) {
            return null;
        }
        File projectDiskFile = FileUtil.toFile((FileObject)projectFile);
        if (projectDiskFile == null) {
            return null;
        }
        try {
            projectXml = XMLUtil.parse((InputSource)new InputSource(projectDiskFile.toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)Util.defaultErrorHandler(), null);
        }
        catch (SAXException e) {
            IOException ioe = (IOException)new IOException(projectDiskFile + ": " + e.toString()).initCause(e);
            ErrorManager.getDefault().annotate((Throwable)ioe, NbBundle.getMessage((Class)AntBasedProjectFactorySingleton.class, (String)"AntBasedProjectFactorySingleton.parseError", (Object)projectDiskFile.getAbsolutePath(), (Object)e.getMessage()));
            throw ioe;
        }
        Element projectEl = projectXml.getDocumentElement();
        if (!"project".equals(projectEl.getLocalName()) || !PROJECT_NS.equals(projectEl.getNamespaceURI())) {
            return null;
        }
        Element typeEl = Util.findElement(projectEl, "type", PROJECT_NS);
        if (typeEl == null) {
            return null;
        }
        String type = Util.findText(typeEl);
        if (type == null) {
            return null;
        }
        AntBasedProjectType provider = AntBasedProjectFactorySingleton.findAntBasedProjectType(type);
        if (provider == null) {
            return null;
        }
        AntProjectHelper helper = HELPER_CALLBACK.createHelper(projectDirectory, projectXml, state, provider);
        Project project = provider.createProject(helper);
        project2Helper.put(project, new WeakReference<AntProjectHelper>(helper));
        helper2Project.put(helper, new WeakReference<Project>(project));
        ArrayList<WeakReference<AntProjectHelper>> l = (ArrayList<WeakReference<AntProjectHelper>>)type2Projects.get(provider);
        if (l == null) {
            l = new ArrayList<WeakReference<AntProjectHelper>>();
            type2Projects.put(provider, l);
        }
        l.add(new WeakReference<AntProjectHelper>(helper));
        return project;
    }

    public void saveProject(Project project) throws IOException, ClassCastException {
        Reference helperRef = (Reference)project2Helper.get(project);
        if (helperRef == null) {
            throw new ClassCastException(project.getClass().getName());
        }
        AntProjectHelper helper = (AntProjectHelper)helperRef.get();
        if (!$assertionsDisabled && helper == null) {
            throw new AssertionError((Object)("AntProjectHelper collected for " + project));
        }
        HELPER_CALLBACK.save(helper);
    }

    public static Project getProjectFor(AntProjectHelper helper) {
        Reference projectRef = (Reference)helper2Project.get(helper);
        if (!$assertionsDisabled && projectRef == null) {
            throw new AssertionError((Object)("Found a Project reference for " + helper));
        }
        Project p = (Project)projectRef.get();
        if (!$assertionsDisabled && p == null) {
            throw new AssertionError((Object)("Found a non-null Project for " + helper));
        }
        return p;
    }

    public static AntProjectHelper getHelperFor(Project p) {
        Reference helperRef = (Reference)project2Helper.get(p);
        return helperRef != null ? (AntProjectHelper)helperRef.get() : null;
    }

    static {
        block3: {
            $assertionsDisabled = !AntBasedProjectFactorySingleton.class.desiredAssertionStatus();
            project2Helper = new WeakHashMap();
            helper2Project = new WeakHashMap();
            type2Projects = new HashMap();
            antBasedProjectTypesByType = null;
            antBasedProjectTypes = Lookup.getDefault().lookup(new Lookup.Template(AntBasedProjectType.class));
            antBasedProjectTypes.addLookupListener(new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent ev) {
                    Class clazz = class$org$netbeans$modules$project$ant$AntBasedProjectFactorySingleton == null ? (class$org$netbeans$modules$project$ant$AntBasedProjectFactorySingleton = AntBasedProjectFactorySingleton.class$("org.netbeans.modules.project.ant.AntBasedProjectFactorySingleton")) : class$org$netbeans$modules$project$ant$AntBasedProjectFactorySingleton;
                    synchronized (clazz) {
                        Set oldTypes = type2Projects.keySet();
                        HashSet removed = new HashSet(oldTypes);
                        removed.removeAll(antBasedProjectTypes.allInstances());
                        AntBasedProjectFactorySingleton.antBasedProjectTypesRemoved(removed);
                        antBasedProjectTypesByType = null;
                    }
                }
            });
            Class c = AntProjectHelper.class;
            try {
                Class.forName(c.getName(), true, c.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)e);
            }
        }
        if (!$assertionsDisabled && HELPER_CALLBACK == null) {
            throw new AssertionError();
        }
    }

    public static interface AntProjectHelperCallback {
        public AntProjectHelper createHelper(FileObject var1, Document var2, ProjectState var3, AntBasedProjectType var4);

        public void save(AntProjectHelper var1) throws IOException;
    }
}

