/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DataFilesProviderImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.openide.util.Lookup;

public final class ProjectOperations {
    private ProjectOperations() {
    }

    public static List getMetadataFiles(Project prj) {
        ArrayList result = new ArrayList();
        Iterator i = ProjectOperations.getProjectsOperationsImplementation(prj).iterator();
        while (i.hasNext()) {
            result.addAll(((DataFilesProviderImplementation)i.next()).getMetadataFiles());
        }
        return result;
    }

    public static List getDataFiles(Project prj) {
        ArrayList result = new ArrayList();
        Iterator i = ProjectOperations.getProjectsOperationsImplementation(prj).iterator();
        while (i.hasNext()) {
            result.addAll(((DataFilesProviderImplementation)i.next()).getDataFiles());
        }
        return result;
    }

    public static boolean isDeleteOperationSupported(Project prj) {
        return !ProjectOperations.getDeleteOperationImplementation(prj).isEmpty();
    }

    public static void notifyDeleting(Project prj) throws IOException {
        Iterator i = ProjectOperations.getDeleteOperationImplementation(prj).iterator();
        while (i.hasNext()) {
            ((DeleteOperationImplementation)i.next()).notifyDeleting();
        }
    }

    public static void notifyDeleted(Project prj) throws IOException {
        Iterator i = ProjectOperations.getDeleteOperationImplementation(prj).iterator();
        while (i.hasNext()) {
            ((DeleteOperationImplementation)i.next()).notifyDeleted();
        }
    }

    public static boolean isCopyOperationSupported(Project prj) {
        return !ProjectOperations.getCopyOperationImplementation(prj).isEmpty();
    }

    public static void notifyCopying(Project prj) throws IOException {
        Iterator i = ProjectOperations.getCopyOperationImplementation(prj).iterator();
        while (i.hasNext()) {
            ((CopyOperationImplementation)i.next()).notifyCopying();
        }
    }

    public static void notifyCopied(Project original, Project nue, File originalPath, String name) throws IOException {
        Iterator i = ProjectOperations.getCopyOperationImplementation(original).iterator();
        while (i.hasNext()) {
            ((CopyOperationImplementation)i.next()).notifyCopied(null, originalPath, name);
        }
        i = ProjectOperations.getCopyOperationImplementation(nue).iterator();
        while (i.hasNext()) {
            ((CopyOperationImplementation)i.next()).notifyCopied(original, originalPath, name);
        }
    }

    public static void notifyMoving(Project prj) throws IOException {
        Iterator i = ProjectOperations.getMoveOperationImplementation(prj).iterator();
        while (i.hasNext()) {
            ((MoveOperationImplementation)i.next()).notifyMoving();
        }
    }

    public static void notifyMoved(Project original, Project nue, File originalPath, String name) throws IOException {
        Iterator i = ProjectOperations.getMoveOperationImplementation(original).iterator();
        while (i.hasNext()) {
            ((MoveOperationImplementation)i.next()).notifyMoved(null, originalPath, name);
        }
        i = ProjectOperations.getMoveOperationImplementation(nue).iterator();
        while (i.hasNext()) {
            ((MoveOperationImplementation)i.next()).notifyMoved(original, originalPath, name);
        }
    }

    public static boolean isMoveOperationSupported(Project prj) {
        return true;
    }

    private static Collection getDeleteOperationImplementation(Project prj) {
        return prj.getLookup().lookup(new Lookup.Template(DeleteOperationImplementation.class)).allInstances();
    }

    private static Collection getProjectsOperationsImplementation(Project prj) {
        return prj.getLookup().lookup(new Lookup.Template(DataFilesProviderImplementation.class)).allInstances();
    }

    private static Collection getCopyOperationImplementation(Project prj) {
        return prj.getLookup().lookup(new Lookup.Template(CopyOperationImplementation.class)).allInstances();
    }

    private static Collection getMoveOperationImplementation(Project prj) {
        return prj.getLookup().lookup(new Lookup.Template(MoveOperationImplementation.class)).allInstances();
    }
}

