/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.api.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.xml.AntProjectSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TargetLister {
    private static final Map antProjectCookies;
    static final /* synthetic */ boolean $assertionsDisabled;

    private TargetLister() {
    }

    public static Set getTargets(AntProjectCookie script) throws IOException {
        HashSet alreadyImported = new HashSet();
        HashMap<Object, Object> properties = new HashMap<Object, Object>(System.getProperties());
        Script main = new Script(null, script, alreadyImported, properties, Collections.EMPTY_MAP);
        HashSet targets = new HashSet();
        HashSet visitedScripts = new HashSet();
        TargetLister.traverseScripts(main, targets, visitedScripts);
        return targets;
    }

    private static void traverseScripts(Script script, Set targets, Set visitedScripts) throws IOException {
        if (!visitedScripts.add(script.getScript())) {
            return;
        }
        targets.addAll(script.getTargets());
        Iterator it = script.getImports().iterator();
        while (it.hasNext()) {
            Script imported = (Script)it.next();
            TargetLister.traverseScripts(imported, targets, visitedScripts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AntProjectCookie getAntProjectCookie(FileObject fo) {
        AntProjectCookie apc;
        block7: {
            try {
                DataObject d = DataObject.find((FileObject)fo);
                apc = (AntProjectCookie)d.getCookie(AntProjectCookie.class);
                if (apc != null) {
                    return apc;
                }
            }
            catch (DataObjectNotFoundException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)e);
            }
        }
        Map map = antProjectCookies;
        synchronized (map) {
            apc = (AntProjectCookie)antProjectCookies.get(fo);
            if (apc == null) {
                apc = new AntProjectSupport(fo);
                antProjectCookies.put(fo, apc);
            }
            return apc;
        }
    }

    static {
        $assertionsDisabled = !TargetLister.class.desiredAssertionStatus();
        antProjectCookies = new WeakHashMap();
    }

    private static final class Script {
        private final AntProjectCookie apc;
        private final Script importingScript;
        private final Map targets;
        private final String defaultTarget;
        private final List imports;
        private final String name;
        private final Set alreadyImported;
        private static final Set TRUE_VALS;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Script(Script importingScript, AntProjectCookie apc, Set alreadyImported, Map inheritedPropertyDefs, Map inheritedMacroDefs) throws IOException {
            String _defaultTarget;
            this.importingScript = importingScript;
            this.apc = apc;
            this.alreadyImported = alreadyImported;
            Element prj = apc.getProjectElement();
            if (prj == null) {
                throw new IOException("Could not parse " + apc);
            }
            File prjFile = apc.getFile();
            if (prjFile != null) {
                alreadyImported.add(prjFile);
            }
            this.defaultTarget = (_defaultTarget = prj.getAttribute("default")).length() > 0 ? _defaultTarget : null;
            String _name = prj.getAttribute("name");
            this.name = _name.length() > 0 ? _name : null;
            String basedirS = prj.getAttribute("basedir");
            File _basedir = new File(basedirS = basedirS.length() == 0 ? "." : basedirS.replace('/', File.separatorChar).replace('\\', File.separatorChar));
            File basedir = _basedir.isAbsolute() ? _basedir : (prjFile != null ? new File(prjFile.getParentFile(), basedirS) : null);
            this.targets = new HashMap();
            HashMap<String, String> propertyDefs = new HashMap<String, String>(inheritedPropertyDefs);
            if (basedir != null && !propertyDefs.containsKey("basedir")) {
                propertyDefs.put("basedir", basedir.getAbsolutePath());
            }
            HashMap macroDefs = new HashMap(inheritedMacroDefs);
            this.imports = new ArrayList();
            this.interpretTasks(alreadyImported, prj, basedir, propertyDefs, macroDefs, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void interpretTasks(Set alreadyImported, Element container, File basedir, Map propertyDefs, Map macroDefs, Map macroParams) throws IOException {
            NodeList nl = container.getChildNodes();
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                String name;
                Element macro;
                String elName;
                Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                Element el = (Element)n;
                String fullname = elName = el.getLocalName();
                String uri = el.getNamespaceURI();
                if (uri != null) {
                    fullname = uri + '#' + fullname;
                }
                if ((macro = (Element)macroDefs.get(fullname)) != null) {
                    HashMap<String, String> newMacroParams = new HashMap<String, String>();
                    NodeList macroKids = macro.getChildNodes();
                    for (int j = 0; j < macroKids.getLength(); ++j) {
                        if (macroKids.item(j).getNodeType() != 1) continue;
                        Element el2 = (Element)macroKids.item(j);
                        String elName2 = el2.getLocalName();
                        if (elName2.equals("attribute")) {
                            String attrVal;
                            String attrValSubst;
                            String attrName = el2.getAttribute("name");
                            if (attrName.length() == 0 || (attrValSubst = Script.replaceAntProperties(attrVal = el.getAttribute(attrName), propertyDefs)) == null) continue;
                            newMacroParams.put(attrName, attrValSubst);
                            continue;
                        }
                        if (!elName2.equals("sequential")) continue;
                        this.interpretTasks(alreadyImported, el2, basedir, propertyDefs, macroDefs, newMacroParams);
                    }
                    continue;
                }
                if (macroParams == null && elName.equals("target")) {
                    name = el.getAttribute("name");
                    this.targets.put(name, new Target(this, el, name));
                    continue;
                }
                if (macroParams == null && elName.equals("import")) {
                    File file;
                    String fileS = el.getAttribute("file").replace('/', File.separatorChar).replace('\\', File.separatorChar);
                    String fileSubstituted = Script.replaceAntProperties(fileS, propertyDefs);
                    if (fileSubstituted.indexOf("${") != -1) continue;
                    File _file = new File(fileSubstituted);
                    if (_file.isAbsolute()) {
                        file = _file;
                    } else {
                        if (this.apc.getFile() == null) {
                            throw new IOException("Cannot import relative path " + fileS + " from a diskless script");
                        }
                        file = new File(this.apc.getFile().getParentFile(), fileSubstituted);
                    }
                    if (alreadyImported.contains(file)) continue;
                    if (file.canRead()) {
                        FileObject fileObj = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                        if (!$assertionsDisabled && fileObj == null) {
                            throw new AssertionError(file);
                        }
                        AntProjectCookie importedApc = TargetLister.getAntProjectCookie(fileObj);
                        this.imports.add(new Script(this, importedApc, alreadyImported, propertyDefs, macroDefs));
                        continue;
                    }
                    String optionalS = el.getAttribute("optional");
                    boolean optional = TRUE_VALS.contains(optionalS.toLowerCase(Locale.US));
                    if (optional) continue;
                    throw new IOException("Cannot find import " + file + " from " + this.apc);
                }
                if (elName.equals("property")) {
                    if (el.hasAttribute("value")) {
                        name = Script.replaceMacroParams(el.getAttribute("name"), macroParams);
                        if (name.length() == 0 || propertyDefs.containsKey(name)) continue;
                        String value = Script.replaceMacroParams(el.getAttribute("value"), macroParams);
                        String valueSubst = Script.replaceAntProperties(value, propertyDefs);
                        propertyDefs.put(name, valueSubst);
                        continue;
                    }
                    String file = Script.replaceMacroParams(el.getAttribute("file"), macroParams);
                    if (file.length() <= 0) continue;
                    String fileSubst = Script.replaceAntProperties(file, propertyDefs);
                    File propertyFile = new File(fileSubst);
                    if (!propertyFile.isAbsolute() && basedir != null) {
                        propertyFile = new File(basedir, fileSubst.replace('/', File.separatorChar).replace('\\', File.separatorChar));
                    }
                    if (!propertyFile.canRead()) continue;
                    Properties p = new Properties();
                    FileInputStream is = new FileInputStream(propertyFile);
                    try {
                        p.load(is);
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                    Map evaluatedProperties = Script.evaluateAll(propertyDefs, Collections.singletonList(p));
                    if (evaluatedProperties == null) continue;
                    Iterator it = evaluatedProperties.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        String k = (String)entry.getKey();
                        if (propertyDefs.containsKey(k)) continue;
                        propertyDefs.put(k, (String)entry.getValue());
                    }
                    continue;
                }
                if (!elName.equals("macrodef") || (name = el.getAttribute("name")).length() == 0) continue;
                uri = el.getAttribute("uri");
                if (uri.length() > 0) {
                    name = uri + '#' + name;
                }
                if (macroDefs.containsKey(name)) continue;
                macroDefs.put(name, el);
            }
        }

        private static String replaceMacroParams(String rawval, Map defs) {
            if (rawval.indexOf(64) == -1) {
                return rawval;
            }
            int idx = 0;
            StringBuffer val = new StringBuffer();
            while (true) {
                int monkey;
                if ((monkey = rawval.indexOf(64, idx)) == -1 || monkey == rawval.length() - 1) {
                    val.append(rawval.substring(idx));
                    return val.toString();
                }
                char c = rawval.charAt(monkey + 1);
                if (c == '{') {
                    int end = rawval.indexOf(125, monkey + 2);
                    if (end != -1) {
                        String otherprop = rawval.substring(monkey + 2, end);
                        if (defs.containsKey(otherprop)) {
                            val.append(rawval.substring(idx, monkey));
                            val.append((String)defs.get(otherprop));
                        } else {
                            val.append(rawval.substring(idx, end + 1));
                        }
                        idx = end + 1;
                        continue;
                    }
                    val.append(rawval.substring(idx));
                    return val.toString();
                }
                val.append(rawval.substring(idx, idx + 2));
                idx += 2;
            }
        }

        private static String replaceAntProperties(String rawval, Map defs) {
            return (String)Script.subst(rawval, defs, Collections.EMPTY_SET);
        }

        private static Map evaluateAll(Map predefs, List defs) {
            HashMap<String, String> m = new HashMap<String, String>(predefs);
            Iterator it = defs.iterator();
            while (it.hasNext()) {
                List sorted;
                Map curr = (Map)it.next();
                HashMap<String, Set> dependOnSiblings = new HashMap<String, Set>();
                Iterator it2 = curr.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry entry = it2.next();
                    String prop = (String)entry.getKey();
                    if (m.containsKey(prop)) continue;
                    String rawval = (String)entry.getValue();
                    Object o = Script.subst(rawval, m, curr.keySet());
                    if (o instanceof String) {
                        m.put(prop, (String)o);
                        continue;
                    }
                    dependOnSiblings.put(prop, (Set)o);
                }
                HashSet toSort = new HashSet(dependOnSiblings.keySet());
                it2 = dependOnSiblings.values().iterator();
                while (it2.hasNext()) {
                    toSort.addAll((Set)((Object)it2.next()));
                }
                try {
                    sorted = Utilities.topologicalSort(toSort, dependOnSiblings);
                }
                catch (TopologicalSortException e) {
                    return null;
                }
                Collections.reverse(sorted);
                it2 = sorted.iterator();
                while (it2.hasNext()) {
                    String prop = (String)((Object)it2.next());
                    if (m.containsKey(prop)) continue;
                    String rawval = (String)curr.get(prop);
                    m.put(prop, (String)Script.subst(rawval, m, curr.keySet()));
                }
            }
            return m;
        }

        private static Object subst(String rawval, Map predefs, Set siblingProperties) {
            if (!$assertionsDisabled && rawval == null) {
                throw new AssertionError((Object)"null rawval passed in");
            }
            if (rawval.indexOf(36) == -1) {
                return rawval;
            }
            int idx = 0;
            StringBuffer val = new StringBuffer();
            HashSet<String> needed = new HashSet<String>();
            while (true) {
                int shell;
                if ((shell = rawval.indexOf(36, idx)) == -1 || shell == rawval.length() - 1) {
                    if (needed.isEmpty()) {
                        val.append(rawval.substring(idx));
                        return val.toString();
                    }
                    return needed;
                }
                char c = rawval.charAt(shell + 1);
                if (c == '$') {
                    if (needed.isEmpty()) {
                        val.append('$');
                    }
                    idx += 2;
                    continue;
                }
                if (c == '{') {
                    int end = rawval.indexOf(125, shell + 2);
                    if (end != -1) {
                        String otherprop = rawval.substring(shell + 2, end);
                        if (predefs.containsKey(otherprop)) {
                            if (needed.isEmpty()) {
                                val.append(rawval.substring(idx, shell));
                                val.append((String)predefs.get(otherprop));
                            }
                            idx = end + 1;
                            continue;
                        }
                        if (siblingProperties.contains(otherprop)) {
                            needed.add(otherprop);
                            idx = end + 1;
                            continue;
                        }
                        if (needed.isEmpty()) {
                            val.append(rawval.substring(idx, end + 1));
                        }
                        idx = end + 1;
                        continue;
                    }
                    if (needed.isEmpty()) {
                        val.append(rawval.substring(idx));
                        return val.toString();
                    }
                    return needed;
                }
                if (needed.isEmpty()) {
                    val.append(rawval.substring(idx, idx + 2));
                }
                idx += 2;
            }
        }

        public AntProjectCookie getScript() {
            return this.apc;
        }

        public String getName() {
            return this.name;
        }

        public Collection getTargets() {
            return this.targets.values();
        }

        public String getDefaultTargetName() {
            return this.defaultTarget;
        }

        public Collection getImports() {
            return this.imports;
        }

        public Script getImportingScript() {
            return this.importingScript;
        }

        public Script getMainScript() {
            if (this.importingScript != null) {
                return this.importingScript.getMainScript();
            }
            return this;
        }

        public boolean defines(String targetName) {
            if (!this.targets.containsKey(targetName)) {
                return false;
            }
            Script s = this.importingScript;
            while (s != null) {
                if (s.targets.containsKey(targetName)) {
                    return false;
                }
                s = s.importingScript;
            }
            return true;
        }

        static {
            $assertionsDisabled = !(class$org$apache$tools$ant$module$api$support$TargetLister == null ? (class$org$apache$tools$ant$module$api$support$TargetLister = TargetLister.class$("org.apache.tools.ant.module.api.support.TargetLister")) : class$org$apache$tools$ant$module$api$support$TargetLister).desiredAssertionStatus();
            TRUE_VALS = new HashSet(5);
            TRUE_VALS.add("true");
            TRUE_VALS.add("yes");
            TRUE_VALS.add("on");
        }
    }

    public static final class Target {
        private final Script script;
        private final Element el;
        private final String name;

        Target(Script script, Element el, String name) {
            this.script = script;
            this.el = el;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getQualifiedName() {
            String n = this.script.getName();
            if (n != null) {
                return n + '.' + this.getName();
            }
            return this.getName();
        }

        public Element getElement() {
            return this.el;
        }

        public AntProjectCookie getScript() {
            return this.script.getScript();
        }

        public boolean isDescribed() {
            return this.el.getAttribute("description").length() > 0;
        }

        public boolean isInternal() {
            String n = this.getName();
            return n.length() > 0 && n.charAt(0) == '-';
        }

        public boolean isOverridden() {
            return !this.script.defines(this.getName());
        }

        public boolean isDefault() {
            return !this.isOverridden() && this.getName().equals(this.script.getMainScript().getDefaultTargetName());
        }

        public String toString() {
            return "Target " + this.getName() + " in " + this.getScript();
        }
    }
}

