/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.APIAccessor;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.SPIAccessor;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.AccessorImpl;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandler;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.openide.filesystems.FileObject;

public final class RefactoringElementsBag {
    private final List delegate;
    private final RefactoringSession session;
    private Collection readOnlyFiles = new HashSet();

    RefactoringElementsBag(RefactoringSession session, List delegate) {
        this.session = session;
        this.delegate = delegate;
    }

    public Problem add(AbstractRefactoring refactoring, RefactoringElementImplementation el) {
        Problem p = null;
        if (CheckUtils.isRefactoringElementReadOnly(el)) {
            Resource resource = el.getJavaElement().getResource();
            FileObject file = resource == null ? el.getParentFile() : JavaModel.getFileObject((Resource)resource);
            this.readOnlyFiles.add(file);
            el.setEnabled(false);
            el.setStatus(3);
            this.delegate.add(el);
        } else if (CheckUtils.isRefactoringElementGuarded(el)) {
            Iterator pIt = APIAccessor.DEFAULT.getGBHandlers(refactoring).iterator();
            ArrayList proposedChanges = new ArrayList();
            while (pIt.hasNext()) {
                GuardedBlockHandler ref = (GuardedBlockHandler)pIt.next();
                p = APIAccessor.DEFAULT.chainProblems(ref.handleChange(el, proposedChanges), p);
                if (p != null && p.isFatal()) {
                    return p;
                }
                if (proposedChanges.isEmpty()) continue;
                this.delegate.addAll(proposedChanges);
                return p;
            }
            el.setEnabled(false);
            el.setStatus(2);
            this.delegate.add(el);
        } else {
            this.delegate.add(el);
        }
        return p;
    }

    public Problem addAll(AbstractRefactoring refactoring, Collection c) {
        Problem p = null;
        Iterator e = c.iterator();
        while (e.hasNext()) {
            if ((p = APIAccessor.DEFAULT.chainProblems(p, this.add(refactoring, (RefactoringElementImplementation)e.next()))) == null || !p.isFatal()) continue;
            return p;
        }
        return p;
    }

    public RefactoringSession getSession() {
        return this.session;
    }

    Collection getReadOnlyFiles() {
        return this.readOnlyFiles;
    }

    static {
        SPIAccessor.DEFAULT = new AccessorImpl();
    }
}

