/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api;

import java.util.List;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.classpath.Util;

public final class AnonymousToInnerRefactoring
extends AbstractRefactoring {
    private ClassDefinition classDefinition;
    private String name;
    private int modifiers;
    private ParameterInfo[] paramTable;

    public AnonymousToInnerRefactoring(ClassDefinition classDef) {
        this.classDefinition = classDef;
        this.modifiers = 2;
        if (this.classDefinition != null) {
            JavaClass superType = null;
            JavaClass superClass = this.classDefinition.getSuperClass();
            if (superClass != null && !"java.lang.Object".equals(superClass.getName())) {
                superType = superClass;
            } else {
                List list = this.classDefinition.getInterfaces();
                if (list.size() > 0) {
                    superType = (JavaClass)list.get(0);
                }
            }
            this.name = superType != null ? "My" + superType.getSimpleName() : null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public ParameterInfo[] getParamTable() {
        return this.paramTable;
    }

    public void setParamTable(ParameterInfo[] parTable) {
        this.paramTable = parTable;
    }

    public ClassDefinition getClassDefinition() {
        return this.classDefinition;
    }

    protected void setClassPath() {
        Util.setClassPath((Element)this.classDefinition);
    }

    public static final class ParameterInfo {
        String name;
        Variable variable;

        public ParameterInfo(Variable var) {
            if (var == null) {
                throw new IllegalArgumentException();
            }
            this.name = var.getName();
            this.variable = var;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String n) {
            this.name = n;
        }

        public Variable getVariable() {
            return this.variable;
        }
    }
}

