/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.project.SourceRoots;
import org.netbeans.modules.web.project.UpdateHelper;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.WebViews;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class WebPhysicalViewProvider
implements LogicalViewProvider {
    private static final RequestProcessor BROKEN_LINKS_RP = new RequestProcessor("WebPhysicalViewProvider.BROKEN_LINKS_RP");
    private final WebProject project;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final SubprojectProvider spp;
    private final ReferenceHelper resolver;
    private List changeListeners;
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"javac.classpath", "debug.classpath", "run.test.classpath", "debug.test.classpath", "javac.test.classpath", "war.content.additional", "web.docbase.dir"};
    private static Image brokenProjectBadge = Utilities.loadImage((String)"org/netbeans/modules/web/project/ui/resources/brokenProjectBadge.gif");

    public WebPhysicalViewProvider(WebProject project, UpdateHelper helper, PropertyEvaluator evaluator, SubprojectProvider spp, ReferenceHelper resolver) {
        this.project = project;
        assert (project != null);
        this.helper = helper;
        assert (helper != null);
        this.evaluator = evaluator;
        assert (evaluator != null);
        this.spp = spp;
        assert (spp != null);
        this.resolver = resolver;
    }

    public Node createLogicalView() {
        return new WebLogicalViewRootNode();
    }

    public Node findPath(Node root, Object target) {
        Project project = (Project)root.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (target instanceof FileObject) {
            FileObject fo = (FileObject)target;
            Project owner = FileOwnerQuery.getOwner((FileObject)fo);
            if (!project.equals(owner)) {
                return null;
            }
            Node[] nodes = root.getChildren().getNodes(true);
            for (int i = nodes.length - 1; i >= 0; --i) {
                Node result = PackageView.findPath((Node)nodes[i], (Object)target);
                if (result == null) continue;
                return result;
            }
            Node result = this.findNodeInConfigFiles(root, fo);
            if (result != null) {
                return result;
            }
            result = this.findNodeInDocBase(root, fo);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    private Node findNodeInDocBase(Node root, FileObject fo) {
        FileObject rootfo = this.helper.getAntProjectHelper().resolveFileObject(this.evaluator.getProperty("web.docbase.dir"));
        String relPath = FileUtil.getRelativePath((FileObject)rootfo, (FileObject)fo);
        if (relPath == null) {
            return null;
        }
        int idx = relPath.lastIndexOf(46);
        if (idx != -1) {
            relPath = relPath.substring(0, idx);
        }
        StringTokenizer st = new StringTokenizer(relPath, "/");
        Node result = NodeOp.findChild((Node)root, (String)rootfo.getName());
        while (st.hasMoreTokens()) {
            result = NodeOp.findChild((Node)result, (String)st.nextToken());
        }
        return result;
    }

    private Node findNodeInConfigFiles(Node root, FileObject fo) {
        String nodeName;
        try {
            DataObject dobj = DataObject.find((FileObject)fo);
            nodeName = dobj.getName();
        }
        catch (DataObjectNotFoundException e) {
            nodeName = fo.getName();
        }
        Node configFiles = root.getChildren().findChild("configurationFiles");
        if (configFiles == null) {
            return null;
        }
        return NodeOp.findChild((Node)configFiles, (String)nodeName);
    }

    public synchronized void addChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        this.changeListeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBroken() {
        ChangeListener[] _listeners;
        WebPhysicalViewProvider webPhysicalViewProvider = this;
        synchronized (webPhysicalViewProvider) {
            if (this.changeListeners == null) {
                return;
            }
            _listeners = this.changeListeners.toArray(new ChangeListener[this.changeListeners.size()]);
        }
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < _listeners.length; ++i) {
            _listeners[i].stateChanged(event);
        }
    }

    private static Lookup createLookup(Project project) {
        DataFolder rootFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        return Lookups.fixed((Object[])new Object[]{project, rootFolder});
    }

    public boolean hasBrokenLinks() {
        return BrokenReferencesSupport.isBroken((AntProjectHelper)this.helper.getAntProjectHelper(), (ReferenceHelper)this.resolver, (String[])this.getBreakableProperties(), (String[])new String[]{"platform.active"});
    }

    private String[] getBreakableProperties() {
        SourceRoots roots = this.project.getSourceRoots();
        String[] srcRootProps = roots.getRootProperties();
        roots = this.project.getTestSourceRoots();
        String[] testRootProps = roots.getRootProperties();
        String[] result = new String[BREAKABLE_PROPERTIES.length + srcRootProps.length + testRootProps.length];
        System.arraycopy(BREAKABLE_PROPERTIES, 0, result, 0, BREAKABLE_PROPERTIES.length);
        System.arraycopy(srcRootProps, 0, result, BREAKABLE_PROPERTIES.length, srcRootProps.length);
        System.arraycopy(testRootProps, 0, result, BREAKABLE_PROPERTIES.length + srcRootProps.length, testRootProps.length);
        return result;
    }

    public static class Actions {
        private Actions() {
        }

        public static Action createAction(String key, String name, boolean global) {
            return new ActionImpl(key, name, (Lookup)(global ? Utilities.actionsGlobalContext() : null));
        }

        private static class ActionImpl
        extends AbstractAction
        implements ContextAwareAction {
            Lookup context;
            String name;
            String command;

            public ActionImpl(String command, String name, Lookup context) {
                super(name);
                this.context = context;
                this.command = command;
                this.name = name;
            }

            public void actionPerformed(ActionEvent e) {
                Project project = (Project)this.context.lookup(Project.class);
                ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
                ap.invokeAction(this.command, this.context);
            }

            public Action createContextAwareInstance(Lookup lookup) {
                return new ActionImpl(this.command, this.name, lookup);
            }
        }
    }

    private final class WebLogicalViewRootNode
    extends AbstractNode
    implements Runnable,
    FileStatusListener,
    ChangeListener,
    PropertyChangeListener {
        private Lookup lookup;
        private Action brokenLinksAction;
        private BrokenServerAction brokenServerAction;
        private boolean broken;
        private Set files;
        private Map fileSystemListeners;
        private RequestProcessor.Task task;
        private final Object privateLock;
        private boolean iconChange;
        private boolean nameChange;
        private ChangeListener sourcesListener;
        private Map groupsListeners;

        public WebLogicalViewRootNode() {
            super((Children)new WebViews.LogicalViewChildren(WebPhysicalViewProvider.this.project, WebPhysicalViewProvider.this.helper, WebPhysicalViewProvider.this.evaluator, WebPhysicalViewProvider.this.resolver), WebPhysicalViewProvider.createLookup(WebPhysicalViewProvider.this.project));
            this.privateLock = new Object();
            this.setIconBase("org/netbeans/modules/web/project/ui/resources/webProjectIcon");
            super.setName(ProjectUtils.getInformation((Project)WebPhysicalViewProvider.this.project).getDisplayName());
            if (WebPhysicalViewProvider.this.hasBrokenLinks()) {
                this.broken = true;
            }
            this.brokenLinksAction = new BrokenLinksAction();
            this.brokenServerAction = new BrokenServerAction();
            J2eeModuleProvider moduleProvider = (J2eeModuleProvider)WebPhysicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            moduleProvider.addInstanceListener((InstanceListener)WeakListeners.create(InstanceListener.class, (EventListener)this.brokenServerAction, (Object)moduleProvider));
            this.setProjectFiles(WebPhysicalViewProvider.this.project);
        }

        protected final void setProjectFiles(Project project) {
            Sources sources = ProjectUtils.getSources((Project)project);
            if (this.sourcesListener == null) {
                this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
                sources.addChangeListener(this.sourcesListener);
            }
            this.setGroups(Arrays.asList(sources.getSourceGroups("generic")));
        }

        private final void setGroups(Collection groups) {
            if (this.groupsListeners != null) {
                for (SourceGroup group : this.groupsListeners.keySet()) {
                    PropertyChangeListener pcl = (PropertyChangeListener)this.groupsListeners.get(group);
                    group.removePropertyChangeListener(pcl);
                }
            }
            this.groupsListeners = new HashMap();
            HashSet<FileObject> roots = new HashSet<FileObject>();
            for (SourceGroup group : groups) {
                PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group);
                this.groupsListeners.put(group, pcl);
                group.addPropertyChangeListener(pcl);
                FileObject fo = group.getRootFolder();
                if (WebPhysicalViewProvider.this.project.getProjectDirectory().equals(fo)) {
                    Enumeration en = WebPhysicalViewProvider.this.project.getProjectDirectory().getChildren(false);
                    while (en.hasMoreElements()) {
                        FileObject child = (FileObject)en.nextElement();
                        if (FileOwnerQuery.getOwner((FileObject)child) != WebPhysicalViewProvider.this.project) continue;
                        roots.add(child);
                    }
                    continue;
                }
                roots.add(fo);
            }
            this.setFiles(roots);
        }

        protected final void setFiles(Set files) {
            if (this.fileSystemListeners != null) {
                for (FileSystem fs : this.fileSystemListeners.keySet()) {
                    FileStatusListener fsl = (FileStatusListener)this.fileSystemListeners.get(fs);
                    fs.removeFileStatusListener(fsl);
                }
            }
            this.fileSystemListeners = new HashMap();
            this.files = files;
            if (files == null) {
                return;
            }
            Iterator<Object> it = files.iterator();
            HashSet<FileSystem> hookedFileSystems = new HashSet<FileSystem>();
            while (it.hasNext()) {
                FileObject fo = (FileObject)it.next();
                try {
                    FileSystem fs = fo.getFileSystem();
                    if (hookedFileSystems.contains(fs)) continue;
                    hookedFileSystems.add(fs);
                    FileStatusListener fsl = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fs);
                    fs.addFileStatusListener(fsl);
                    this.fileSystemListeners.put(fs, fsl);
                }
                catch (FileStateInvalidException e) {
                    ErrorManager err = ErrorManager.getDefault();
                    err.annotate((Throwable)e, "Can not get " + fo + " filesystem, ignoring...");
                    err.notify(1, (Throwable)e);
                }
            }
        }

        public Image getIcon(int type) {
            Image img = this.getMyIcon(type);
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    FileObject fo = (FileObject)this.files.iterator().next();
                    img = fo.getFileSystem().getStatus().annotateIcon(img, type, this.files);
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            return img;
        }

        public Image getOpenedIcon(int type) {
            Image img = this.getMyOpenedIcon(type);
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    FileObject fo = (FileObject)this.files.iterator().next();
                    img = fo.getFileSystem().getStatus().annotateIcon(img, type, this.files);
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            return img;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean fireName;
            boolean fireIcon;
            Object object = this.privateLock;
            synchronized (object) {
                fireIcon = this.iconChange;
                fireName = this.nameChange;
                this.iconChange = false;
                this.nameChange = false;
            }
            if (fireIcon) {
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
            if (fireName) {
                this.fireDisplayNameChange(null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent event) {
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create((Runnable)this);
            }
            Object object = this.privateLock;
            synchronized (object) {
                if (!this.iconChange && event.isIconChange() || !this.nameChange && event.isNameChange()) {
                    for (FileObject fo : this.files) {
                        if (!event.hasChanged(fo)) continue;
                        this.iconChange |= event.isIconChange();
                        this.nameChange |= event.isNameChange();
                    }
                }
            }
            this.task.schedule(50);
        }

        public void stateChanged(ChangeEvent e) {
            this.setProjectFiles(WebPhysicalViewProvider.this.project);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.setProjectFiles(WebPhysicalViewProvider.this.project);
        }

        public Image getMyIcon(int type) {
            Image original = super.getIcon(type);
            return this.broken || this.brokenServerAction.isEnabled() ? Utilities.mergeImages((Image)original, (Image)brokenProjectBadge, (int)8, (int)0) : original;
        }

        public Image getMyOpenedIcon(int type) {
            Image original = super.getOpenedIcon(type);
            return this.broken || this.brokenServerAction.isEnabled() ? Utilities.mergeImages((Image)original, (Image)brokenProjectBadge, (int)8, (int)0) : original;
        }

        public String getHtmlDisplayName() {
            String dispName = super.getDisplayName();
            try {
                dispName = XMLUtil.toElementContent((String)dispName);
            }
            catch (CharConversionException charConversionException) {
                // empty catch block
            }
            return this.broken || this.brokenServerAction.isEnabled() ? "<font color=\"#A40000\">" + dispName + "</font>" : null;
        }

        public Action[] getActions(boolean context) {
            if (context) {
                return super.getActions(true);
            }
            return this.getAdditionalActions();
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String s) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)WebPhysicalViewProvider.this.project, (String)s);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(WebLogicalViewRootNode.class);
        }

        private Action[] getAdditionalActions() {
            ResourceBundle bundle = NbBundle.getBundle(WebPhysicalViewProvider.class);
            J2eeModuleProvider provider = (J2eeModuleProvider)WebPhysicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            ArrayList<Action> actions = new ArrayList<Action>(30);
            actions.add(CommonProjectActions.newFileAction());
            actions.add(null);
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)bundle.getString("LBL_BuildAction_Name"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)bundle.getString("LBL_RebuildAction_Name"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)bundle.getString("LBL_CleanAction_Name"), null));
            if (provider != null && provider.hasVerifierSupport()) {
                actions.add(ProjectSensitiveActions.projectCommandAction((String)"verify", (String)bundle.getString("LBL_VerifyAction_Name"), null));
            }
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"javadoc", (String)bundle.getString("LBL_JavadocAction_Name"), null));
            actions.add(null);
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)bundle.getString("LBL_RunAction_Name"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)bundle.getString("LBL_DebugAction_Name"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"redeploy", (String)bundle.getString("LBL_RedeployAction_Name"), null));
            actions.add(null);
            actions.add(CommonProjectActions.setAsMainProjectAction());
            actions.add(CommonProjectActions.openSubprojectsAction());
            actions.add(CommonProjectActions.closeProjectAction());
            actions.add(null);
            actions.add(CommonProjectActions.renameProjectAction());
            actions.add(CommonProjectActions.moveProjectAction());
            actions.add(CommonProjectActions.copyProjectAction());
            actions.add(CommonProjectActions.deleteProjectAction());
            actions.add(null);
            actions.add((Action)SystemAction.get(FindAction.class));
            try {
                Repository repository = Repository.getDefault();
                FileSystem sfs = repository.getDefaultFileSystem();
                FileObject fo = sfs.findResource("Projects/Actions");
                if (fo != null) {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    FolderLookup actionRegistry = new FolderLookup((DataObject.Container)((DataFolder)dobj));
                    Lookup.Template query = new Lookup.Template(Object.class);
                    Lookup lookup = actionRegistry.getLookup();
                    Iterator it = lookup.lookup(query).allInstances().iterator();
                    if (it.hasNext()) {
                        actions.add(null);
                    }
                    while (it.hasNext()) {
                        Object next = it.next();
                        if (next instanceof Action) {
                            actions.add((Action)next);
                            continue;
                        }
                        if (!(next instanceof JSeparator)) continue;
                        actions.add(null);
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            actions.add(null);
            actions.add((Action)SystemAction.get(ToolsAction.class));
            actions.add(null);
            if (this.brokenLinksAction != null && this.brokenLinksAction.isEnabled()) {
                actions.add(this.brokenLinksAction);
            }
            if (this.brokenServerAction.isEnabled()) {
                actions.add(this.brokenServerAction);
            }
            actions.add(CommonProjectActions.customizeProjectAction());
            return actions.toArray(new Action[actions.size()]);
        }

        private class BrokenServerAction
        extends AbstractAction
        implements InstanceListener,
        PropertyChangeListener {
            private boolean brokenServer;

            public BrokenServerAction() {
                this.putValue("Name", NbBundle.getMessage(WebPhysicalViewProvider.class, (String)"LBL_Fix_Missing_Server_Action"));
                WebPhysicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
                this.checkMissingServer();
            }

            public boolean isEnabled() {
                return this.brokenServer;
            }

            public void actionPerformed(ActionEvent e) {
                String j2eeSpec = WebPhysicalViewProvider.this.helper.getProperties("nbproject/project.properties").getProperty("j2ee.platform");
                String instance = BrokenServerSupport.selectServer((String)j2eeSpec, (Object)J2eeModule.WAR);
                if (instance != null) {
                    WebProjectProperties.setServerInstance(WebPhysicalViewProvider.this.project, WebPhysicalViewProvider.this.helper, instance);
                }
                this.checkMissingServer();
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if ("j2ee.server.instance".equals(evt.getPropertyName())) {
                    this.checkMissingServer();
                }
            }

            public void changeDefaultInstance(String oldServerInstanceID, String newServerInstanceID) {
            }

            public void instanceAdded(String serverInstanceID) {
                this.checkMissingServer();
            }

            public void instanceRemoved(String serverInstanceID) {
                this.checkMissingServer();
            }

            private void checkMissingServer() {
                boolean old = this.brokenServer;
                String servInstID = WebPhysicalViewProvider.this.evaluator.getProperty("j2ee.server.instance");
                this.brokenServer = BrokenServerSupport.isBroken((String)servInstID);
                if (old != this.brokenServer) {
                    WebLogicalViewRootNode.this.fireIconChange();
                    WebLogicalViewRootNode.this.fireOpenedIconChange();
                    WebLogicalViewRootNode.this.fireDisplayNameChange(null, null);
                }
            }
        }

        private class BrokenLinksAction
        extends AbstractAction
        implements PropertyChangeListener,
        ChangeListener,
        Runnable {
            private RequestProcessor.Task task = null;
            private PropertyChangeListener weakPCL;

            public BrokenLinksAction() {
                this.putValue("Name", NbBundle.getMessage(WebPhysicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
                this.setEnabled(WebLogicalViewRootNode.this.broken);
                WebPhysicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
                this.weakPCL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)JavaPlatformManager.getDefault());
                JavaPlatformManager.getDefault().addPropertyChangeListener(this.weakPCL);
                WebPhysicalViewProvider.this.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)WebPhysicalViewProvider.this));
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    WebPhysicalViewProvider.this.helper.requestSave();
                    BrokenReferencesSupport.showCustomizer((AntProjectHelper)WebPhysicalViewProvider.this.helper.getAntProjectHelper(), (ReferenceHelper)WebPhysicalViewProvider.this.resolver, (String[])WebPhysicalViewProvider.this.getBreakableProperties(), (String[])new String[]{"platform.active"});
                    this.run();
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }

            public void propertyChange(PropertyChangeEvent evt) {
                this.refsMayChanged();
            }

            public void stateChanged(ChangeEvent evt) {
                this.refsMayChanged();
            }

            public synchronized void run() {
                boolean old = WebLogicalViewRootNode.this.broken;
                WebLogicalViewRootNode.this.broken = WebPhysicalViewProvider.this.hasBrokenLinks();
                if (old != WebLogicalViewRootNode.this.broken) {
                    this.setEnabled(WebLogicalViewRootNode.this.broken);
                    WebLogicalViewRootNode.this.fireIconChange();
                    WebLogicalViewRootNode.this.fireOpenedIconChange();
                    WebLogicalViewRootNode.this.fireDisplayNameChange(null, null);
                    WebPhysicalViewProvider.this.project.getWebProjectProperties().save();
                }
            }

            public void refsMayChanged() {
                if (this.task == null) {
                    this.task = BROKEN_LINKS_RP.create((Runnable)this);
                }
                this.task.schedule(100);
            }
        }
    }
}

