/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.project.ui.ActionFilterNode;
import org.netbeans.modules.web.project.ui.LibrariesNode;
import org.netbeans.modules.web.project.ui.LibrariesSourceGroup;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

class J2eePlatformNode
extends AbstractNode
implements PropertyChangeListener,
InstanceListener {
    private static final String ARCHIVE_ICON = "org/netbeans/modules/web/project/ui/resources/jar.gif";
    private static final String DEFAULT_ICON = "org/netbeans/modules/web/project/ui/resources/j2eeServer.gif";
    private static final String BROKEN_PROJECT_BADGE = "org/netbeans/modules/web/project/ui/resources/brokenProjectBadge.gif";
    private static final Icon icon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/web/project/ui/resources/jar.gif"));
    private static final Image brokenIcon = Utilities.mergeImages((Image)Utilities.loadImage((String)"org/netbeans/modules/web/project/ui/resources/j2eeServer.gif"), (Image)Utilities.loadImage((String)"org/netbeans/modules/web/project/ui/resources/brokenProjectBadge.gif"), (int)8, (int)0);
    private final PropertyEvaluator evaluator;
    private final String platformPropName;
    private J2eePlatform platformCache;
    private final PropertyChangeListener platformListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("displayName".equals(evt.getPropertyName())) {
                J2eePlatformNode.this.fireNameChange((String)evt.getOldValue(), (String)evt.getNewValue());
                J2eePlatformNode.this.fireDisplayNameChange((String)evt.getOldValue(), (String)evt.getNewValue());
            }
            if ("classpath".equals(evt.getPropertyName())) {
                J2eePlatformNode.this.postAddNotify();
            }
        }
    };
    private PropertyChangeListener weakPlatformListener;

    private J2eePlatformNode(Project project, PropertyEvaluator evaluator, String platformPropName) {
        super((Children)new PlatformContentChildren());
        this.evaluator = evaluator;
        this.platformPropName = platformPropName;
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
        J2eeModuleProvider moduleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        moduleProvider.addInstanceListener((InstanceListener)WeakListeners.create(InstanceListener.class, (EventListener)this, (Object)moduleProvider));
    }

    public static J2eePlatformNode create(Project project, PropertyEvaluator evaluator, String platformPropName) {
        return new J2eePlatformNode(project, evaluator, platformPropName);
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return "";
    }

    public String getHtmlDisplayName() {
        if (this.getPlatform() != null) {
            return this.getPlatform().getDisplayName();
        }
        return NbBundle.getMessage(J2eePlatformNode.class, (String)"LBL_J2eeServerMissing");
    }

    public Image getIcon(int type) {
        Image result = null;
        if (this.getPlatform() != null) {
            result = this.getPlatform().getIcon();
        }
        return result != null ? result : brokenIcon;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[0];
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.platformPropName.equals(evt.getPropertyName())) {
            this.refresh();
        }
    }

    private void refresh() {
        if (this.platformCache != null) {
            this.platformCache.removePropertyChangeListener(this.weakPlatformListener);
        }
        this.platformCache = null;
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        this.fireIconChange();
        this.postAddNotify();
    }

    public void instanceAdded(String serverInstanceID) {
        this.refresh();
    }

    public void instanceRemoved(String serverInstanceID) {
        this.refresh();
    }

    public void changeDefaultInstance(String oldServerInstanceID, String newServerInstanceID) {
    }

    private void postAddNotify() {
        LibrariesNode.rp.post(new Runnable(){

            public void run() {
                ((PlatformContentChildren)J2eePlatformNode.this.getChildren()).addNotify();
            }
        });
    }

    private J2eePlatform getPlatform() {
        if (this.platformCache == null) {
            String j2eePlatformInstanceId = this.evaluator.getProperty(this.platformPropName);
            if (j2eePlatformInstanceId != null) {
                this.platformCache = Deployment.getDefault().getJ2eePlatform(j2eePlatformInstanceId);
            }
            if (this.platformCache != null) {
                this.weakPlatformListener = WeakListeners.propertyChange((PropertyChangeListener)this.platformListener, (Object)this.platformCache);
                this.platformCache.addPropertyChangeListener(this.weakPlatformListener);
                this.fireIconChange();
            }
        }
        return this.platformCache;
    }

    private static class PlatformContentChildren
    extends Children.Keys {
        PlatformContentChildren() {
        }

        protected void addNotify() {
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object key) {
            SourceGroup sg = (SourceGroup)key;
            return new Node[]{ActionFilterNode.create(PackageView.createPackageView((SourceGroup)sg), null, null, null, null, null, null)};
        }

        private List getKeys() {
            ArrayList<LibrariesSourceGroup> result;
            J2eePlatform j2eePlatform = ((J2eePlatformNode)this.getNode()).getPlatform();
            if (j2eePlatform != null) {
                File[] classpathEntries = j2eePlatform.getClasspathEntries();
                result = new ArrayList<LibrariesSourceGroup>(classpathEntries.length);
                for (int i = 0; i < classpathEntries.length; ++i) {
                    FileObject archiveFile;
                    FileObject file = FileUtil.toFileObject((File)classpathEntries[i]);
                    if (file == null || (archiveFile = FileUtil.getArchiveRoot((FileObject)file)) == null) continue;
                    result.add(new LibrariesSourceGroup(archiveFile, file.getNameExt(), icon, icon));
                }
            } else {
                result = Collections.EMPTY_LIST;
            }
            return result;
        }
    }
}

