/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.bridge.apis;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.config.AdminObjectResourceConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.ConnectorConnectionPoolConfig;
import com.sun.appserv.management.config.ConnectorResourceConfig;
import com.sun.appserv.management.config.CustomResourceConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.J2EEApplicationConfig;
import com.sun.appserv.management.config.JDBCConnectionPoolConfig;
import com.sun.appserv.management.config.JDBCResourceConfig;
import com.sun.appserv.management.config.JNDIResourceConfig;
import com.sun.appserv.management.config.JavaConfig;
import com.sun.appserv.management.config.LogServiceConfig;
import com.sun.appserv.management.config.MailResourceConfig;
import com.sun.appserv.management.config.ModuleLogLevelsConfig;
import com.sun.appserv.management.config.PersistenceManagerFactoryResourceConfig;
import com.sun.appserv.management.config.ResourceConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.config.WebModuleConfig;
import com.sun.appserv.management.j2ee.J2EEServer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.management.Attribute;
import javax.management.ObjectName;
import org.netbeans.modules.j2ee.sun.bridge.apis.AppserverMgmtControllerBase;
import org.netbeans.modules.j2ee.sun.ide.controllers.ControllerUtil;
import org.netbeans.modules.j2ee.sun.ide.controllers.J2EEServerMgmtController;
import org.netbeans.modules.j2ee.sun.util.NodeTypes;

public class AppserverMgmtController
extends AppserverMgmtControllerBase {
    public AppserverMgmtController(DeploymentManager deployMgr, AppserverConnectionSource connection) {
        super(deployMgr, connection);
    }

    public J2EEServerMgmtController getJ2EEServerMgmtController() {
        return this.getJ2EEServerMgmtController("server");
    }

    public J2EEServerMgmtController getJ2EEServerMgmtController(String serverName) {
        Map serverMap = this.getJ2EEDomain().getServerMap();
        J2EEServer j2eeServer = (J2EEServer)ControllerUtil.getAMXComponentFromMap(serverMap, serverName);
        return new J2EEServerMgmtController(j2eeServer, this.getDeploymentManager(), this.appMgmtConnection);
    }

    public String[] getJDBCResources() {
        return this.getComponentNamesFromMap(this.getDomainConfig().getJDBCResourceConfigMap());
    }

    public String[] getJDBCConnectionPools() {
        return this.getComponentNamesFromMap(this.getDomainConfig().getJDBCConnectionPoolConfigMap());
    }

    public String[] getJMSConnectionFactories() {
        return this.getConnectorResources();
    }

    public String[] getDestinationResources() {
        return this.getAdminObjectResources();
    }

    public String[] getJavaMailResources() {
        return this.getComponentNamesFromMap(this.getDomainConfig().getMailResourceConfigMap());
    }

    public String[] getConnectorResources() {
        return this.getComponentNamesFromMap(this.getDomainConfig().getConnectorResourceConfigMap());
    }

    public String[] getCustomResources() {
        return this.getComponentNamesFromMap(this.getDomainConfig().getCustomResourceConfigMap());
    }

    public String[] getExternalResources() {
        return this.getComponentNamesFromMap(this.getDomainConfig().getJNDIResourceConfigMap());
    }

    public String[] getConnectorConnectionPools() {
        return this.getComponentNamesFromMap(this.getDomainConfig().getConnectorConnectionPoolConfigMap());
    }

    public String[] getAdminObjectResources() {
        return this.getComponentNamesFromMap(this.getDomainConfig().getAdminObjectResourceConfigMap());
    }

    public String[] getPersistenceManagerFactoryResources() {
        return this.getComponentNamesFromMap(this.getDomainConfig().getPersistenceManagerFactoryResourceConfigMap());
    }

    public String[] getWebModules() {
        return this.getComponentNamesFromMap(this.getDomainConfig().getWebModuleConfigMap());
    }

    public String[] getEnterpriseApplications() {
        return this.getComponentNamesFromMap(this.getDomainConfig().getJ2EEApplicationConfigMap());
    }

    public Map getJDBCResourceProperties(String jdbcResourceName, List propsToIgnore) {
        JDBCResourceConfig res = this.getJDBCResourceConfigByName(jdbcResourceName);
        return this.getPropertiesFromBackend("JDBC_RESOURCE", (AMX)res, propsToIgnore);
    }

    public Map getJDBCConnectionPoolProperties(String jdbcConnPoolName, List propsToIgnore) {
        JDBCConnectionPoolConfig res = this.getJDBCConnectionPoolConfigByName(jdbcConnPoolName);
        return this.getPropertiesFromBackend("CONNECTION_POOL", (AMX)res, propsToIgnore);
    }

    public Map getJVMProperties(String serverName, List propsToIgnore) {
        JavaConfig javaConfig = this.getReferencedConfig(serverName).getJavaConfig();
        return this.getPropertiesFromBackend("JVM", (AMX)javaConfig, propsToIgnore);
    }

    public Map getPersistenceManagerFactoryProperties(String pmResourceName, List propsToIgnore) {
        PersistenceManagerFactoryResourceConfig res = this.getPersistenceManagerResourceFactoryConfigByName(pmResourceName);
        return this.getPropertiesFromBackend("PM_RESOURCE", (AMX)res, propsToIgnore);
    }

    public Map getJMSConnectionFactoryProperties(String jmsConnFactoryName, List propsToIgnore) {
        ConnectorResourceConfig res = this.getConnectorResourceConfigByName(jmsConnFactoryName);
        return this.getPropertiesFromBackend("CONNECTION_FACTORY", (AMX)res, propsToIgnore);
    }

    public Map getDestinationResourceProperties(String destResName, List propsToIgnore) {
        AdminObjectResourceConfig res = this.getAdminObjectResourceConfigByName(destResName);
        return this.getPropertiesFromBackend("DESTINATION_RESOURCE", (AMX)res, propsToIgnore);
    }

    public Map getJavaMailResourceProperties(String mailResourceName, List propsToIgnore) {
        MailResourceConfig res = this.getMailResourceConfigByName(mailResourceName);
        return this.getPropertiesFromBackend("MAIL_RESOURCE", (AMX)res, propsToIgnore);
    }

    public Map getConnectorConnectionPoolProperties(String poolName, List propsToIgnore) {
        ConnectorConnectionPoolConfig res = this.getConnectorConnectionPoolConfigByName(poolName);
        return this.getPropertiesFromBackend("CONNECTOR_CONNECTION_POOL", (AMX)res, propsToIgnore);
    }

    public Map getAdminObjectResourceProperties(String resName, List propsToIgnore) {
        AdminObjectResourceConfig res = this.getAdminObjectResourceConfigByName(resName);
        return this.getPropertiesFromBackend("ADMIN_OBJECT_RESOURCE", (AMX)res, propsToIgnore);
    }

    public Map getConnectorResourceProperties(String resName, List propsToIgnore) {
        ConnectorResourceConfig res = this.getConnectorResourceConfigByName(resName);
        return this.getPropertiesFromBackend("CONNECTOR_RESOURCE", (AMX)res, propsToIgnore);
    }

    public Map getCustomResourceProperties(String resName, List propsToIgnore) {
        CustomResourceConfig res = this.getCustomResourceConfigByName(resName);
        return this.getPropertiesFromBackend("CUSTOM_RESOURCE", (AMX)res, propsToIgnore);
    }

    public Map getExternalResourceProperties(String moduleName, List propsToIgnore) {
        JNDIResourceConfig res = this.getJNDIResourceConfigByName(moduleName);
        return this.getPropertiesFromBackend("EXTERNAL_RESOURCE", (AMX)res, propsToIgnore);
    }

    public Attribute setExternalResourceProperty(String resName, String attributeName, Object value) {
        this.testIfServerInDebug();
        JNDIResourceConfig res = this.getJNDIResourceConfigByName(resName);
        Attribute attr = ControllerUtil.setAttributeValue((AMX)res, attributeName, value, this.getMBeanServerConnection());
        return attr;
    }

    public String[] getClusters() {
        return this.getComponentNamesFromMap(this.getClustersMap());
    }

    StandaloneServerConfig getStandaloneServerConfigByName(String serverName) {
        Map map = this.getStandaloneServerInstancesMap();
        return (StandaloneServerConfig)map.get(serverName);
    }

    JDBCResourceConfig getJDBCResourceConfigByName(String jdbcResourceName) {
        Map map = this.getDomainConfig().getJDBCResourceConfigMap();
        return (JDBCResourceConfig)map.get(jdbcResourceName);
    }

    MailResourceConfig getMailResourceConfigByName(String mailResourceName) {
        Map map = this.getDomainConfig().getMailResourceConfigMap();
        return (MailResourceConfig)map.get(mailResourceName);
    }

    JNDIResourceConfig getJNDIResourceConfigByName(String resName) {
        Map map = this.getDomainConfig().getJNDIResourceConfigMap();
        return (JNDIResourceConfig)map.get(resName);
    }

    JDBCConnectionPoolConfig getJDBCConnectionPoolConfigByName(String jdbcConnPoolName) {
        Map map = this.getDomainConfig().getJDBCConnectionPoolConfigMap();
        return (JDBCConnectionPoolConfig)map.get(jdbcConnPoolName);
    }

    ConnectorResourceConfig getConnectorResourceConfigByName(String connResourceName) {
        Map map = this.getDomainConfig().getConnectorResourceConfigMap();
        return (ConnectorResourceConfig)map.get(connResourceName);
    }

    ConnectorConnectionPoolConfig getConnectorConnectionPoolConfigByName(String connPoolName) {
        Map map = this.getDomainConfig().getConnectorConnectionPoolConfigMap();
        return (ConnectorConnectionPoolConfig)map.get(connPoolName);
    }

    CustomResourceConfig getCustomResourceConfigByName(String resName) {
        Map map = this.getDomainConfig().getCustomResourceConfigMap();
        return (CustomResourceConfig)map.get(resName);
    }

    AdminObjectResourceConfig getAdminObjectResourceConfigByName(String adminObjName) {
        Map map = this.getDomainConfig().getAdminObjectResourceConfigMap();
        return (AdminObjectResourceConfig)map.get(adminObjName);
    }

    PersistenceManagerFactoryResourceConfig getPersistenceManagerResourceFactoryConfigByName(String pmResourceName) {
        Map map = this.getDomainConfig().getPersistenceManagerFactoryResourceConfigMap();
        return (PersistenceManagerFactoryResourceConfig)map.get(pmResourceName);
    }

    WebModuleConfig getWebModuleConfigByName(String webModuleName) {
        Map map = this.getDomainConfig().getWebModuleConfigMap();
        return (WebModuleConfig)map.get(webModuleName);
    }

    J2EEApplicationConfig getJ2EEApplicationConfigByName(String appName) {
        Map map = this.getDomainConfig().getJ2EEApplicationConfigMap();
        return (J2EEApplicationConfig)map.get(appName);
    }

    private String[] getComponentNamesFromMap(Map map) {
        return ControllerUtil.getComponentNamesFromMap(map);
    }

    Map getClustersMap() {
        return this.getDomainConfig().getClusterConfigMap();
    }

    Map getStandaloneServerInstancesMap() {
        return this.getDomainConfig().getStandaloneServerConfigMap();
    }

    public ConfigConfig getReferencedConfig(String serverName) {
        StandaloneServerConfig serverConfig = this.getStandaloneServerConfigByName(serverName);
        DomainConfig config = (DomainConfig)serverConfig.getContainer();
        AMX component = ControllerUtil.getAMXComponentFromMap(config.getConfigConfigMap(), serverConfig.getReferencedConfigName());
        return (ConfigConfig)component;
    }

    public Attribute setJDBCResourceProperty(String jdbcName, String attributeName, Object value) {
        this.testIfServerInDebug();
        JDBCResourceConfig res = this.getJDBCResourceConfigByName(jdbcName);
        Attribute attr = ControllerUtil.setAttributeValue((AMX)res, attributeName, value, this.getMBeanServerConnection());
        return attr;
    }

    public Attribute setJDBCConnectionPoolProperty(String resName, String attributeName, Object value) {
        this.testIfServerInDebug();
        Attribute attr = ControllerUtil.setAttributeValue((AMX)this.getJDBCConnectionPoolConfigByName(resName), attributeName, value, this.getMBeanServerConnection());
        return attr;
    }

    public Attribute setJMSResourceProperty(String resName, String attributeName, Object value) {
        this.testIfServerInDebug();
        Attribute attr = ControllerUtil.setAttributeValue((AMX)this.getConnectorResourceConfigByName(resName), attributeName, value, this.getMBeanServerConnection());
        return attr;
    }

    public Attribute setDestinationResourceProperty(String resName, String attributeName, Object value) {
        this.testIfServerInDebug();
        Attribute attr = ControllerUtil.setAttributeValue((AMX)this.getAdminObjectResourceConfigByName(resName), attributeName, value, this.getMBeanServerConnection());
        return attr;
    }

    public Attribute setJavaMailResourceProperty(String resName, String attributeName, Object value) {
        this.testIfServerInDebug();
        Attribute attr = ControllerUtil.setAttributeValue((AMX)this.getMailResourceConfigByName(resName), attributeName, value, this.getMBeanServerConnection());
        return attr;
    }

    public Attribute setPersistenceManagerResourceFactoryProperty(String resName, String attributeName, Object value) {
        this.testIfServerInDebug();
        Attribute attr = ControllerUtil.setAttributeValue((AMX)this.getPersistenceManagerResourceFactoryConfigByName(resName), attributeName, value, this.getMBeanServerConnection());
        return attr;
    }

    public Attribute setConnectorResourceProperty(String resName, String attributeName, Object value) {
        Attribute attr = ControllerUtil.setAttributeValue((AMX)this.getConnectorResourceConfigByName(resName), attributeName, value, this.getMBeanServerConnection());
        return attr;
    }

    public Attribute setConnectorConnectionPoolProperty(String resName, String attributeName, Object value) {
        this.testIfServerInDebug();
        Attribute attr = ControllerUtil.setAttributeValue((AMX)this.getConnectorConnectionPoolConfigByName(resName), attributeName, value, this.getMBeanServerConnection());
        return attr;
    }

    public Attribute setAdminObjectResourceProperty(String resName, String attributeName, Object value) {
        this.testIfServerInDebug();
        Attribute attr = ControllerUtil.setAttributeValue((AMX)this.getAdminObjectResourceConfigByName(resName), attributeName, value, this.getMBeanServerConnection());
        return attr;
    }

    public Attribute setJVMProperty(String serverName, String attributeName, Object value) {
        this.testIfServerInDebug();
        Attribute attr = ControllerUtil.setAttributeValue((AMX)this.getReferencedConfig(serverName).getJavaConfig(), attributeName, value, this.getMBeanServerConnection());
        return attr;
    }

    public Attribute setJMSConnectionFactoryProperty(String resName, String attributeName, Object value) {
        this.testIfServerInDebug();
        Attribute attr = ControllerUtil.setAttributeValue((AMX)this.getConnectorResourceConfigByName(resName), attributeName, value, this.getMBeanServerConnection());
        return attr;
    }

    public Attribute setCustomResourceProperty(String resName, String attributeName, Object value) {
        this.testIfServerInDebug();
        Attribute attr = ControllerUtil.setAttributeValue((AMX)this.getCustomResourceConfigByName(resName), attributeName, value, this.getMBeanServerConnection());
        return attr;
    }

    public void deleteAdminObjectResource(String resName) {
        AdminObjectResourceConfig res = this.getAdminObjectResourceConfigByName(resName);
        if (this.isEightPlatform()) {
            this.deleteResourceFromBackend_WorkaroundForPE("ADMIN_OBJECT_RESOURCE", resName);
        } else {
            this.removeResourceRef((ResourceConfig)res, resName);
            this.getDomainConfig().removeAdminObjectResourceConfig(resName);
        }
    }

    public void deleteExternalResource(String resName) {
        JNDIResourceConfig res = this.getJNDIResourceConfigByName(resName);
        if (this.isEightPlatform()) {
            this.deleteResourceFromBackend_WorkaroundForPE("EXTERNAL_RESOURCE", resName);
        } else {
            this.removeResourceRef((ResourceConfig)res, resName);
            this.getDomainConfig().removeJNDIResourceConfig(resName);
        }
    }

    public void deleteCustomResource(String resName) {
        CustomResourceConfig res = this.getCustomResourceConfigByName(resName);
        if (this.isEightPlatform()) {
            this.deleteResourceFromBackend_WorkaroundForPE("CUSTOM_RESOURCE", resName);
        } else {
            this.removeResourceRef((ResourceConfig)res, resName);
            this.getDomainConfig().removeCustomResourceConfig(resName);
        }
    }

    public void deleteJMSConnectionFactory(String resName) {
        ConnectorResourceConfig res = this.getConnectorResourceConfigByName(resName);
        if (this.isEightPlatform()) {
            this.deleteResourceFromBackend_WorkaroundForPE("CONNECTION_FACTORY", resName);
        } else {
            this.removeResourceRef((ResourceConfig)res, resName);
            this.getDomainConfig().removeConnectorResourceConfig(resName);
        }
    }

    public void deleteJDBCConnectionPool(String resName) {
        JDBCConnectionPoolConfig res = this.getJDBCConnectionPoolConfigByName(resName);
        if (this.isEightPlatform()) {
            this.deleteResourceFromBackend_WorkaroundForPE("CONNECTION_POOL", resName);
        } else {
            this.getDomainConfig().removeJDBCConnectionPoolConfig(resName);
        }
    }

    public void deleteConnectorConnectionPool(String resName) {
        ConnectorConnectionPoolConfig res = this.getConnectorConnectionPoolConfigByName(resName);
        if (this.isEightPlatform()) {
            this.deleteResourceFromBackend_WorkaroundForPE("CONNECTOR_CONNECTION_POOL", resName);
        } else {
            this.getDomainConfig().removeConnectorConnectionPoolConfig(resName);
        }
    }

    public void deleteConnectorResource(String resName) {
        ConnectorResourceConfig res = this.getConnectorResourceConfigByName(resName);
        if (this.isEightPlatform()) {
            this.deleteResourceFromBackend_WorkaroundForPE("CONNECTOR_RESOURCE", resName);
        } else {
            this.removeResourceRef((ResourceConfig)res, resName);
            this.getDomainConfig().removeConnectorResourceConfig(resName);
        }
    }

    public void deleteDestinationResource(String resName) {
        AdminObjectResourceConfig res = this.getAdminObjectResourceConfigByName(resName);
        if (this.isEightPlatform()) {
            this.deleteResourceFromBackend_WorkaroundForPE("DESTINATION_RESOURCE", resName);
        } else {
            this.removeResourceRef((ResourceConfig)res, resName);
            this.getDomainConfig().removeAdminObjectResourceConfig(resName);
        }
    }

    public void deleteJDBCResource(String resName) {
        JDBCResourceConfig res = this.getJDBCResourceConfigByName(resName);
        if (this.isEightPlatform()) {
            this.deleteResourceFromBackend_WorkaroundForPE("JDBC_RESOURCE", resName);
        } else {
            this.removeResourceRef((ResourceConfig)res, resName);
            this.getDomainConfig().removeJDBCResourceConfig(resName);
        }
    }

    public void deleteJavaMailResource(String resName) {
        MailResourceConfig res = this.getMailResourceConfigByName(resName);
        if (this.isEightPlatform()) {
            this.deleteResourceFromBackend_WorkaroundForPE("MAIL_RESOURCE", resName);
        } else {
            this.removeResourceRef((ResourceConfig)res, resName);
            this.getDomainConfig().removeMailResourceConfig(resName);
        }
    }

    public void deletePersistenceManagerResourceFactory(String resName) {
        PersistenceManagerFactoryResourceConfig res = this.getPersistenceManagerResourceFactoryConfigByName(resName);
        if (this.isEightPlatform()) {
            this.deleteResourceFromBackend_WorkaroundForPE("PM_RESOURCE", resName);
        } else {
            this.removeResourceRef((ResourceConfig)res, resName);
            this.getDomainConfig().removePersistenceManagerFactoryResourceConfig(resName);
        }
    }

    public void deleteDependentJDBCResources(String jdbcConnectionPoolName) {
        String[] jdbcResourceNames = this.getDependentJDBCResourceNames(jdbcConnectionPoolName);
        for (int i = 0; i < jdbcResourceNames.length; ++i) {
            this.deleteJDBCResource(jdbcResourceNames[i]);
        }
    }

    public String[] getDependentJDBCResourceNames(String jdbcConnectionPoolName) {
        Map jdbcResMap = this.getDomainConfig().getJDBCResourceConfigMap();
        Vector<String> namesToReturn = new Vector<String>();
        if (jdbcConnectionPoolName != null) {
            Iterator itr = jdbcResMap.values().iterator();
            while (itr.hasNext()) {
                JDBCResourceConfig config = (JDBCResourceConfig)itr.next();
                if (!jdbcConnectionPoolName.equals(config.getPoolName())) continue;
                namesToReturn.add(config.getName());
            }
        }
        String[] names = new String[namesToReturn.size()];
        return namesToReturn.toArray(names);
    }

    private void deleteResourceFromBackend_WorkaroundForPE(String nodeType, String resName) {
        String domainName = "com.sun.appserv";
        String props = Util.makeProp((String)"type", (String)"resources");
        String props2 = Util.makeProp((String)"category", (String)"config");
        props = Util.concatenateProps((String)props, (String)props2);
        String operationName = null;
        ObjectName resourcesMBeanObjName = Util.newObjectName((String)domainName, (String)props);
        operationName = NodeTypes.getDeleteResourceMethodName(nodeType);
        if (operationName != null) {
            try {
                this.getMBeanServerConnection().invoke(resourcesMBeanObjName, operationName, new Object[]{resName, "server"}, new String[]{"java.lang.String", "java.lang.String"});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getName() {
        return "";
    }

    public Map getLogProperties(String serverName) {
        LogServiceConfig logService = this.getReferencedConfig(serverName).getLogServiceConfig();
        ModuleLogLevelsConfig moduleLevels = logService.getModuleLogLevelsConfig();
        return this.getLogPropertiesFromBackend((AMX)moduleLevels, moduleLevels.getAllLevels());
    }

    public Attribute setLogProperties(String serverName, String attributeName, Object value) {
        this.testIfServerInDebug();
        LogServiceConfig logService = this.getReferencedConfig(serverName).getLogServiceConfig();
        ModuleLogLevelsConfig moduleLevels = logService.getModuleLogLevelsConfig();
        Attribute attr = ControllerUtil.setAttributeValue((AMX)moduleLevels, attributeName, value, this.getMBeanServerConnection());
        return attr;
    }

    public void updateResourceExtraProperty(String resourceName, String resourceType, Object[] props, Map oldProps) {
        this.testIfServerInDebug();
        if (resourceType.equals("CONNECTION_POOL")) {
            JDBCConnectionPoolConfig cpConfig = this.getJDBCConnectionPoolConfigByName(resourceName);
            if (cpConfig != null) {
                AppserverMgmtController.removeResourceExtraProperty(cpConfig, oldProps);
                ControllerUtil.setPropertyValue(cpConfig, props);
            }
        } else if (resourceType.equals("CONNECTOR_CONNECTION_POOL")) {
            ConnectorConnectionPoolConfig connConfig = this.getConnectorConnectionPoolConfigByName(resourceName);
            if (connConfig != null) {
                AppserverMgmtController.removeResourceExtraProperty(connConfig, oldProps);
                ControllerUtil.setPropertyValue(connConfig, props);
            }
        } else {
            ResourceConfig res = this.getRelevantResourceConfig(resourceName, resourceType);
            if (res != null) {
                AppserverMgmtController.removeResourceExtraProperty(res, oldProps);
                ControllerUtil.setPropertyValue(res, props);
            }
        }
    }

    private ResourceConfig getRelevantResourceConfig(String resourceName, String resourceType) {
        AdminObjectResourceConfig resConfig = null;
        if (resourceType.equals("ADMIN_OBJECT_RESOURCE") || resourceType.equals("DESTINATION_RESOURCE")) {
            resConfig = this.getAdminObjectResourceConfigByName(resourceName);
        } else if (resourceType.equals("CONNECTION_FACTORY") || resourceType.equals("CONNECTOR_RESOURCE")) {
            resConfig = this.getConnectorResourceConfigByName(resourceName);
        } else if (resourceType.equals("JDBC_RESOURCE")) {
            resConfig = this.getJDBCResourceConfigByName(resourceName);
        } else if (resourceType.equals("CUSTOM_RESOURCE")) {
            resConfig = this.getCustomResourceConfigByName(resourceName);
        } else if (resourceType.equals("EXTERNAL_RESOURCE")) {
            resConfig = this.getJNDIResourceConfigByName(resourceName);
        } else if (resourceType.equals("MAIL_RESOURCE")) {
            resConfig = this.getMailResourceConfigByName(resourceName);
        } else if (resourceType.equals("PM_RESOURCE")) {
            resConfig = this.getPersistenceManagerResourceFactoryConfigByName(resourceName);
        }
        return resConfig;
    }

    private static void removeResourceExtraProperty(ResourceConfig res, Map oldProps) {
        try {
            Iterator it = oldProps.keySet().iterator();
            while (it.hasNext()) {
                res.removeProperty(it.next().toString());
            }
        }
        catch (Exception ex) {
            return;
        }
    }

    private static void removeResourceExtraProperty(JDBCConnectionPoolConfig res, Map oldProps) {
        try {
            Iterator it = oldProps.keySet().iterator();
            while (it.hasNext()) {
                res.removeProperty(it.next().toString());
            }
        }
        catch (Exception ex) {
            return;
        }
    }

    private static void removeResourceExtraProperty(ConnectorConnectionPoolConfig res, Map oldProps) {
        try {
            Iterator it = oldProps.keySet().iterator();
            while (it.hasNext()) {
                res.removeProperty(it.next().toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getWebModuleName(String contextRoot) {
        J2EEServerMgmtController controller = this.getJ2EEServerMgmtController();
        String modname = null;
        if (controller != null) {
            modname = controller.getWebModuleName(contextRoot);
        }
        return modname;
    }

    public boolean isEightPlatform() {
        boolean isPlatform = true;
        J2EEServerMgmtController controller = this.getJ2EEServerMgmtController();
        String serverName = controller.getServerName();
        if (serverName != null && serverName.indexOf("Enterprise Edition 8.") != -1) {
            isPlatform = false;
        }
        return isPlatform;
    }

    public boolean isGlassfish() {
        boolean isGlassfish = true;
        J2EEServerMgmtController controller = this.getJ2EEServerMgmtController();
        String serverName = controller.getServerName();
        if (serverName != null && serverName.indexOf("8.") != -1) {
            isGlassfish = false;
        }
        return isGlassfish;
    }
}

