/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.DocumentFinder;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Mark;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakPropertyChangeSupport;
import org.openide.util.NbBundle;

public class FindSupport {
    private static final String FOUND_LOCALE = "find-found";
    private static final String NOT_FOUND_LOCALE = "find-not-found";
    private static final String WRAP_START_LOCALE = "find-wrap-start";
    private static final String WRAP_END_LOCALE = "find-wrap-end";
    private static final String WRAP_BLOCK_START_LOCALE = "find-block-wrap-start";
    private static final String WRAP_BLOCK_END_LOCALE = "find-block-wrap-end";
    private static final String ITEMS_REPLACED_LOCALE = "find-items-replaced";
    public static final String REVERT_MAP = "revert-map";
    private static final String SEARCH_BLOCK_START = "search-block-start";
    private static final String SEARCH_BLOCK_END = "search-block-end";
    public static final String FIND_HISTORY_PROP = "find-history-prop";
    public static final String FIND_HISTORY_CHANGED_PROP = "find-history-changed-prop";
    static FindSupport findSupport;
    private Map findProps;
    WeakPropertyChangeSupport changeSupport = new WeakPropertyChangeSupport();
    SearchPatternWrapper lastSelected;
    List historyList;

    private FindSupport() {
    }

    public static FindSupport getFindSupport() {
        if (findSupport == null) {
            findSupport = new FindSupport();
        }
        return findSupport;
    }

    public Map getDefaultFindProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Class kitClass = BaseKit.class;
        props.put("find-what", Settings.getValue(kitClass, "find-what"));
        props.put("find-replace-with", Settings.getValue(kitClass, "find-replace-with"));
        props.put("find-highlight-search", Settings.getValue(kitClass, "find-highlight-search"));
        props.put("find-inc-search", Settings.getValue(kitClass, "find-inc-search"));
        props.put("find-backward-search", Settings.getValue(kitClass, "find-backward-search"));
        props.put("find-wrap-search", Settings.getValue(kitClass, "find-wrap-search"));
        props.put("find-match-case", Settings.getValue(kitClass, "find-match-case"));
        props.put("find-smart-case", Settings.getValue(kitClass, "find-smart-case"));
        props.put("find-whole-words", Settings.getValue(kitClass, "find-whole-words"));
        props.put("find-reg-exp", Settings.getValue(kitClass, "find-reg-exp"));
        props.put("find-history", Settings.getValue(kitClass, "find-history"));
        return props;
    }

    private int getBlockEndOffset() {
        Position pos = (Position)this.getFindProperties().get("find-block-search-end");
        return pos != null ? pos.getOffset() : -1;
    }

    public Map getFindProperties() {
        if (this.findProps == null) {
            this.findProps = this.getDefaultFindProperties();
        }
        return this.findProps;
    }

    public Object getFindProperty(String name) {
        return this.getFindProperties().get(name);
    }

    private Map getValidFindProperties(Map props) {
        return props != null ? props : this.getFindProperties();
    }

    int[] getBlocks(int[] blocks, BaseDocument doc, int startPos, int endPos) throws BadLocationException {
        Map props = this.getValidFindProperties(null);
        Boolean b = (Boolean)props.get("find-block-search");
        boolean blockSearch = b != null && b != false;
        Integer i = (Integer)props.get("find-block-search-start");
        int blockSearchStart = i != null ? i : -1;
        int blockSearchEnd = this.getBlockEndOffset();
        if (blockSearch && blockSearchStart > -1 && blockSearchEnd > 0) {
            if (endPos >= blockSearchStart && startPos <= blockSearchEnd) {
                startPos = Math.max(blockSearchStart, startPos);
                endPos = Math.min(blockSearchEnd, endPos);
            } else {
                return blocks;
            }
        }
        return DocumentFinder.findBlocks(doc, startPos, endPos, props, blocks);
    }

    Object getPropertyNoInit(String name) {
        if (this.findProps == null) {
            return null;
        }
        return this.getFindProperty(name);
    }

    public void putFindProperty(String name, Object newValue) {
        Object oldValue = this.getFindProperty(name);
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        if (newValue != null) {
            this.getFindProperties().put(name, newValue);
        } else {
            this.getFindProperties().remove(name);
        }
        this.firePropertyChange(name, oldValue, newValue);
    }

    public void putFindProperties(Map propsToAdd) {
        if (!((Object)this.getFindProperties()).equals(propsToAdd)) {
            this.getFindProperties().putAll(propsToAdd);
            this.firePropertyChange(null, null, null);
        }
    }

    public void setBlockSearchHighlight(int startSelection, int endSelection) {
        boolean back;
        JTextComponent c = Utilities.getLastActiveComponent();
        if (c == null) {
            return;
        }
        EditorUI editorUI = ((BaseTextUI)c.getUI()).getEditorUI();
        DrawLayerFactory.BlockSearchLayer blockLayer = (DrawLayerFactory.BlockSearchLayer)editorUI.findLayer("block-search-layer");
        Boolean b = (Boolean)this.getFindProperties().get("find-backward-search");
        boolean bl = back = b != null && b != false;
        if (startSelection >= endSelection) {
            if (blockLayer != null && blockLayer.isEnabled()) {
                blockLayer.setEnabled(false);
                try {
                    editorUI.repaintBlock(blockLayer.getOffset(), blockLayer.getOffset() + blockLayer.getLength());
                }
                catch (BadLocationException e) {
                    Utilities.annotateLoggable(e);
                }
            }
        } else {
            if (blockLayer == null) {
                blockLayer = new DrawLayerFactory.BlockSearchLayer();
                if (!editorUI.addLayer(blockLayer, 8500)) {
                    return;
                }
            } else if (blockLayer.isEnabled()) {
                blockLayer.setEnabled(false);
                try {
                    editorUI.repaintOffset(blockLayer.getOffset());
                }
                catch (BadLocationException e) {
                    Utilities.annotateLoggable(e);
                }
            }
            blockLayer.setEnabled(true);
            blockLayer.setArea(startSelection, endSelection - startSelection);
            try {
                editorUI.repaintBlock(startSelection, endSelection);
            }
            catch (BadLocationException e) {
                Utilities.annotateLoggable(e);
                return;
            }
            c.getCaret().setDot(back ? endSelection : startSelection);
        }
    }

    public boolean incSearch(Map props, int caretPos) {
        Boolean b = (Boolean)(props = this.getValidFindProperties(props)).get("find-reg-exp");
        if (b != null && b.booleanValue()) {
            return false;
        }
        b = (Boolean)props.get("find-inc-search");
        if (b != null && b.booleanValue()) {
            JTextComponent c = Utilities.getLastActiveComponent();
            if (c != null && c.getDocument() instanceof BaseDocument) {
                int pos;
                BaseDocument doc = (BaseDocument)c.getDocument();
                b = (Boolean)props.get("find-backward-search");
                boolean back = b != null && b != false;
                b = (Boolean)props.get("find-block-search");
                boolean blockSearch = b != null && b != false;
                Integer i = (Integer)props.get("find-block-search-start");
                int blockSearchStart = i != null ? i : -1;
                Position endPos = (Position)props.get("find-block-search-end");
                int blockSearchEnd = endPos != null ? endPos.getOffset() : -1;
                int endOffset = back ? 0 : -1;
                try {
                    int end;
                    int start = blockSearch && blockSearchStart > -1 ? blockSearchStart : 0;
                    int n = end = blockSearch && blockSearchEnd > 0 ? blockSearchEnd : -1;
                    if (start > 0 && end == -1) {
                        return false;
                    }
                    int[] findRet = this.findInBlock(c, caretPos, start, end, props, false);
                    if (findRet == null) {
                        this.incSearchReset();
                        return false;
                    }
                    pos = findRet[0];
                }
                catch (BadLocationException e) {
                    Utilities.annotateLoggable(e);
                    return false;
                }
                BaseTextUI ui = (BaseTextUI)c.getUI();
                EditorUI editorUI = ui.getEditorUI();
                DrawLayerFactory.IncSearchLayer incLayer = (DrawLayerFactory.IncSearchLayer)editorUI.findLayer("inc-search-layer");
                if (incLayer == null) {
                    incLayer = new DrawLayerFactory.IncSearchLayer();
                    if (!editorUI.addLayer(incLayer, 9500)) {
                        return false;
                    }
                } else if (incLayer.isEnabled()) {
                    incLayer.setEnabled(false);
                    try {
                        editorUI.repaintOffset(incLayer.getOffset());
                    }
                    catch (BadLocationException e) {
                        Utilities.annotateLoggable(e);
                    }
                }
                if (pos >= 0) {
                    int len;
                    String s = (String)props.get("find-what");
                    int n = len = s != null ? s.length() : 0;
                    if (len > 0) {
                        if (c.getSelectionEnd() > c.getSelectionStart()) {
                            c.select(caretPos, caretPos);
                        }
                        incLayer.setInversion(!blockSearch);
                        incLayer.setEnabled(true);
                        incLayer.setArea(pos, len);
                        Map defaultProps = this.getValidFindProperties(null);
                        String findWhatDef = (String)defaultProps.get("find-what");
                        if (findWhatDef != null && findWhatDef.length() > 0) {
                            defaultProps.put("find-what", "");
                            editorUI.getComponent().repaint();
                        }
                        try {
                            editorUI.repaintOffset(pos);
                            this.ensureVisible(c, pos, pos);
                        }
                        catch (BadLocationException e) {
                            Utilities.annotateLoggable(e);
                        }
                        return true;
                    }
                }
            }
        } else {
            this.incSearchReset();
        }
        return false;
    }

    public void incSearchReset() {
        JTextComponent c = Utilities.getLastActiveComponent();
        if (c == null) {
            return;
        }
        EditorUI editorUI = ((BaseTextUI)c.getUI()).getEditorUI();
        DrawLayerFactory.IncSearchLayer incLayer = (DrawLayerFactory.IncSearchLayer)editorUI.findLayer("inc-search-layer");
        if (incLayer != null && incLayer.isEnabled()) {
            incLayer.setEnabled(false);
            try {
                editorUI.repaintOffset(incLayer.getOffset());
            }
            catch (BadLocationException e) {
                Utilities.annotateLoggable(e);
            }
        }
    }

    private boolean isBackSearch(Map props, boolean oppositeDir) {
        boolean back;
        Boolean b = (Boolean)props.get("find-backward-search");
        boolean bl = back = b != null && b != false;
        if (oppositeDir) {
            back = !back;
        }
        return back;
    }

    private void selectText(JTextComponent c, int start, int end, boolean back) {
        Caret caret = c.getCaret();
        this.ensureVisible(c, start, end);
        if (back) {
            caret.setDot(end);
            caret.moveDot(start);
        } else {
            caret.setDot(start);
            caret.moveDot(end);
        }
    }

    private void ensureVisible(JTextComponent c, int startOffset, int endOffset) {
        Class kitClass = Utilities.getKitClass(c);
        if (kitClass == null) {
            kitClass = BaseKit.class;
        }
        this.ensureVisible(c, startOffset, endOffset, (Insets)Settings.getValue(kitClass, "scroll-find-insets"));
    }

    private void ensureVisible(JTextComponent c, int startOffset, int endOffset, Insets extraInsets) {
        try {
            Rectangle startBounds = c.modelToView(startOffset);
            Rectangle endBounds = c.modelToView(endOffset);
            if (startBounds != null && endBounds != null) {
                startBounds.add(endBounds);
                if (extraInsets != null) {
                    Rectangle visibleBounds = c.getVisibleRect();
                    int extraTop = extraInsets.top < 0 ? -extraInsets.top * visibleBounds.height / 100 : extraInsets.top * endBounds.height;
                    startBounds.y -= extraTop;
                    startBounds.height += extraTop;
                    startBounds.height = startBounds.height + (extraInsets.bottom < 0 ? -extraInsets.bottom * visibleBounds.height / 100 : extraInsets.bottom * endBounds.height);
                    int extraLeft = extraInsets.left < 0 ? -extraInsets.left * visibleBounds.width / 100 : extraInsets.left * endBounds.width;
                    startBounds.x -= extraLeft;
                    startBounds.width += extraLeft;
                    startBounds.width = startBounds.width + (extraInsets.right < 0 ? -extraInsets.right * visibleBounds.width / 100 : extraInsets.right * endBounds.width);
                }
                c.scrollRectToVisible(startBounds);
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    private DocumentFinder.FindReplaceResult findReplaceImpl(String replaceExp, Map props, boolean oppositeDir) {
        this.incSearchReset();
        props = this.getValidFindProperties(props);
        boolean back = this.isBackSearch(props, oppositeDir);
        JTextComponent c = Utilities.getLastActiveComponent();
        Object findWhat = props.get("find-what");
        if (findWhat == null) {
            return null;
        }
        String exp = "'" + findWhat + "' ";
        if (c != null) {
            Boolean b;
            Object dp;
            boolean direction;
            Utilities.clearStatusText(c);
            Caret caret = c.getCaret();
            int dotPos = caret.getDot();
            if (findWhat.equals(c.getSelectedText()) && dotPos == (oppositeDir ^ (direction = (dp = props.get("find-backward-search")) != null ? (Boolean)dp : false) ? c.getSelectionEnd() : c.getSelectionStart())) {
                dotPos += oppositeDir ^ direction ? -1 : 1;
            }
            boolean blockSearch = (b = (Boolean)props.get("find-block-search")) != null && b != false;
            Integer i = (Integer)props.get("find-block-search-start");
            int blockSearchStart = i != null ? i : -1;
            int blockSearchEnd = this.getBlockEndOffset();
            try {
                DocumentFinder.FindReplaceResult result = this.findReplaceInBlock(replaceExp, c, dotPos, blockSearch && blockSearchStart > -1 ? blockSearchStart : 0, blockSearch && blockSearchEnd > 0 ? blockSearchEnd : -1, props, oppositeDir);
                int[] blk = null;
                if (result != null) {
                    blk = result.getFoundPositions();
                }
                if (blk != null) {
                    this.selectText(c, blk[0], blk[1], back);
                    JumpList.checkAddEntry();
                    String msg = exp + NbBundle.getBundle((Class)BaseKit.class).getString(FOUND_LOCALE) + ' ' + Utilities.debugPosition((BaseDocument)c.getDocument(), blk[0]);
                    if (blk[2] == 1) {
                        msg = msg + "; ";
                        msg = blockSearch && blockSearchEnd > 0 && blockSearchStart > -1 ? msg + (back ? NbBundle.getBundle((Class)BaseKit.class).getString(WRAP_BLOCK_END_LOCALE) : NbBundle.getBundle((Class)BaseKit.class).getString(WRAP_BLOCK_START_LOCALE)) : msg + (back ? NbBundle.getBundle((Class)BaseKit.class).getString(WRAP_END_LOCALE) : NbBundle.getBundle((Class)BaseKit.class).getString(WRAP_START_LOCALE));
                        Utilities.setStatusBoldText(c, msg);
                        c.getToolkit().beep();
                    } else {
                        Utilities.setStatusText(c, msg);
                    }
                    return result;
                }
                Utilities.setStatusBoldText(c, exp + NbBundle.getBundle((Class)BaseKit.class).getString(NOT_FOUND_LOCALE));
                c.getCaret().setDot(c.getCaret().getDot());
            }
            catch (BadLocationException e) {
                Utilities.annotateLoggable(e);
            }
        }
        return null;
    }

    public boolean find(Map props, boolean oppositeDir) {
        DocumentFinder.FindReplaceResult result = this.findReplaceImpl(null, props, oppositeDir);
        return result != null;
    }

    private DocumentFinder.FindReplaceResult findReplaceInBlock(String replaceExp, JTextComponent c, int startPos, int blockStartPos, int blockEndPos, Map props, boolean oppositeDir) throws BadLocationException {
        if (c != null) {
            int[] retFind;
            props = this.getValidFindProperties(props);
            BaseDocument doc = (BaseDocument)c.getDocument();
            int pos = -1;
            boolean wrapDone = false;
            String replaced = null;
            boolean back = this.isBackSearch(props, oppositeDir);
            Boolean b = (Boolean)props.get("find-wrap-search");
            boolean wrap = b != null && b != false;
            int docLen = doc.getLength();
            if (blockEndPos == -1) {
                blockEndPos = docLen;
            }
            while (true) {
                int off2;
                int off1;
                DocumentFinder.FindReplaceResult result;
                if ((result = DocumentFinder.findReplaceResult(replaceExp, doc, Math.min(off1 = startPos, off2 = back ? blockStartPos : blockEndPos), Math.max(off1, off2), props, oppositeDir)) == null) {
                    return null;
                }
                retFind = result.getFoundPositions();
                replaced = result.getReplacedString();
                if (retFind == null || (pos = retFind[0]) != -1 || !wrap) break;
                startPos = back ? blockEndPos : blockStartPos;
                wrapDone = true;
                wrap = false;
            }
            if (pos != -1) {
                int[] ret = new int[]{pos, retFind[1], wrapDone ? 1 : 0};
                return new DocumentFinder.FindReplaceResult(ret, replaced);
            }
        }
        return null;
    }

    public int[] findInBlock(JTextComponent c, int startPos, int blockStartPos, int blockEndPos, Map props, boolean oppositeDir) throws BadLocationException {
        DocumentFinder.FindReplaceResult result = this.findReplaceInBlock(null, c, startPos, blockStartPos, blockEndPos, props, oppositeDir);
        return result == null ? null : result.getFoundPositions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(Map props, boolean oppositeDir) throws BadLocationException {
        boolean back;
        this.incSearchReset();
        props = this.getValidFindProperties(props);
        Boolean b = (Boolean)props.get("find-backward-search");
        boolean bl = back = b != null && b != false;
        if (oppositeDir) {
            back = !back;
        }
        boolean blockSearch = (b = (Boolean)props.get("find-block-search")) != null && b != false;
        Integer i = (Integer)props.get("find-block-search-start");
        int blockSearchStart = i != null ? i : -1;
        int blockSearchEnd = this.getBlockEndOffset();
        JTextComponent c = Utilities.getLastActiveComponent();
        if (c != null) {
            DocumentFinder.FindReplaceResult result;
            String s = (String)props.get("find-replace-with");
            Caret caret = c.getCaret();
            if (caret.isSelectionVisible()) {
                int dotPos = caret.getDot();
                Object dp = props.get("find-backward-search");
                boolean direction = dp != null ? (Boolean)dp : false;
                dotPos = oppositeDir ^ direction ? c.getSelectionEnd() : c.getSelectionStart();
                c.setCaretPosition(dotPos);
            }
            if ((result = this.findReplaceImpl(s, props, oppositeDir)) == null) {
                return false;
            }
            s = result.getReplacedString();
            BaseDocument doc = (BaseDocument)c.getDocument();
            int startPos = c.getSelectionStart();
            int len = c.getSelectionEnd() - startPos;
            doc.atomicLock();
            try {
                if (len > 0) {
                    doc.remove(startPos, len);
                }
                if (s != null && s.length() > 0) {
                    doc.insertString(startPos, s, null);
                }
            }
            finally {
                doc.atomicUnlock();
                if (blockSearch) {
                    this.setBlockSearchHighlight(blockSearchStart, this.getBlockEndOffset());
                }
            }
            int adjustedCaretPos = back || s == null ? startPos : startPos + s.length();
            caret.setDot(adjustedCaretPos);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceAll(Map props) {
        Integer i;
        boolean backSearch;
        this.incSearchReset();
        JTextComponent c = Utilities.getLastActiveComponent();
        BaseDocument doc = (BaseDocument)c.getDocument();
        int maxCnt = doc.getLength();
        int replacedCnt = 0;
        int totalCnt = 0;
        props = this.getValidFindProperties(props);
        props = new HashMap<String, Boolean>(props);
        String replaceWithOriginal = (String)props.get("find-replace-with");
        Boolean b = (Boolean)props.get("find-block-search");
        boolean blockSearch = b != null && b != false;
        b = (Boolean)props.get("find-wrap-search");
        boolean wrapSearch = b != null && b != false;
        b = (Boolean)props.get("find-backward-search");
        boolean bl = backSearch = b != null && b != false;
        if (wrapSearch) {
            props.put("find-wrap-search", Boolean.FALSE);
            props.put("find-backward-search", Boolean.FALSE);
            this.firePropertyChange(null, null, null);
        }
        int blockSearchStart = (i = (Integer)props.get("find-block-search-start")) != null ? i : -1;
        int blockSearchEnd = this.getBlockEndOffset();
        if (c != null) {
            doc.atomicLock();
            try {
                int actualPos;
                int startPosWholeSearch = 0;
                int endPosWholeSearch = -1;
                int caretPos = c.getCaret().getDot();
                if (!wrapSearch) {
                    if (backSearch) {
                        startPosWholeSearch = 0;
                        endPosWholeSearch = caretPos;
                    } else {
                        startPosWholeSearch = caretPos;
                        endPosWholeSearch = -1;
                    }
                }
                int n = actualPos = wrapSearch ? 0 : c.getCaret().getDot();
                int pos = blockSearch && blockSearchStart > -1 ? (backSearch ? blockSearchEnd : blockSearchStart) : actualPos;
                while (true) {
                    blockSearchEnd = this.getBlockEndOffset();
                    DocumentFinder.FindReplaceResult result = this.findReplaceInBlock(replaceWithOriginal, c, pos, blockSearch && blockSearchStart > -1 ? blockSearchStart : startPosWholeSearch, blockSearch && blockSearchEnd > 0 ? blockSearchEnd : endPosWholeSearch, props, false);
                    if (result == null) break;
                    int[] blk = result.getFoundPositions();
                    String replaceWith = result.getReplacedString();
                    if (blk == null) break;
                    ++totalCnt;
                    int len = blk[1] - blk[0];
                    boolean skip = false;
                    try {
                        doc.remove(blk[0], len);
                    }
                    catch (GuardedException e) {
                        skip = true;
                    }
                    if (skip) {
                        pos = blk[0] + len;
                        continue;
                    }
                    if (replaceWith != null && replaceWith.length() > 0) {
                        doc.insertString(blk[0], replaceWith, null);
                    }
                    pos = blk[0] + (replaceWith != null ? replaceWith.length() : 0);
                    ++replacedCnt;
                }
                if (totalCnt == 0) {
                    Object findWhat = props.get("find-what");
                    String exp = "'' ";
                    if (findWhat != null) {
                        exp = "'" + findWhat + "' ";
                    }
                    Utilities.setStatusBoldText(c, exp + NbBundle.getBundle((Class)BaseKit.class).getString(NOT_FOUND_LOCALE));
                } else {
                    MessageFormat fmt = new MessageFormat(NbBundle.getBundle((Class)BaseKit.class).getString(ITEMS_REPLACED_LOCALE));
                    String msg = fmt.format(new Object[]{new Integer(replacedCnt), new Integer(totalCnt)});
                    Utilities.setStatusText(c, msg);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            finally {
                doc.atomicUnlock();
                if (blockSearch) {
                    this.setBlockSearchHighlight(blockSearchStart, this.getBlockEndOffset());
                }
            }
        }
    }

    public int getWrapSearchMarkPos(BaseDocument doc) {
        Mark mark = (Mark)doc.getProperty("wrap-search-mark");
        try {
            return mark != null ? mark.getOffset() : doc.getLength();
        }
        catch (InvalidMarkException e) {
            throw new RuntimeException();
        }
    }

    public void setWrapSearchMarkPos(BaseDocument doc, int pos) {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(String findPropertyName, PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(findPropertyName, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    void firePropertyChange(String settingName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(this, settingName, oldValue, newValue);
    }

    public void setHistory(List spwList) {
        this.historyList = new ArrayList(spwList);
        this.firePropertyChange(FIND_HISTORY_CHANGED_PROP, null, null);
    }

    public List getHistory() {
        return this.historyList;
    }

    public void setLastSelected(SearchPatternWrapper spw) {
        this.lastSelected = spw;
        Map props = this.getFindProperties();
        if (spw == null) {
            return;
        }
        props.put("find-what", spw.getSearchExpression());
        props.put("find-match-case", spw.isMatchCase());
        props.put("find-reg-exp", spw.isRegExp());
        props.put("find-whole-words", spw.isWholeWords());
    }

    public SearchPatternWrapper getLastSelected() {
        return this.lastSelected;
    }

    public void addToHistory(SearchPatternWrapper spw) {
        if (spw == null) {
            return;
        }
        this.firePropertyChange(FIND_HISTORY_PROP, null, spw);
    }

    public static class SearchPatternWrapper {
        private String searchExpression;
        private boolean wholeWords;
        private boolean matchCase;
        private boolean regExp;

        public SearchPatternWrapper(String searchExpression, boolean wholeWords, boolean matchCase, boolean regExp) {
            this.searchExpression = searchExpression;
            this.wholeWords = wholeWords;
            this.matchCase = matchCase;
            this.regExp = regExp;
        }

        public String getSearchExpression() {
            return this.searchExpression;
        }

        public boolean isWholeWords() {
            return this.wholeWords;
        }

        public boolean isMatchCase() {
            return this.matchCase;
        }

        public boolean isRegExp() {
            return this.regExp;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SearchPatternWrapper)) {
                return false;
            }
            SearchPatternWrapper sp = (SearchPatternWrapper)obj;
            return this.searchExpression.equals(sp.getSearchExpression()) && this.wholeWords == sp.isWholeWords() && this.matchCase == sp.isMatchCase() && this.regExp == sp.isRegExp();
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.wholeWords ? 1 : 0);
            result = 37 * result + (this.matchCase ? 1 : 0);
            result = 37 * result + (this.regExp ? 1 : 0);
            result = 37 * result + this.searchExpression.hashCode();
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[SearchPatternWrapper:]\nsearchExpression:" + this.searchExpression);
            sb.append('\n');
            sb.append("wholeWords:");
            sb.append(this.wholeWords);
            sb.append('\n');
            sb.append("matchCase:");
            sb.append(this.matchCase);
            sb.append('\n');
            sb.append("regExp:");
            sb.append(this.regExp);
            return sb.toString();
        }
    }
}

