/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceUnitPanelFactory;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceValidator;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.entity.WrapperPanel;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardDescriptor;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelDS;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelJdbc;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.ConfirmDialog;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PersistenceToolBarMVElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    private ToolBarDesignEditor comp;
    private PersistenceView view;
    private PUDataObject puDataObject;
    private PersistenceUnitPanelFactory factory;
    private Action addAction;
    private Action removeAction;
    private Persistence persistence;
    private Project project;
    private boolean needInit = true;
    private RequestProcessor.Task repaintingTask;

    public PersistenceToolBarMVElement(PUDataObject dObj) {
        super((XmlMultiViewDataObject)dObj);
        this.puDataObject = dObj;
        this.project = FileOwnerQuery.getOwner((FileObject)dObj.getPrimaryFile());
        this.addAction = new AddAction(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_Add"));
        this.removeAction = new RemoveAction(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_Remove"));
        this.comp = new ToolBarDesignEditor();
        this.factory = new PersistenceUnitPanelFactory(this.comp, dObj);
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PersistenceToolBarMVElement.this.repaintView();
                    }
                });
            }
        });
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public void componentOpened() {
        super.componentOpened();
        this.dObj.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.dObj.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentShowing() {
        super.componentShowing();
        if (this.needInit) {
            this.repaintView();
            this.needInit = false;
        }
        this.puDataObject.viewCanBeDisplayed();
    }

    private void repaintView() {
        this.view = new PersistenceView(this.puDataObject);
        this.comp.setContentView((PanelView)this.view);
        Object lastActive = this.comp.getLastActive();
        if (lastActive != null) {
            this.view.openPanel(lastActive);
        } else {
            Node initialNode = this.view.getPersistenceUnitsNode();
            Children ch = initialNode.getChildren();
            if (ch.getNodesCount() > 0) {
                initialNode = ch.getNodes()[0];
            }
            this.view.selectNode(initialNode);
        }
        this.view.checkValidity();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        block6: {
            block5: {
                String name = evt.getPropertyName();
                if ("data modified".equals(name)) break block5;
                if (!"data changed".equals(name)) break block6;
            }
            if (this.equals(this.puDataObject.getActiveMultiViewElement0())) {
                this.repaintingTask.schedule(100);
            } else {
                this.needInit = true;
            }
        }
    }

    private void validateUnitName(PersistenceUnitWizardPanel panel) {
        if (!panel.isNameUnique()) {
            panel.setErrorMessage(NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_PersistenceUnitNameNotUnique"));
        } else {
            panel.setErrorMessage(null);
        }
    }

    private class RemoveAction
    extends AbstractAction {
        RemoveAction(String actionName) {
            super(actionName);
        }

        public void actionPerformed(ActionEvent evt) {
            SectionPanel sectionPanel = ((SectionPanel.HeaderButton)evt.getSource()).getSectionPanel();
            PersistenceUnit punit = (PersistenceUnit)((Object)sectionPanel.getKey());
            ConfirmDialog desc = new ConfirmDialog(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_ConfirmRemove", (Object)punit.getName()));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)desc);
            dialog.setVisible(true);
            if (DialogDescriptor.OK_OPTION.equals(desc.getValue())) {
                sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
                PersistenceToolBarMVElement.this.puDataObject.removePersistenceUnit(punit);
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        AddAction(String actionName) {
            super(actionName);
        }

        public void actionPerformed(ActionEvent evt) {
            Object result;
            boolean isContainer = Util.isSupportedJavaEEVersion(PersistenceToolBarMVElement.this.project);
            final PersistenceUnitWizardPanel panel = isContainer ? new PersistenceUnitWizardPanelDS(PersistenceToolBarMVElement.this.project, null, true) : new PersistenceUnitWizardPanelJdbc(PersistenceToolBarMVElement.this.project, null, true);
            final NotifyDescriptor nd = new NotifyDescriptor((Object)new WrapperPanel(panel), NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_NewPersistenceUnit"), 2, -1, null, null);
            panel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    Object newvalue;
                    if (evt.getPropertyName().equals("PersistenceUnitWizardPanel_isValid") && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                        PersistenceToolBarMVElement.this.validateUnitName(panel);
                        nd.setValid(((Boolean)newvalue).booleanValue());
                    }
                }
            });
            if (!panel.isValidPanel()) {
                PersistenceToolBarMVElement.this.validateUnitName(panel);
                nd.setValid(false);
            }
            if ((result = DialogDisplayer.getDefault().notify(nd)) == NotifyDescriptor.OK_OPTION) {
                PersistenceUnit punit = new PersistenceUnit();
                if (isContainer) {
                    PersistenceUnitWizardPanelDS puPanel = (PersistenceUnitWizardPanelDS)panel;
                    if (puPanel.isJTA()) {
                        punit.setJtaDataSource(puPanel.getDatasource());
                    } else {
                        punit.setNonJtaDataSource(puPanel.getDatasource());
                        punit.setTransactionType("RESOURCE_LOCAL");
                    }
                    if (puPanel.isNonDefaultProviderEnabled()) {
                        punit.setProvider(puPanel.getNonDefaultProvider());
                    }
                } else {
                    PersistenceUnitWizardPanelJdbc puJdbc = (PersistenceUnitWizardPanelJdbc)panel;
                    punit = ProviderUtil.buildPersistenceUnit(puJdbc.getPersistenceUnitName(), puJdbc.getSelectedProvider(), puJdbc.getPersistenceConnection());
                    punit.setTransactionType("RESOURCE_LOCAL");
                    if (puJdbc.getPersistenceLibrary() != null) {
                        Util.addLibraryToProject(PersistenceToolBarMVElement.this.project, puJdbc.getPersistenceLibrary());
                    }
                }
                punit.setName(panel.getPersistenceUnitName());
                ProviderUtil.setTableGeneration(punit, panel.getTableGeneration(), PersistenceToolBarMVElement.this.project);
                PersistenceToolBarMVElement.this.puDataObject.addPersistenceUnit(punit);
                PersistenceToolBarMVElement.this.comp.setLastActive((Object)punit);
            }
        }
    }

    private class PersistenceUnitNode
    extends AbstractNode {
        PersistenceUnitNode(PersistenceUnit persistenceUnit) {
            super(Children.LEAF);
            this.setDisplayName(persistenceUnit.getName());
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/persistence/unit/PersistenceIcon.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("persistence_multiview_design_persistenceUnitNode");
        }
    }

    private class PersistenceView
    extends SectionView {
        private SectionContainer persistenceUnitsCont;
        private Node persistenceUnitsNode;

        public SectionContainer getPersistenceUnitsCont() {
            return this.persistenceUnitsCont;
        }

        public Node getPersistenceUnitsNode() {
            return this.persistenceUnitsNode;
        }

        PersistenceView(PUDataObject dObj) {
            super((InnerPanelFactory)PersistenceToolBarMVElement.this.factory);
            Persistence persistence = dObj.getPersistence();
            PersistenceUnit[] persistenceUnits = persistence.getPersistenceUnit();
            Node[] persistenceUnitNode = new Node[persistenceUnits.length];
            Children.Array ch = new Children.Array();
            for (int i = 0; i < persistenceUnits.length; ++i) {
                persistenceUnitNode[i] = new PersistenceUnitNode(persistenceUnits[i]);
            }
            ch.add(persistenceUnitNode);
            this.persistenceUnitsNode = new SectionContainerNode((Children)ch);
            this.persistenceUnitsNode.setDisplayName(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_PersistenceUnits"));
            this.persistenceUnitsCont = new SectionContainer((SectionView)this, this.persistenceUnitsNode, NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_PersistenceUnits"));
            this.persistenceUnitsCont.setHeaderActions(new Action[]{PersistenceToolBarMVElement.this.addAction});
            Children.Array rootChildren = new Children.Array();
            rootChildren.add(new Node[]{this.persistenceUnitsNode});
            AbstractNode root = new AbstractNode((Children)rootChildren);
            SectionPanel[] pan = new SectionPanel[persistenceUnits.length];
            for (int i = 0; i < persistenceUnits.length; ++i) {
                pan[i] = new SectionPanel((SectionView)this, persistenceUnitNode[i], persistenceUnitNode[i].getDisplayName(), (Object)persistenceUnits[i], false, false);
                pan[i].setHeaderActions(new Action[]{PersistenceToolBarMVElement.this.removeAction});
                this.persistenceUnitsCont.addSection((NodeSectionPanel)pan[i]);
            }
            this.addSection((NodeSectionPanel)this.persistenceUnitsCont);
            this.setRoot((Node)root);
        }

        public Error validateView() {
            PersistenceValidator validator = new PersistenceValidator((PUDataObject)PersistenceToolBarMVElement.this.dObj);
            List<Error> result = validator.validate();
            if (!result.isEmpty()) {
                return result.get(0);
            }
            return null;
        }
    }
}

