/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.welcome.content.RSSFeed;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CombinationRSSFeed
extends RSSFeed {
    private String url1;
    private String url2;

    public CombinationRSSFeed(String url1, String url2) {
        this.url1 = url1;
        this.url2 = url2;
    }

    protected ArrayList buildItemList() throws SAXException, ParserConfigurationException, IOException {
        XMLReader reader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
        RSSFeed.FeedHandler handler = new RSSFeed.FeedHandler();
        reader.setContentHandler(handler);
        reader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
        reader.setErrorHandler(new RSSFeed.ErrorCatcher());
        reader.parse(new InputSource(this.url1));
        ArrayList res = new ArrayList(20);
        res.addAll(handler.getItemList());
        handler = new RSSFeed.FeedHandler();
        reader.setContentHandler(handler);
        reader.parse(new InputSource(this.url2));
        res.addAll(handler.getItemList());
        return this.sortNodes(res);
    }

    private ArrayList sortNodes(ArrayList res) {
        Collections.sort(res, new DateFeedItemComparator());
        return res;
    }

    private static class DateFeedItemComparator
    implements Comparator {
        private static DateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
        private static DateFormat dateFormatShort = new SimpleDateFormat("EEE, dd MMM yyyy", Locale.ENGLISH);

        private DateFeedItemComparator() {
        }

        public int compare(Object o1, Object o2) {
            RSSFeed.FeedItem item1 = (RSSFeed.FeedItem)o1;
            RSSFeed.FeedItem item2 = (RSSFeed.FeedItem)o2;
            Date date1 = this.extractDate(item1);
            Date date2 = this.extractDate(item2);
            if (null == date1 && null == date2) {
                return 0;
            }
            if (null == date1) {
                return 1;
            }
            if (null == date2) {
                return -1;
            }
            if (date1.after(date2)) {
                return -1;
            }
            if (date1.before(date2)) {
                return 1;
            }
            return 0;
        }

        private Date extractDate(RSSFeed.FeedItem item) {
            try {
                if (null != item.dateTime) {
                    return dateFormat.parse(item.dateTime);
                }
            }
            catch (ParseException pE) {
                try {
                    return dateFormatShort.parse(item.dateTime);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

