/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.usability.diagnostics;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.usability.diagnostics.DiagnosisUtils;
import org.apache.maven.usability.diagnostics.ErrorDiagnoser;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public class ErrorDiagnostics
extends AbstractLogEnabled
implements Contextualizable {
    public static final String ROLE = (class$org$apache$maven$usability$diagnostics$ErrorDiagnostics == null ? (class$org$apache$maven$usability$diagnostics$ErrorDiagnostics = ErrorDiagnostics.class$("org.apache.maven.usability.diagnostics.ErrorDiagnostics")) : class$org$apache$maven$usability$diagnostics$ErrorDiagnostics).getName();
    private PlexusContainer container;
    private List errorDiagnosers;
    static /* synthetic */ Class class$org$apache$maven$usability$diagnostics$ErrorDiagnostics;

    public void setErrorDiagnosers(List errorDiagnosers) {
        this.errorDiagnosers = errorDiagnosers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String diagnose(Throwable error) {
        String message;
        block13: {
            List diags = this.errorDiagnosers;
            boolean releaseDiags = false;
            boolean errorProcessed = false;
            message = null;
            try {
                if (diags == null) {
                    releaseDiags = true;
                    try {
                        diags = this.container.lookupList(ErrorDiagnoser.ROLE);
                    }
                    catch (ComponentLookupException e) {
                        this.getLogger().error("Failed to lookup the list of error diagnosers.", (Throwable)e);
                    }
                }
                if (diags == null) break block13;
                Iterator it = diags.iterator();
                while (it.hasNext()) {
                    ErrorDiagnoser diagnoser = (ErrorDiagnoser)it.next();
                    if (!diagnoser.canDiagnose(error)) continue;
                    errorProcessed = true;
                    message = diagnoser.diagnose(error);
                    break;
                }
            }
            finally {
                if (releaseDiags && diags != null) {
                    try {
                        this.container.releaseAll(diags);
                    }
                    catch (ComponentLifecycleException e) {
                        this.getLogger().debug("Failed to release error diagnoser list.", (Throwable)e);
                    }
                }
                if (!errorProcessed) {
                    message = new PuntErrorDiagnoser().diagnose(error);
                }
            }
        }
        return message;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PuntErrorDiagnoser
    implements ErrorDiagnoser {
        private PuntErrorDiagnoser() {
        }

        public boolean canDiagnose(Throwable error) {
            return true;
        }

        public String diagnose(Throwable error) {
            StringBuffer message = new StringBuffer();
            message.append(error.getMessage());
            DiagnosisUtils.appendRootCauseIfPresentAndUnique(error, message, false);
            return message.toString();
        }
    }
}

