/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.MenuItemPeer;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MenuItem
extends MenuComponent
implements Serializable,
Accessible {
    private static final long serialVersionUID = -21757335363267194L;
    String actionCommand;
    boolean enabled;
    long eventMask;
    String label;
    private MenuShortcut shortcut;
    private transient ActionListener action_listeners;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String string) {
        this.label = string;
        if (this.peer != null) {
            MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
            menuItemPeer.setLabel(string);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean bl) {
        this.enable(bl);
    }

    public void enable(boolean bl) {
        if (bl) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setEnabled(true);
        }
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setEnabled(false);
        }
    }

    public MenuShortcut getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(MenuShortcut menuShortcut) {
        this.shortcut = menuShortcut;
    }

    public void deleteShortcut() {
        this.shortcut = null;
    }

    public String getActionCommand() {
        if (this.actionCommand == null) {
            return this.label;
        }
        return this.actionCommand;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    protected final void enableEvents(long l) {
        this.eventMask |= l;
    }

    protected final void disableEvents(long l) {
        this.eventMask &= l ^ -1L;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createMenuItem(this);
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.action_listeners = AWTEventMulticaster.add(this.action_listeners, actionListener);
        this.enableEvents(128L);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.action_listeners = AWTEventMulticaster.remove(this.action_listeners, actionListener);
    }

    public synchronized ActionListener[] getActionListeners() {
        Class clazz = class$java$awt$event$ActionListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ActionListener = MenuItem.class("[Ljava.awt.event.ActionListener;", false);
        }
        return (ActionListener[])AWTEventMulticaster.getListeners(this.action_listeners, clazz);
    }

    public EventListener[] getListeners(Class clazz) {
        Class clazz2 = class$java$awt$event$ActionListener;
        if (clazz2 == null) {
            clazz2 = class$java$awt$event$ActionListener = MenuItem.class("[Ljava.awt.event.ActionListener;", false);
        }
        if (clazz == clazz2) {
            return this.getActionListeners();
        }
        return (EventListener[])Array.newInstance(clazz, 0);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.id <= 1001 && aWTEvent.id >= 1001 && (this.action_listeners != null || (this.eventMask & 0x80L) != 0L)) {
            this.processEvent(aWTEvent);
        }
        if (!aWTEvent.isConsumed()) {
            ((Menu)this.getParent()).processEvent(aWTEvent);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.action_listeners != null) {
            actionEvent.setSource(this);
            this.action_listeners.actionPerformed(actionEvent);
        }
    }

    public String paramString() {
        return "label=" + this.label + ",enabled=" + this.enabled + ",actionCommand=" + this.actionCommand + ',' + super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenuItem();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.enabled = true;
        this.label = "";
    }

    public MenuItem() {
        this.this();
    }

    public MenuItem(String string) {
        this.this();
        this.label = string;
    }

    public MenuItem(String string, MenuShortcut menuShortcut) {
        this.this();
        this.label = string;
        this.shortcut = menuShortcut;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleAWTMenuItem
    extends MenuComponent.AccessibleAWTMenuComponent
    implements AccessibleAction,
    AccessibleValue {
        private static final long serialVersionUID = -217847831945965825L;

        public String getAccessibleName() {
            return MenuItem.this.label;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_ITEM;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public String getAccessibleActionDescription(int n) {
            if (n == 0) {
                return MenuItem.this.label;
            }
            return null;
        }

        public boolean doAccessibleAction(int n) {
            if (n != 0) {
                return false;
            }
            MenuItem.this.processActionEvent(new ActionEvent(this, 1001, MenuItem.this.actionCommand));
            return true;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return MenuItem.this.enabled ? new Integer(1) : new Integer(0);
        }

        public boolean setCurrentAccessibleValue(Number number) {
            boolean bl = false;
            if (number.intValue() != 0) {
                bl = true;
            }
            boolean bl2 = bl;
            this.setEnabled(bl2);
            return bl2;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(0);
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(0);
        }

        protected AccessibleAWTMenuItem() {
        }
    }
}

