% ACSCH ACSCH Inverse Hyperbolic Cosecant Function
% 
% Usage
% 
% Computes the inverse hyperbolic cosecant of its argument.  The general
% syntax for its use is
% 
%   y = acsch(x)
% 
% where x is an n-dimensional array of numerical type.

function y = acsch(x)
  if (nargin == 0 || ~isnumeric(x))
    error('acsch expects a single, numeric input');
  end
  y = asinh(1.f./x);
  
