/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;

public final class MBeanServerPermission
extends Permission {
    private transient ArrayList targets;
    private transient boolean wildcard;

    public MBeanServerPermission(String name) {
        this(name, null);
    }

    public MBeanServerPermission(String name, String actions) {
        super(name);
        this.parseName(name);
    }

    public String getActions() {
        return null;
    }

    public int hashCode() {
        return this.targets.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            MBeanServerPermission other = (MBeanServerPermission)obj;
            return this.targets.equals(other.targets);
        }
        catch (ClassCastException x) {
            return false;
        }
    }

    public boolean implies(Permission p) {
        if (p == null) {
            return false;
        }
        if (this.getClass() != p.getClass()) {
            return false;
        }
        MBeanServerPermission other = (MBeanServerPermission)p;
        if (this.wildcard) {
            return true;
        }
        if (other.wildcard) {
            return false;
        }
        if (this.targets.containsAll(other.targets)) {
            return true;
        }
        if (other.targets.contains("newMBeanServer") && this.targets.contains("createMBeanServer")) {
            int i = 0;
            while (i < other.targets.size()) {
                Object perm = other.targets.get(i);
                if (!"newMBeanServer".equals(perm) && !this.targets.contains(perm)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void parseName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Permission name cannot be null");
        }
        if ((name = name.trim()).length() == 0) {
            throw new IllegalArgumentException("Permission name cannot be empty");
        }
        this.targets = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(name, ",");
        while (tokenizer.hasMoreTokens()) {
            String target = tokenizer.nextToken().trim();
            if (target.length() == 0) continue;
            if ("*".equals(target)) {
                this.targets.clear();
                this.wildcard = true;
                return;
            }
            this.targets.add(target);
        }
        if (this.targets.size() < 1) {
            throw new IllegalArgumentException("Permission name does not contain targets");
        }
        Collections.sort(this.targets);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.parseName(this.getName());
    }
}

