/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.debug.model.AntDebugElement;
import org.eclipse.ant.internal.ui.debug.model.AntLineBreakpoint;
import org.eclipse.ant.internal.ui.editor.actions.AntEditorActionMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.RunToLineHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunToLineAdapter
implements IRunToLineTarget {
    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        IEditorPart editorPart = (IEditorPart)part;
        IEditorInput input = editorPart.getEditorInput();
        String errorMessage = null;
        if (input == null) {
            errorMessage = AntEditorActionMessages.getString("RunToLineAdapter.0");
        } else {
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocumentProvider provider = textEditor.getDocumentProvider();
            IDocument document = provider.getDocument((Object)input);
            if (document == null) {
                errorMessage = AntEditorActionMessages.getString("RunToLineAdapter.1");
            } else {
                ITextSelection textSelection = (ITextSelection)selection;
                int lineNumber = textSelection.getStartLine() + 1;
                AntLineBreakpoint breakpoint = null;
                Map attributes = this.getRunToLineAttributes();
                IFile file = (IFile)input.getAdapter(IFile.class);
                if (file == null) {
                    errorMessage = AntEditorActionMessages.getString("RunToLineAdapter.2");
                } else {
                    IDebugTarget debugTarget;
                    breakpoint = new AntLineBreakpoint((IResource)file, lineNumber, attributes, false);
                    breakpoint.setPersisted(false);
                    errorMessage = AntEditorActionMessages.getString("RunToLineAdapter.3");
                    if (target instanceof IAdaptable && (debugTarget = (IDebugTarget)((IAdaptable)target).getAdapter(IDebugTarget.class)) != null) {
                        RunToLineHandler handler = new RunToLineHandler(debugTarget, target, (IBreakpoint)breakpoint);
                        handler.run((IProgressMonitor)new NullProgressMonitor());
                        return;
                    }
                }
            }
        }
        throw new CoreException((IStatus)new Status(4, AntUIPlugin.getUniqueIdentifier(), 120, errorMessage, null));
    }

    private Map getRunToLineAttributes() {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
        attributes.put("transient", Boolean.TRUE);
        attributes.put("org.eclipse.ant.ui.runToLineBreakpoint", Boolean.TRUE);
        return attributes;
    }

    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        return target instanceof AntDebugElement;
    }
}

