/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.build;

import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.core.build.BuildObject;
import org.eclipse.pde.internal.core.util.PropertiesUtil;

public class BuildEntry
extends BuildObject
implements IBuildEntry {
    private Vector tokens = new Vector();
    private String name;

    public BuildEntry(String name) {
        this.name = name;
    }

    public void addToken(String token) throws CoreException {
        this.ensureModelEditable();
        this.tokens.add(token);
        this.getModel().fireModelChanged(new ModelChangedEvent(this.getModel(), 1, new Object[]{token}, null));
    }

    public String getName() {
        return this.name;
    }

    public String[] getTokens() {
        Object[] result = new String[this.tokens.size()];
        this.tokens.copyInto(result);
        return result;
    }

    public boolean contains(String token) {
        return this.tokens.contains(token);
    }

    void processEntry(String value) {
        StringTokenizer stok = new StringTokenizer(value, ",");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            token = token.trim();
            this.tokens.add(token);
        }
    }

    public void removeToken(String token) throws CoreException {
        this.ensureModelEditable();
        this.tokens.remove(token);
        this.getModel().fireModelChanged(new ModelChangedEvent(this.getModel(), 2, new Object[]{token}, null));
    }

    public void renameToken(String oldName, String newName) throws CoreException {
        this.ensureModelEditable();
        int i = 0;
        while (i < this.tokens.size()) {
            if (this.tokens.elementAt(i).toString().equals(oldName)) {
                this.tokens.setElementAt(newName, i);
                break;
            }
            ++i;
        }
        this.getModel().fireModelChanged(new ModelChangedEvent(this.getModel(), 3, new Object[]{oldName}, null));
    }

    public void setName(String name) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.name;
        this.name = name;
        this.getModel().fireModelObjectChanged(this, "name", oldValue, name);
    }

    public String toString() {
        return this.name;
    }

    public void write(String indent, PrintWriter writer) {
        PropertiesUtil.writeKeyValuePair(indent, this.name, this.tokens.elements(), writer);
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("name")) {
            this.setName(newValue != null ? newValue.toString() : null);
        }
    }
}

