/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.CheckedInChangeSet;
import org.eclipse.team.internal.ui.synchronize.ChangeSetDiffNode;
import org.eclipse.team.internal.ui.synchronize.ChangeSetModelProvider;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;

public class ChangeSetModelSorter
extends ViewerSorter {
    private int commentCriteria;
    private ChangeSetModelProvider provider;
    public static final int DATE = 1;
    public static final int COMMENT = 2;
    public static final int USER = 3;

    public ChangeSetModelSorter(ChangeSetModelProvider provider, int commentCriteria) {
        this.provider = provider;
        this.commentCriteria = commentCriteria;
    }

    protected int classComparison(Object element) {
        if (element instanceof ChangeSetDiffNode) {
            ChangeSet set = ((ChangeSetDiffNode)element).getSet();
            if (set instanceof ActiveChangeSet) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    protected int compareClass(Object element1, Object element2) {
        return this.classComparison(element1) - this.classComparison(element2);
    }

    protected int compareNames(String s1, String s2) {
        return this.collator.compare(s1, s2);
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        if (o1 instanceof ChangeSetDiffNode && o2 instanceof ChangeSetDiffNode) {
            ChangeSet s1 = ((ChangeSetDiffNode)o1).getSet();
            ChangeSet s2 = ((ChangeSetDiffNode)o2).getSet();
            if (s1 instanceof ActiveChangeSet && s2 instanceof ActiveChangeSet) {
                return this.compareNames(((ActiveChangeSet)s1).getTitle(), ((ActiveChangeSet)s2).getTitle());
            }
            if (s1 instanceof CheckedInChangeSet && s2 instanceof CheckedInChangeSet) {
                CheckedInChangeSet r1 = (CheckedInChangeSet)s1;
                CheckedInChangeSet r2 = (CheckedInChangeSet)s2;
                if (this.commentCriteria == 1) {
                    return r1.getDate().compareTo(r2.getDate());
                }
                if (this.commentCriteria == 2) {
                    return this.compareNames(r1.getComment(), r2.getComment());
                }
                if (this.commentCriteria == 3) {
                    return this.compareNames(r1.getAuthor(), r2.getAuthor());
                }
                return 0;
            }
            if (s1 instanceof ActiveChangeSet) {
                return -1;
            }
            if (s2 instanceof ActiveChangeSet) {
                return 1;
            }
            if (s1 instanceof CheckedInChangeSet) {
                return -1;
            }
            if (s2 instanceof CheckedInChangeSet) {
                return 1;
            }
        }
        if (o1 instanceof ISynchronizeModelElement && o2 instanceof ISynchronizeModelElement) {
            ViewerSorter embeddedSorter = this.provider.getEmbeddedSorter();
            if (embeddedSorter != null) {
                return embeddedSorter.compare(viewer, o1, o2);
            }
            this.compareNames(((ISynchronizeModelElement)o1).getName(), ((ISynchronizeModelElement)o2).getName());
        } else {
            if (o1 instanceof ISynchronizeModelElement) {
                return 1;
            }
            if (o2 instanceof ISynchronizeModelElement) {
                return -1;
            }
        }
        return 0;
    }

    public int getCommentCriteria() {
        return this.commentCriteria;
    }
}

