/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.scripting;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.scripting.CreateRefactoringScriptWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.scripting.ScriptingMessages;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class CreateRefactoringScriptWizard
extends Wizard {
    private static String DIALOG_SETTINGS_KEY = "CreateRefactoringScriptWizard";
    private boolean fNewSettings;
    private RefactoringDescriptorProxy[] fRefactoringDescriptors = new RefactoringDescriptorProxy[0];
    private RefactoringHistory fRefactoringHistory;
    private URI fScriptLocation = null;
    private boolean fUseClipboard = false;
    private final CreateRefactoringScriptWizardPage fWizardPage;

    public CreateRefactoringScriptWizard() {
        this.setNeedsProgressMonitor(false);
        this.setWindowTitle(ScriptingMessages.CreateRefactoringScriptWizard_caption);
        this.setDefaultPageImageDescriptor(RefactoringPluginImages.DESC_WIZBAN_CREATE_SCRIPT);
        IDialogSettings settings = RefactoringUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fNewSettings = true;
        } else {
            this.fNewSettings = false;
            this.setDialogSettings(section);
        }
        try {
            IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (context == null) {
                context = PlatformUI.getWorkbench().getProgressService();
            }
            context.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IRefactoringHistoryService service = RefactoringCore.getHistoryService();
                    try {
                        service.connect();
                        CreateRefactoringScriptWizard.this.fRefactoringHistory = service.getWorkspaceHistory(monitor);
                    }
                    finally {
                        service.disconnect();
                    }
                }
            });
        }
        catch (InvocationTargetException exception) {
            RefactoringUIPlugin.log(exception);
        }
        catch (InterruptedException interruptedException) {}
        this.fWizardPage = new CreateRefactoringScriptWizardPage(this);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.fWizardPage);
    }

    public boolean canFinish() {
        return (this.fUseClipboard || this.fScriptLocation != null) && this.fRefactoringDescriptors.length > 0;
    }

    public RefactoringHistory getRefactoringHistory() {
        return this.fRefactoringHistory;
    }

    /*
     * Unable to fully structure code
     */
    private boolean performExport() {
        block69: {
            block64: {
                writable = this.fRefactoringDescriptors;
                if (this.fScriptLocation == null) break block69;
                file = new File(this.fScriptLocation);
                if (file.exists()) {
                    message = new MessageDialog(this.getShell(), this.getShell().getText(), null, Messages.format(ScriptingMessages.CreateRefactoringScriptWizard_overwrite_query, new String[]{ScriptingMessages.CreateRefactoringScriptWizard_merge_button, ScriptingMessages.CreateRefactoringScriptWizard_overwrite_button}), 3, new String[]{ScriptingMessages.CreateRefactoringScriptWizard_merge_button, ScriptingMessages.CreateRefactoringScriptWizard_overwrite_button, IDialogConstants.CANCEL_LABEL}, 0);
                    result = message.open();
                    if (result == 0) {
                        stream = null;
                        try {
                            stream = new BufferedInputStream(new FileInputStream(file));
                            existing = RefactoringCore.getHistoryService().readRefactoringHistory(stream, 0).getDescriptors();
                            set = new HashSet<RefactoringDescriptorProxy>();
                            index = 0;
                            while (index < existing.length) {
                                set.add(existing[index]);
                                ++index;
                            }
                            index = 0;
                            while (index < this.fRefactoringDescriptors.length) {
                                set.add(this.fRefactoringDescriptors[index]);
                                ++index;
                            }
                            writable = new RefactoringDescriptorProxy[set.size()];
                            set.toArray(writable);
                        }
                        catch (FileNotFoundException exception) {
                            MessageDialog.openError((Shell)this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)exception.getLocalizedMessage());
lbl32:
                            // 2 sources

                            while (true) {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (IOException v0) {}
                                }
                                return true;
                            }
                        }
                        catch (CoreException exception) {
                            block63: {
                                try {
                                    throwable = exception.getStatus().getException();
                                    if (throwable instanceof IOException) {
                                        MessageDialog.openError((Shell)this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)throwable.getLocalizedMessage());
                                        ** continue;
                                    }
                                    RefactoringUIPlugin.log(exception);
                                    if (stream == null) break block63;
                                }
                                catch (Throwable var9_26) {
                                    if (stream != null) {
                                        try {
                                            stream.close();
                                        }
                                        catch (IOException v1) {}
                                    }
                                    throw var9_26;
                                }
                                try {
                                    stream.close();
                                }
                                catch (IOException v2) {}
                            }
                            return false;
                        }
                        ** if (stream == null) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            try {
                                stream.close();
                            }
                            catch (IOException v3) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block64;
                        }
                    }
                    if (result == 2) {
                        return false;
                    }
                }
            }
            stream = new OutputStream[1];
            try {
                stream[0] = new BufferedOutputStream(new FileOutputStream(file));
                Arrays.sort(writable, new Comparator(){

                    public final int compare(Object first, Object second) {
                        RefactoringDescriptorProxy predecessor = (RefactoringDescriptorProxy)first;
                        RefactoringDescriptorProxy successor = (RefactoringDescriptorProxy)second;
                        long delta = predecessor.getTimeStamp() - successor.getTimeStamp();
                        if (delta > 0L) {
                            return 1;
                        }
                        if (delta < 0L) {
                            return -1;
                        }
                        return 0;
                    }
                });
                finalWritable = writable;
                try {
                    this.getContainer().run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                RefactoringCore.getHistoryService().writeRefactoringDescriptors(finalWritable, stream[0], 0, false, monitor);
                            }
                            catch (CoreException exception) {
                                throw new InvocationTargetException(exception);
                            }
                        }
                    });
                }
                catch (InvocationTargetException exception) {
                    throwable = exception.getTargetException();
                    if (throwable instanceof CoreException) {
                        extended = (CoreException)throwable;
                        throw extended;
                    }
                }
                catch (InterruptedException v4) {}
            }
            catch (CoreException exception) {
                block70: {
                    throwable = exception.getStatus().getException();
                    if (!(throwable instanceof IOException)) break block70;
                    MessageDialog.openError((Shell)this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)throwable.getLocalizedMessage());
                    ** GOTO lbl85
                }
                RefactoringUIPlugin.log(exception);
                if (stream[0] != null) {
                    try {
                        stream[0].close();
                    }
                    catch (IOException v6) {}
                }
                return false;
            }
            catch (FileNotFoundException exception) {
                MessageDialog.openError((Shell)this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)exception.getLocalizedMessage());
                ** continue;
                {
                    catch (Throwable var8_25) {
                        if (stream[0] != null) {
                            try {
                                stream[0].close();
                            }
                            catch (IOException v7) {}
                        }
                        throw var8_25;
                    }
                }
            }
lbl85:
            // 3 sources

            while (true) {
                if (stream[0] != null) {
                    try {
                        stream[0].close();
                    }
                    catch (IOException v5) {}
                }
                return true;
            }
        }
        if (this.fUseClipboard) {
            block67: {
                stream = new ByteArrayOutputStream(2048);
                Arrays.sort(writable, new Comparator(){

                    public final int compare(Object first, Object second) {
                        RefactoringDescriptorProxy predecessor = (RefactoringDescriptorProxy)first;
                        RefactoringDescriptorProxy successor = (RefactoringDescriptorProxy)second;
                        long delta = predecessor.getTimeStamp() - successor.getTimeStamp();
                        if (delta > 0L) {
                            return 1;
                        }
                        if (delta < 0L) {
                            return -1;
                        }
                        return 0;
                    }
                });
                finalWritable = writable;
                try {
                    this.getContainer().run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                RefactoringCore.getHistoryService().writeRefactoringDescriptors(finalWritable, (OutputStream)stream, 0, false, monitor);
                            }
                            catch (CoreException exception) {
                                throw new InvocationTargetException(exception);
                            }
                        }
                    });
                }
                catch (InvocationTargetException exception) {
                    throwable = exception.getTargetException();
                    if (throwable instanceof CoreException) {
                        extended = (CoreException)throwable;
                        throw extended;
                    }
                }
                catch (InterruptedException v8) {}
                string = stream.toString("utf-8");
                clipboard = null;
                clipboard = new Clipboard(this.getShell().getDisplay());
                clipboard.setContents(new Object[]{string}, new Transfer[]{TextTransfer.getInstance()});
                if (clipboard == null) break block67;
                clipboard.dispose();
            }
            return true;
            {
                catch (SWTError error) {
                    block68: {
                        try {
                            MessageDialog.openError((Shell)this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)error.getLocalizedMessage());
                            if (clipboard == null) break block68;
                        }
                        catch (Throwable var7_23) {
                            try {
                                try {
                                    if (clipboard != null) {
                                        clipboard.dispose();
                                    }
                                    throw var7_23;
                                }
                                catch (UnsupportedEncodingException v9) {
                                    return false;
                                }
                            }
                            catch (CoreException exception) {
                                throwable = exception.getStatus().getException();
                                if (throwable instanceof IOException) {
                                    MessageDialog.openError((Shell)this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)throwable.getLocalizedMessage());
                                    return true;
                                }
                                RefactoringUIPlugin.log(exception);
                                return false;
                            }
                        }
                        clipboard.dispose();
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public boolean performFinish() {
        if (this.fNewSettings) {
            IDialogSettings settings = RefactoringUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
            section = settings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        this.fWizardPage.performFinish();
        return this.performExport();
    }

    public void setRefactoringDescriptors(RefactoringDescriptorProxy[] proxies) {
        Assert.isNotNull((Object)proxies);
        this.fRefactoringDescriptors = proxies;
        IWizardContainer wizard = this.getContainer();
        if (wizard.getCurrentPage() != null) {
            wizard.updateButtons();
        }
    }

    public void setRefactoringScript(URI location) {
        this.fScriptLocation = location;
        IWizardContainer wizard = this.getContainer();
        if (wizard.getCurrentPage() != null) {
            wizard.updateButtons();
        }
    }

    public void setUseClipboard(boolean clipboard) {
        this.fUseClipboard = clipboard;
        IWizardContainer wizard = this.getContainer();
        if (wizard.getCurrentPage() != null) {
            wizard.updateButtons();
        }
    }
}

