/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo;

import org.eclipse.gef.commands.Command;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.ui.internal.tabletree.TreeContentHelper;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateAttributeValueCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateTextValueCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.ExtensionItem;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class DOMExtensionItem
extends ExtensionItem {
    private static final int KIND_ELEMENT_ATTR = 1;
    private static final int KIND_ELEMENT_TEXT = 2;
    private static final int KIND_ELEMENT_CMATTRIBUTE = 3;
    private static final int KIND_ATTR_TEXT = 4;
    int kind;
    Attr attribute;
    Element parent;
    CMNode cmNode;

    private DOMExtensionItem(int kind, Element parent, Attr node, CMNode cmNode) {
        this.kind = kind;
        this.parent = parent;
        this.attribute = node;
        this.cmNode = cmNode;
    }

    public boolean isTextValue() {
        return this.kind == 2 || this.kind == 4;
    }

    static DOMExtensionItem createItemForElementText(Element parent) {
        return new DOMExtensionItem(2, parent, null, null);
    }

    static DOMExtensionItem createItemForElementAttribute(Element parent, Attr attribute) {
        return new DOMExtensionItem(1, parent, attribute, null);
    }

    static DOMExtensionItem createItemForElementAttribute(Element parent, CMAttributeDeclaration ad) {
        if (ad == null) {
            System.out.println("null!");
        }
        return new DOMExtensionItem(3, parent, null, (CMNode)ad);
    }

    static DOMExtensionItem createItemForAttributeText(Element parent, Attr attribute) {
        return new DOMExtensionItem(4, parent, attribute, null);
    }

    public String getName() {
        String result = null;
        switch (this.kind) {
            case 4: {
                result = "value";
                break;
            }
            case 1: {
                result = this.attribute.getName();
                break;
            }
            case 3: {
                CMAttributeDeclaration ad = (CMAttributeDeclaration)this.cmNode;
                result = ad.getNodeName();
                break;
            }
            case 2: {
                result = "text value";
            }
        }
        return result != null ? result : "";
    }

    public String getValue() {
        switch (this.kind) {
            case 1: 
            case 4: {
                return this.attribute.getNodeValue();
            }
            case 3: {
                String value = this.parent.getAttribute(this.cmNode.getNodeName());
                return value != null ? value : "";
            }
            case 2: {
                return new TreeContentHelper().getElementTextValue(this.parent);
            }
        }
        return "";
    }

    public String[] getPossibleValues() {
        String[] result = new String[]{};
        switch (this.kind) {
            case 1: 
            case 4: {
                CMAttributeDeclaration ad;
                ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)this.parent.getOwnerDocument());
                if (modelQuery == null || (ad = modelQuery.getCMAttributeDeclaration(this.attribute)) == null) break;
                result = modelQuery.getPossibleDataTypeValues(this.parent, (CMNode)ad);
                break;
            }
            case 3: {
                ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)this.parent.getOwnerDocument());
                if (modelQuery == null || this.cmNode == null) break;
                result = modelQuery.getPossibleDataTypeValues(this.parent, this.cmNode);
                break;
            }
            case 2: {
                CMElementDeclaration ed;
                ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)this.parent.getOwnerDocument());
                if (modelQuery == null || (ed = modelQuery.getCMElementDeclaration(this.parent)) == null) break;
                result = modelQuery.getPossibleDataTypeValues(this.parent, (CMNode)ed);
            }
        }
        return result;
    }

    public Command getUpdateValueCommand(String newValue) {
        switch (this.kind) {
            case 1: 
            case 4: {
                return new UpdateAttributeValueCommand(this.parent, this.attribute.getNodeName(), newValue, true);
            }
            case 3: {
                CMAttributeDeclaration ad = (CMAttributeDeclaration)this.cmNode;
                return new UpdateAttributeValueCommand(this.parent, ad.getAttrName(), newValue, true);
            }
            case 2: {
                return new UpdateTextValueCommand(this.parent, newValue);
            }
        }
        return null;
    }

    public String getNamespace() {
        String namespace = null;
        if (this.kind == 4) {
            namespace = this.attribute.getNamespaceURI();
        } else if (this.parent != null) {
            namespace = this.parent.getNamespaceURI();
        }
        return namespace;
    }

    public Node getParentNode() {
        Element parentNode = null;
        if (this.attribute != null) {
            parentNode = this.attribute.getOwnerElement();
        } else if (this.parent != null) {
            parentNode = this.parent;
        }
        return parentNode;
    }

    public String getParentName() {
        Node parentNode = this.getParentNode();
        return parentNode != null ? parentNode.getLocalName() : "";
    }

    public Node getNode() {
        return this.attribute;
    }
}

