/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.command.common.AddModuleToServerCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.AssociateModuleWithEARCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateModuleCommand;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;

public class CreateSampleProjectCommand
extends AbstractDataModelOperation {
    private String sampleProject;
    private String sampleProjectEar;
    private IServer existingServer;
    private String serverFactoryId;
    private boolean needEAR;
    private String j2eeVersion;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (!root.getProject(this.sampleProject).exists() || !root.getProject(this.sampleProjectEar).exists()) {
            CreateModuleCommand command = new CreateModuleCommand();
            command.setProjectName(this.sampleProject);
            command.setModuleName(this.sampleProject);
            command.setModuleType(1);
            command.setServerFactoryId(this.serverFactoryId);
            command.setServerInstanceId(this.existingServer.getId());
            command.setJ2eeLevel(this.j2eeVersion);
            command.setEnvironment(env);
            IStatus status = command.execute(monitor, null);
            if (status.getSeverity() == 4) {
                env.getStatusHandler().reportError(status);
                return status;
            }
            if (this.needEAR) {
                CreateModuleCommand commandEAR = new CreateModuleCommand();
                commandEAR.setProjectName(this.sampleProjectEar);
                commandEAR.setModuleName(this.sampleProjectEar);
                commandEAR.setModuleType(8);
                commandEAR.setServerFactoryId(this.serverFactoryId);
                commandEAR.setServerInstanceId(this.existingServer.getId());
                commandEAR.setJ2eeLevel(this.j2eeVersion);
                commandEAR.setEnvironment(env);
                status = commandEAR.execute(monitor, null);
                if (status.getSeverity() == 4) {
                    env.getStatusHandler().reportError(status);
                    return status;
                }
                AssociateModuleWithEARCommand associateCommand = new AssociateModuleWithEARCommand();
                associateCommand.setProject(this.sampleProject);
                associateCommand.setModule(this.sampleProject);
                associateCommand.setEARProject(this.sampleProjectEar);
                associateCommand.setEar(this.sampleProjectEar);
                associateCommand.setEnvironment(env);
                status = associateCommand.execute(monitor, null);
                if (status.getSeverity() == 4) {
                    env.getStatusHandler().reportError(status);
                    return status;
                }
                AddModuleToServerCommand commandInstall = new AddModuleToServerCommand();
                commandInstall.setServerInstanceId(this.existingServer.getId());
                commandInstall.setProject(this.sampleProjectEar);
                commandInstall.setModule(this.sampleProjectEar);
                commandInstall.setEnvironment(env);
                status = commandInstall.execute(monitor, null);
                if (status.getSeverity() == 4) {
                    env.getStatusHandler().reportError(status);
                    return status;
                }
            } else {
                AddModuleToServerCommand commandInstall = new AddModuleToServerCommand();
                commandInstall.setServerInstanceId(this.existingServer.getId());
                commandInstall.setProject(this.sampleProject);
                commandInstall.setModule(this.sampleProject);
                commandInstall.setEnvironment(env);
                status = commandInstall.execute(monitor, null);
                if (status.getSeverity() == 4) {
                    env.getStatusHandler().reportError(status);
                    return status;
                }
            }
        }
        return Status.OK_STATUS;
    }

    public void setSampleProject(String sampleProject) {
        this.sampleProject = sampleProject;
    }

    public void setSampleProjectEAR(String sampleProjectEar) {
        this.sampleProjectEar = sampleProjectEar;
    }

    public void setExistingServer(IServer existingServer) {
        this.existingServer = existingServer;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId = serverFactoryId;
    }

    public void setNeedEAR(boolean needEAR) {
        this.needEAR = needEAR;
    }

    public void setJ2eeVersion(String version) {
        this.j2eeVersion = version;
    }
}

