/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.generatediff;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.wizards.generatediff.GenerateDiffFileOperation;
import org.tigris.subversion.subclipse.ui.wizards.generatediff.PatchFileCreationOptionsPage;
import org.tigris.subversion.subclipse.ui.wizards.generatediff.PatchFileSelectionPage;

public class GenerateDiffFileWizard
extends Wizard {
    private PatchFileSelectionPage mainPage;
    private PatchFileCreationOptionsPage optionsPage;
    private IStructuredSelection selection;
    private IResource resource;

    public GenerateDiffFileWizard(IStructuredSelection selection, IResource resource) {
        this.selection = selection;
        this.resource = resource;
        this.setWindowTitle(Policy.bind("GenerateSVNDiff.title"));
        this.initializeDefaultPageImageDescriptor();
    }

    public void addPages() {
        String pageTitle = Policy.bind("GenerateSVNDiff.pageTitle");
        String pageDescription = Policy.bind("GenerateSVNDiff.pageDescription");
        this.mainPage = new PatchFileSelectionPage(pageTitle, pageTitle, SVNUIPlugin.getPlugin().getImageDescriptor("wizban/createpatch_wizban.gif"), this.selection);
        this.mainPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.mainPage);
        pageTitle = Policy.bind("GenerateSVNDiff.AdvancedOptions");
        pageDescription = Policy.bind("GenerateSVNDiff.ConfigureOptions");
        this.optionsPage = new PatchFileCreationOptionsPage(this, pageTitle, pageTitle, SVNUIPlugin.getPlugin().getImageDescriptor("wizban/createpatch_wizban.gif"));
        this.optionsPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.optionsPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected void initializeDefaultPageImageDescriptor() {
        String iconPath = "icons/full/";
        try {
            URL installURL = SVNUIPlugin.getPlugin().getBundle().getEntry("/");
            URL url = new URL(installURL, String.valueOf(iconPath) + "wizards/newconnect_wiz.gif");
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.setDefaultPageImageDescriptor(desc);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        String fs = this.mainPage.getFilesystemFile();
        IFile ws = this.mainPage.getWorkspaceFile();
        int type = this.mainPage.getSaveType();
        try {
            if (type == this.mainPage.CLIPBOARD) {
                this.getContainer().run(true, true, (IRunnableWithProgress)new GenerateDiffFileOperation(this.resource, null, true, this.optionsPage.isRecursive(), this.getShell()));
                return true;
            }
            File file = new File(fs != null ? fs : ws.getLocation().toOSString());
            if (file.exists()) {
                String title = Policy.bind("GenerateSVNDiff.overwriteTitle");
                String msg = Policy.bind("GenerateSVNDiff.overwriteMsg");
                MessageDialog dialog = new MessageDialog(this.getShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                dialog.open();
                if (dialog.getReturnCode() != 0) {
                    return false;
                }
            }
            this.getContainer().run(true, true, (IRunnableWithProgress)new GenerateDiffFileOperation(this.resource, file, false, this.optionsPage.isRecursive(), this.getShell()));
            if (type != this.mainPage.WORKSPACE) return true;
            ws.getParent().refreshLocal(1, null);
            return true;
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        catch (CoreException e) {
            SVNUIPlugin.openError(this.getShell(), Policy.bind("GenerateSVNDiff.error"), null, e);
            return false;
        }
        catch (InvocationTargetException e2) {
            SVNUIPlugin.openError(this.getShell(), Policy.bind("GenerateSVNDiff.error"), null, e2);
            return false;
        }
    }
}

