/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.internal.ui.dialogs.ISelectionValidator;
import org.rubypeople.rdt.internal.ui.dialogs.SelectionStatusDialog;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.util.FilteredList;

public abstract class AbstractElementListSelectionDialog
extends SelectionStatusDialog {
    private ILabelProvider fRenderer;
    private boolean fIgnoreCase = true;
    private boolean fIsMultipleSelection = false;
    private boolean fMatchEmptyString = true;
    private boolean fAllowDuplicates = true;
    private Label fMessage;
    protected FilteredList fFilteredList;
    private Text fFilterText;
    private ISelectionValidator fValidator;
    private String fFilter = null;
    private String fEmptyListMessage = "";
    private String fEmptySelectionMessage = "";
    private int fWidth = 60;
    private int fHeight = 18;
    private Object[] fSelection = new Object[0];

    protected AbstractElementListSelectionDialog(Shell shell, ILabelProvider iLabelProvider) {
        super(shell);
        this.fRenderer = iLabelProvider;
        int n = this.getShellStyle();
        this.setShellStyle(n | 0x400 | 0x10);
    }

    protected void handleDefaultSelected() {
        if (this.validateCurrentSelection()) {
            this.buttonPressed(0);
        }
    }

    public void setIgnoreCase(boolean bl) {
        this.fIgnoreCase = bl;
    }

    public boolean isCaseIgnored() {
        return this.fIgnoreCase;
    }

    public void setMatchEmptyString(boolean bl) {
        this.fMatchEmptyString = bl;
    }

    public void setMultipleSelection(boolean bl) {
        this.fIsMultipleSelection = bl;
    }

    public void setAllowDuplicates(boolean bl) {
        this.fAllowDuplicates = bl;
    }

    public void setSize(int n, int n2) {
        this.fWidth = n;
        this.fHeight = n2;
    }

    public void setEmptyListMessage(String string) {
        this.fEmptyListMessage = string;
    }

    public void setEmptySelectionMessage(String string) {
        this.fEmptySelectionMessage = string;
    }

    public void setValidator(ISelectionValidator iSelectionValidator) {
        this.fValidator = iSelectionValidator;
    }

    protected void setListElements(Object[] objectArray) {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        this.fFilteredList.setElements(objectArray);
    }

    public void setFilter(String string) {
        if (this.fFilterText == null) {
            this.fFilter = string;
        } else {
            this.fFilterText.setText(string);
        }
    }

    public String getFilter() {
        if (this.fFilteredList == null) {
            return this.fFilter;
        }
        return this.fFilteredList.getFilter();
    }

    protected int[] getSelectionIndices() {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        return this.fFilteredList.getSelectionIndices();
    }

    protected int getSelectionIndex() {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        return this.fFilteredList.getSelectionIndex();
    }

    protected void setSelection(Object[] objectArray) {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        this.fFilteredList.setSelection(objectArray);
    }

    protected Object[] getSelectedElements() {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        return this.fFilteredList.getSelection();
    }

    public Object[] getFoldedElements(int n) {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        return this.fFilteredList.getFoldedElements(n);
    }

    protected Label createMessageArea(Composite composite) {
        Label label = super.createMessageArea(composite);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        label.setLayoutData((Object)gridData);
        this.fMessage = label;
        return label;
    }

    protected void handleSelectionChanged() {
        this.validateCurrentSelection();
    }

    protected boolean validateCurrentSelection() {
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        Object[] objectArray = this.getSelectedElements();
        Object object = objectArray.length > 0 ? (this.fValidator != null ? this.fValidator.validate(objectArray) : new StatusInfo()) : (this.fFilteredList.isEmpty() ? new StatusInfo(4, this.fEmptyListMessage) : new StatusInfo(4, this.fEmptySelectionMessage));
        this.updateStatus((IStatus)object);
        return object.isOK();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected FilteredList createFilteredList(Composite composite) {
        int n = 0xB00 | (this.fIsMultipleSelection ? 2 : 4);
        FilteredList filteredList = new FilteredList(composite, n, this.fRenderer, this.fIgnoreCase, this.fAllowDuplicates, this.fMatchEmptyString);
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        gridData.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        filteredList.setLayoutData(gridData);
        filteredList.setFilter(this.fFilter == null ? "" : this.fFilter);
        filteredList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                AbstractElementListSelectionDialog.this.handleDefaultSelected();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractElementListSelectionDialog.this.handleWidgetSelected();
            }
        });
        this.fFilteredList = filteredList;
        return filteredList;
    }

    private void handleWidgetSelected() {
        Object[] objectArray = this.fFilteredList.getSelection();
        if (objectArray.length != this.fSelection.length) {
            this.fSelection = objectArray;
            this.handleSelectionChanged();
        } else {
            int n = 0;
            while (n != objectArray.length) {
                if (!objectArray[n].equals(this.fSelection[n])) {
                    this.fSelection = objectArray;
                    this.handleSelectionChanged();
                    break;
                }
                ++n;
            }
        }
    }

    protected Text createFilterText(Composite composite) {
        Text text = new Text(composite, 2048);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        text.setLayoutData((Object)gridData);
        text.setText(this.fFilter == null ? "" : this.fFilter);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                AbstractElementListSelectionDialog.this.fFilteredList.setFilter(AbstractElementListSelectionDialog.this.fFilterText.getText());
            }
        };
        text.addListener(24, listener);
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x1000002) {
                    AbstractElementListSelectionDialog.this.fFilteredList.setFocus();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.fFilterText = text;
        return text;
    }

    public int open() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                AbstractElementListSelectionDialog.this.access$superOpen();
            }
        });
        return this.getReturnCode();
    }

    private void access$superOpen() {
        super.open();
    }

    public void create() {
        super.create();
        Assert.isNotNull((Object)((Object)this.fFilteredList));
        if (this.fFilteredList.isEmpty()) {
            this.handleEmptyList();
        } else {
            this.validateCurrentSelection();
            this.fFilterText.selectAll();
            this.fFilterText.setFocus();
        }
    }

    protected void handleEmptyList() {
        this.fMessage.setEnabled(false);
        this.fFilterText.setEnabled(false);
        this.fFilteredList.setEnabled(false);
    }
}

