/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.validation.swingui;

import ca.sqlpower.architect.swingui.StatusIcon;
import ca.sqlpower.validation.ValidateResult;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class StatusComponent
extends JLabel {
    private static final Logger logger = Logger.getLogger(StatusComponent.class);
    private static final Border DEFAULT_BORDER = BorderFactory.createEmptyBorder(7, 0, 7, 0);
    private ValidateResult result = null;

    public StatusComponent() {
        this.setOpaque(true);
        this.setBorder(DEFAULT_BORDER);
        this.setResult(null);
    }

    public void setResult(ValidateResult error) {
        Icon icon;
        String text;
        this.result = error;
        if (this.result == null) {
            text = null;
            icon = StatusIcon.getNullIcon();
        } else {
            text = this.result.getMessage();
            switch (this.result.getStatus()) {
                case OK: {
                    icon = StatusIcon.getNullIcon();
                    break;
                }
                case WARN: {
                    icon = StatusIcon.getWarnIcon();
                    break;
                }
                case FAIL: {
                    icon = StatusIcon.getFailIcon();
                    break;
                }
                default: {
                    icon = StatusIcon.getNullIcon();
                }
            }
        }
        this.setText(text);
        this.setIcon(icon);
    }

    public void setText(String text) {
        if (text == null || text.trim().length() == 0) {
            text = "&nbsp;";
        }
        super.setText("<html>" + text);
    }

    public ValidateResult getResult() {
        return this.result;
    }
}

