/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectRuntimeException;
import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.IOUtils;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLExceptionNode;
import ca.sqlpower.architect.SQLIndex;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.UserSettings;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.etl.PLExport;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ColumnValueCount;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.TableProfileManager;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.CompareDMSettings;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.DBTreeModel;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.ProfileManagerView;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.event.PlayPenComponentEvent;
import ca.sqlpower.architect.swingui.event.PlayPenComponentListener;
import ca.sqlpower.architect.undo.UndoManager;
import java.awt.Frame;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.ToolTipManager;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SwingUIProject {
    private static final Logger logger = Logger.getLogger(SwingUIProject.class);
    private ArchitectSession session = ArchitectFrame.getMainInstance().getArchitectSession();
    private String name;
    private DBTree sourceDatabases;
    private PlayPen playPen;
    private UndoManager undoManager;
    private File file;
    private GenericDDLGenerator ddlGenerator;
    private boolean savingEntireSource;
    private PLExport plExport;
    private CompareDMSettings compareDMSettings;
    private ProfileManagerView profileManagerView;
    final JDialog profileDialog = new JDialog((Frame)ArchitectFrame.getMainInstance(), "Table Profiles");
    private boolean modified;
    private boolean saveInProgress;
    private PrintWriter out;
    private Map objectIdMap;
    private Map dbcsIdMap;
    private ProgressMonitor pm;
    private int progress = 0;
    private SQLIndex currentIndex;
    IOUtils ioo = new IOUtils();

    public boolean isSaveInProgress() {
        return this.saveInProgress;
    }

    public void setSaveInProgress(boolean saveInProgress) {
        this.saveInProgress = saveInProgress;
    }

    public SwingUIProject(String name) throws ArchitectException {
        this.name = name;
        SQLDatabase ppdb = new SQLDatabase();
        PlayPen pp = new PlayPen(ppdb);
        ToolTipManager.sharedInstance().registerComponent(pp);
        this.setPlayPen(pp);
        ArrayList<SQLDatabase> initialDBList = new ArrayList<SQLDatabase>();
        initialDBList.add(this.playPen.getDatabase());
        this.profileManagerView = new ProfileManagerView(this.session.getProfileManager());
        this.session.getProfileManager().addProfileChangeListener(this.profileManagerView);
        this.profileDialog.add(this.profileManagerView);
        this.profileDialog.setLocationRelativeTo(ArchitectFrame.getMainInstance());
        this.sourceDatabases = new DBTree(initialDBList);
        try {
            this.ddlGenerator = new GenericDDLGenerator();
        }
        catch (SQLException e) {
            throw new ArchitectException("SQL Error in ddlGenerator", e);
        }
        this.plExport = new PLExport();
        this.compareDMSettings = new CompareDMSettings();
        this.undoManager = new UndoManager(pp);
    }

    public void close() {
        for (SQLDatabase db : this.getSourceDatabases().getDatabaseList()) {
            logger.debug((Object)("closing connection: " + db.getName()));
            db.disconnect();
        }
        this.session.getProfileManager().clear();
        this.profileDialog.dispose();
    }

    public void load(InputStream in) throws IOException, ArchitectException {
        this.dbcsIdMap = new HashMap();
        this.objectIdMap = new HashMap();
        try {
            this.setupDigester().parse(in);
        }
        catch (SAXException ex) {
            logger.error((Object)"SAX Exception in config file parse!", (Throwable)ex);
            throw new ArchitectException("Syntax error in Project file", ex);
        }
        catch (IOException ex) {
            logger.error((Object)"IO Exception in config file parse!", (Throwable)ex);
            throw new ArchitectException("I/O Error", ex);
        }
        catch (Exception ex) {
            logger.error((Object)"General Exception in config file parse!", (Throwable)ex);
            throw new ArchitectException("Unexpected Exception", ex);
        }
        ((SQLObject)this.sourceDatabases.getModel().getRoot()).addChild(0, this.playPen.getDatabase());
        for (SQLTable table : this.playPen.getDatabase().getTables()) {
            if (logger.isDebugEnabled()) {
                if (!table.isPopulated()) {
                    logger.debug((Object)("Table [" + table.getName() + "] not populated"));
                } else if (table.getIndicesFolder() == null) {
                    logger.debug((Object)("Table [" + table.getName() + "] has null indices folder"));
                } else {
                    logger.debug((Object)("Table [" + table.getName() + "] index folder contents: " + table.getIndicesFolder().getChildren()));
                }
            }
            if (table.getIndicesFolder() == null) {
                logger.debug((Object)("this must be a very old version, we have to add the index folder manually. the table is [" + table.getName() + "]"));
                table.addChild(new SQLTable.Folder(4, true));
            }
            if (table.getPrimaryKeyIndex() == null) {
                logger.debug((Object)("primary key index is null in table: " + table));
                logger.debug((Object)("number of children found in indices folder: " + table.getIndicesFolder().getChildCount()));
                for (SQLIndex index : table.getIndicesFolder().getChildren()) {
                    if (this.objectIdMap.get(table.getName() + "." + index.getName()) == null) continue;
                    index.setPrimaryKeyIndex(true);
                    break;
                }
            }
            logger.debug((Object)("Table [" + table.getName() + "]2 index folder contents: " + table.getIndicesFolder().getChildren()));
            table.normalizePrimaryKey();
            logger.debug((Object)("Table [" + table.getName() + "]3 index folder contents: " + table.getIndicesFolder().getChildren()));
            if (!logger.isDebugEnabled()) continue;
            if (!table.isPopulated()) {
                logger.debug((Object)("Table [" + table.getName() + "] not populated"));
                continue;
            }
            if (table.getIndicesFolder() == null) {
                logger.debug((Object)("Table [" + table.getName() + "] has null indices folder"));
                continue;
            }
            logger.debug((Object)("Table [" + table.getName() + "] index folder contents: " + table.getIndicesFolder().getChildren()));
        }
        this.setModified(false);
        this.undoManager.discardAllEdits();
    }

    private Digester setupDigester() {
        Digester d = new Digester();
        d.setValidating(false);
        d.push((Object)this);
        d.addCallMethod("architect-project/project-name", "setName", 0);
        DBCSFactory dbcsFactory = new DBCSFactory();
        d.addFactoryCreate("architect-project/project-connection-specs/dbcs", (ObjectCreationFactory)dbcsFactory);
        d.addSetProperties("architect-project/project-connection-specs/dbcs", new String[]{"connection-name", "driver-class", "jdbc-url", "user-name", "user-pass", "sequence-number", "single-login"}, new String[]{"displayName", "driverClass", "url", "user", "pass", "seqNo", "singleLogin"});
        d.addCallMethod("architect-project/project-connection-specs/dbcs", "setName", 0);
        d.addFactoryCreate("architect-project/project-data-sources/data-source", (ObjectCreationFactory)dbcsFactory);
        d.addCallMethod("architect-project/project-data-sources/data-source/property", "put", 2);
        d.addCallParam("architect-project/project-data-sources/data-source/property", 0, "key");
        d.addCallParam("architect-project/project-data-sources/data-source/property", 1, "value");
        d.addObjectCreate("architect-project/source-databases", LinkedList.class);
        d.addSetNext("architect-project/source-databases", "setSourceDatabaseList");
        SQLDatabaseFactory dbFactory = new SQLDatabaseFactory();
        d.addFactoryCreate("architect-project/source-databases/database", (ObjectCreationFactory)dbFactory);
        d.addSetProperties("architect-project/source-databases/database");
        d.addSetNext("architect-project/source-databases/database", "add");
        d.addObjectCreate("architect-project/source-databases/database/catalog", SQLCatalog.class);
        d.addSetProperties("architect-project/source-databases/database/catalog");
        d.addSetNext("architect-project/source-databases/database/catalog", "addChild");
        SQLSchemaFactory schemaFactory = new SQLSchemaFactory();
        d.addFactoryCreate("*/schema", (ObjectCreationFactory)schemaFactory);
        d.addSetProperties("*/schema");
        d.addSetNext("*/schema", "addChild");
        SQLTableFactory tableFactory = new SQLTableFactory();
        d.addFactoryCreate("*/table", (ObjectCreationFactory)tableFactory);
        d.addSetProperties("*/table");
        d.addSetNext("*/table", "addChild");
        SQLFolderFactory folderFactory = new SQLFolderFactory();
        d.addFactoryCreate("*/folder", (ObjectCreationFactory)folderFactory);
        d.addSetProperties("*/folder");
        d.addSetNext("*/folder", "addChild");
        SQLColumnFactory columnFactory = new SQLColumnFactory();
        d.addFactoryCreate("*/column", (ObjectCreationFactory)columnFactory);
        d.addSetProperties("*/column");
        d.addCallMethod("*/column", "setSourceDataTypeName", 1);
        d.addCallParam("*/column", 0, "sourceDBTypeName");
        d.addCallMethod("*/column", "setSourceDataTypeName", 1);
        d.addCallParam("*/column", 0, "sourceDataTypeName");
        d.addSetNext("*/column", "addChild");
        SQLRelationshipFactory relationshipFactory = new SQLRelationshipFactory();
        d.addFactoryCreate("*/relationship", (ObjectCreationFactory)relationshipFactory);
        d.addSetProperties("*/relationship");
        ColumnMappingFactory columnMappingFactory = new ColumnMappingFactory();
        d.addFactoryCreate("*/column-mapping", (ObjectCreationFactory)columnMappingFactory);
        d.addSetProperties("*/column-mapping");
        d.addSetNext("*/column-mapping", "addChild");
        SQLIndexFactory indexFactory = new SQLIndexFactory();
        d.addFactoryCreate("*/index", (ObjectCreationFactory)indexFactory);
        d.addSetProperties("*/index");
        d.addSetNext("*/index", "addChild");
        SQLIndexColumnFactory indexColumnFactory = new SQLIndexColumnFactory();
        d.addFactoryCreate("*/index-column", (ObjectCreationFactory)indexColumnFactory);
        d.addSetProperties("*/index-column");
        d.addSetNext("*/index-column", "addChild");
        SQLExceptionFactory exceptionFactory = new SQLExceptionFactory();
        d.addFactoryCreate("*/sql-exception", (ObjectCreationFactory)exceptionFactory);
        d.addSetProperties("*/sql-exception");
        d.addSetNext("*/sql-exception", "addChild");
        TargetDBFactory targetDBFactory = new TargetDBFactory();
        d.addFactoryCreate("architect-project/target-database", (ObjectCreationFactory)targetDBFactory);
        d.addSetProperties("architect-project/target-database");
        TablePaneFactory tablePaneFactory = new TablePaneFactory();
        d.addFactoryCreate("architect-project/play-pen/table-pane", (ObjectCreationFactory)tablePaneFactory);
        PPRelationshipFactory ppRelationshipFactory = new PPRelationshipFactory();
        d.addFactoryCreate("architect-project/play-pen/table-link", (ObjectCreationFactory)ppRelationshipFactory);
        DDLGeneratorFactory ddlgFactory = new DDLGeneratorFactory();
        d.addFactoryCreate("architect-project/ddl-generator", (ObjectCreationFactory)ddlgFactory);
        d.addSetProperties("architect-project/ddl-generator");
        CompareDMSettingFactory settingFactory = new CompareDMSettingFactory();
        d.addFactoryCreate("architect-project/compare-dm-settings", (ObjectCreationFactory)settingFactory);
        d.addSetProperties("architect-project/compare-dm-settings");
        CompareDMStuffSettingFactory sourceStuffFactory = new CompareDMStuffSettingFactory(true);
        d.addFactoryCreate("architect-project/compare-dm-settings/source-stuff", (ObjectCreationFactory)sourceStuffFactory);
        d.addSetProperties("architect-project/compare-dm-settings/source-stuff");
        CompareDMStuffSettingFactory targetStuffFactory = new CompareDMStuffSettingFactory(false);
        d.addFactoryCreate("architect-project/compare-dm-settings/target-stuff", (ObjectCreationFactory)targetStuffFactory);
        d.addSetProperties("architect-project/compare-dm-settings/target-stuff");
        ProfileManagerFactory profileManagerFactory = new ProfileManagerFactory();
        d.addFactoryCreate("*/profiles", (ObjectCreationFactory)profileManagerFactory);
        d.addSetProperties("*/profiles");
        ProfileResultFactory profileResultFactory = new ProfileResultFactory();
        d.addFactoryCreate("*/profiles/profile-result", (ObjectCreationFactory)profileResultFactory);
        d.addSetProperties("*/profiles/profile-result");
        d.addSetNext("*/profiles/profile-result", "loadResult");
        ProfileResultValueFactory profileResultValueFactory = new ProfileResultValueFactory();
        d.addFactoryCreate("*/profiles/profile-result/avgValue", (ObjectCreationFactory)profileResultValueFactory);
        d.addSetNext("*/profiles/profile-result/avgValue", "setAvgValue");
        d.addFactoryCreate("*/profiles/profile-result/minValue", (ObjectCreationFactory)profileResultValueFactory);
        d.addSetNext("*/profiles/profile-result/minValue", "setMinValue");
        d.addFactoryCreate("*/profiles/profile-result/maxValue", (ObjectCreationFactory)profileResultValueFactory);
        d.addSetNext("*/profiles/profile-result/maxValue", "setMaxValue");
        ProfileResultTopNValueFactory topNValueFactory = new ProfileResultTopNValueFactory();
        d.addFactoryCreate("*/profiles/profile-result/topNvalue", (ObjectCreationFactory)topNValueFactory);
        d.addSetNext("*/profiles/profile-result/topNvalue", "addValueCount");
        FileFactory fileFactory = new FileFactory();
        d.addFactoryCreate("*/file", (ObjectCreationFactory)fileFactory);
        d.addSetNext("*/file", "setFile");
        d.addSetNext("architect-project/ddl-generator", "setDDLGenerator");
        return d;
    }

    public void save(ProgressMonitor pm) throws IOException, ArchitectException {
        if (this.file.exists() && !this.file.canWrite()) {
            throw new ArchitectException("problem saving project -- cannot write to architect file: " + this.file.getAbsolutePath());
        }
        File backupFile = new File(this.file.getParent(), this.file.getName() + "~");
        File tempFile = null;
        tempFile = new File(this.file.getParent(), "tmp___" + this.file.getName());
        String encoding = "UTF-8";
        try {
            this.out = new PrintWriter(tempFile, encoding);
        }
        catch (IOException e) {
            throw new ArchitectException("Unable to create output file for save operation, data NOT saved.\n" + e, e);
        }
        this.progress = 0;
        this.pm = pm;
        if (pm != null) {
            int pmMax = 0;
            pm.setMinimum(0);
            pmMax = this.savingEntireSource ? ArchitectUtils.countTablesSnapshot((SQLObject)this.sourceDatabases.getModel().getRoot()) : ArchitectUtils.countTables((SQLObject)this.sourceDatabases.getModel().getRoot());
            logger.error((Object)("Setting progress monitor maximum to " + pmMax));
            pm.setMaximum(pmMax);
            pm.setProgress(this.progress);
            pm.setMillisToDecideToPopup(0);
        }
        this.save(this.out, encoding);
        this.out = null;
        if (pm != null) {
            pm.close();
        }
        pm = null;
        boolean fstatus = false;
        fstatus = backupFile.delete();
        logger.debug((Object)("deleting backup~ file: " + fstatus));
        if (this.file.exists()) {
            fstatus = this.file.renameTo(backupFile);
            logger.debug((Object)("rename current file to backupFile: " + fstatus));
            if (!fstatus) {
                throw new ArchitectException("Could not rename current file to backup\nProject saved in " + tempFile + ": " + this.file + " still contains old project");
            }
        }
        if (!(fstatus = tempFile.renameTo(this.file))) {
            throw new ArchitectException("Could not rename temp file to current\nProject saved in " + tempFile + ": " + this.file + " still contains old project");
        }
        logger.debug((Object)("rename tempFile to current file: " + fstatus));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(PrintWriter out, String encoding) throws IOException, ArchitectException {
        this.objectIdMap = new HashMap();
        this.dbcsIdMap = new HashMap();
        this.ioo.indent = 0;
        try {
            this.ioo.println(out, "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
            this.ioo.println(out, "<architect-project version=\"1.0\" appversion=\"1.0.0\">");
            ++this.ioo.indent;
            this.ioo.println(out, "<project-name>" + ArchitectUtils.escapeXML(this.name) + "</project-name>");
            this.saveDataSources(out);
            this.saveSourceDatabases(out);
            this.saveTargetDatabase(out);
            this.saveDDLGenerator(out);
            this.saveCompareDMSettings(out);
            this.savePlayPen(out);
            this.saveProfiles(out);
            --this.ioo.indent;
            this.ioo.println(out, "</architect-project>");
            this.setModified(false);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void save(OutputStreamWriter out, String encoding) throws IOException, ArchitectException {
        this.save(new PrintWriter(out), encoding);
    }

    private void saveDataSources(PrintWriter out) throws IOException, ArchitectException {
        this.ioo.println(out, "<project-data-sources>");
        ++this.ioo.indent;
        int dsNum = 0;
        SQLObject dbTreeRoot = (SQLObject)this.sourceDatabases.getModel().getRoot();
        for (SQLObject o : dbTreeRoot.getChildren()) {
            ArchitectDataSource ds = ((SQLDatabase)o).getDataSource();
            if (ds != null) {
                String id = (String)this.dbcsIdMap.get(ds);
                if (id == null) {
                    id = "DS" + dsNum;
                    this.dbcsIdMap.put(ds, id);
                }
                this.ioo.println(out, "<data-source id=\"" + ArchitectUtils.escapeXML(id) + "\">");
                ++this.ioo.indent;
                for (Map.Entry<String, String> ent : ds.getPropertiesMap().entrySet()) {
                    if (ent.getValue() == null) continue;
                    this.ioo.println(out, "<property key=" + this.quote(ent.getKey()) + " value=" + this.quote(ent.getValue()) + " />");
                }
                --this.ioo.indent;
                this.ioo.println(out, "</data-source>");
                ++dsNum;
            }
            ++dsNum;
        }
        --this.ioo.indent;
        this.ioo.println(out, "</project-data-sources>");
    }

    private void saveDDLGenerator(PrintWriter out) throws IOException {
        this.ioo.print(out, "<ddl-generator type=\"" + this.ddlGenerator.getClass().getName() + "\"" + " allow-connection=\"" + this.ddlGenerator.getAllowConnection() + "\"");
        if (this.ddlGenerator.getTargetCatalog() != null) {
            this.ioo.niprint(out, " target-catalog=\"" + ArchitectUtils.escapeXML(this.ddlGenerator.getTargetCatalog()) + "\"");
        }
        if (this.ddlGenerator.getTargetSchema() != null) {
            this.ioo.niprint(out, " target-schema=\"" + ArchitectUtils.escapeXML(this.ddlGenerator.getTargetSchema()) + "\"");
        }
        this.ioo.niprint(out, ">");
        ++this.ioo.indent;
        if (this.ddlGenerator.getFile() != null) {
            this.ioo.println(out, "<file path=\"" + ArchitectUtils.escapeXML(this.ddlGenerator.getFile().getPath()) + "\" />");
        }
        --this.ioo.indent;
        this.ioo.println(out, "</ddl-generator>");
    }

    private void saveCompareDMSettings(PrintWriter out) throws IOException {
        if (!this.compareDMSettings.getSaveFlag()) {
            return;
        }
        this.ioo.print(out, "<compare-dm-settings");
        this.ioo.print(out, " sqlScriptFormat=\"" + ArchitectUtils.escapeXML(this.compareDMSettings.getSqlScriptFormat()) + "\"");
        this.ioo.print(out, " outputFormatAsString=\"" + ArchitectUtils.escapeXML(this.compareDMSettings.getOutputFormatAsString()) + "\"");
        this.ioo.println(out, ">");
        ++this.ioo.indent;
        this.ioo.print(out, "<source-stuff");
        this.saveSourceOrTargetAttributes(out, this.compareDMSettings.getSourceSettings());
        this.ioo.print(out, "/>");
        this.ioo.print(out, "<target-stuff");
        this.saveSourceOrTargetAttributes(out, this.compareDMSettings.getTargetSettings());
        this.ioo.print(out, "/>");
        --this.ioo.indent;
        this.ioo.println(out, "</compare-dm-settings>");
    }

    private void saveSourceOrTargetAttributes(PrintWriter out, CompareDMSettings.SourceOrTargetSettings sourceSettings) {
        this.ioo.print(out, " datastoreTypeAsString=\"" + ArchitectUtils.escapeXML(sourceSettings.getDatastoreTypeAsString()) + "\"");
        if (sourceSettings.getConnectName() != null) {
            this.ioo.print(out, " connectName=\"" + ArchitectUtils.escapeXML(sourceSettings.getConnectName()) + "\"");
        }
        if (sourceSettings.getCatalog() != null) {
            this.ioo.print(out, " catalog=\"" + ArchitectUtils.escapeXML(sourceSettings.getCatalog()) + "\"");
        }
        if (sourceSettings.getSchema() != null) {
            this.ioo.print(out, " schema=\"" + ArchitectUtils.escapeXML(sourceSettings.getSchema()) + "\"");
        }
        this.ioo.print(out, " filePath=\"" + ArchitectUtils.escapeXML(sourceSettings.getFilePath()) + "\"");
    }

    private void saveSourceDatabases(PrintWriter out) throws IOException, ArchitectException {
        this.ioo.println(out, "<source-databases>");
        ++this.ioo.indent;
        SQLObject dbTreeRoot = (SQLObject)this.sourceDatabases.getModel().getRoot();
        for (SQLObject o : dbTreeRoot.getChildren()) {
            if (o == this.playPen.getDatabase()) continue;
            this.saveSQLObject(out, o);
        }
        --this.ioo.indent;
        this.ioo.println(out, "</source-databases>");
    }

    private void saveRelationships(PrintWriter out, SQLDatabase db) throws ArchitectException, IOException {
        this.ioo.println(out, "<relationships>");
        ++this.ioo.indent;
        Iterator it = db.getChildren().iterator();
        while (it.hasNext()) {
            this.saveRelationshipsRecurse(out, (SQLObject)it.next());
        }
        --this.ioo.indent;
        this.ioo.println(out, "</relationships>");
    }

    private void saveRelationshipsRecurse(PrintWriter out, SQLObject o) throws ArchitectException, IOException {
        if (!this.savingEntireSource && !o.isPopulated()) {
            return;
        }
        if (o instanceof SQLRelationship) {
            this.saveSQLObject(out, o);
        } else if (o.allowsChildren()) {
            Iterator it = o.getChildren().iterator();
            while (it.hasNext()) {
                this.saveRelationshipsRecurse(out, (SQLObject)it.next());
            }
        }
    }

    private void saveTargetDatabase(PrintWriter out) throws IOException, ArchitectException {
        SQLDatabase db = this.playPen.getDatabase();
        this.ioo.println(out, "<target-database dbcs-ref=" + this.quote(this.dbcsIdMap.get(db.getDataSource()).toString()) + ">");
        ++this.ioo.indent;
        Iterator it = db.getChildren().iterator();
        while (it.hasNext()) {
            this.saveSQLObject(out, (SQLObject)it.next());
        }
        this.saveRelationships(out, db);
        --this.ioo.indent;
        this.ioo.println(out, "</target-database>");
    }

    private void savePlayPen(PrintWriter out) throws IOException, ArchitectException {
        this.ioo.println(out, "<play-pen>");
        ++this.ioo.indent;
        for (int i = this.playPen.getTablePanes().size() - 1; i >= 0; --i) {
            TablePane tp = this.playPen.getTablePanes().get(i);
            Point p = tp.getLocation();
            this.ioo.println(out, "<table-pane table-ref=" + this.quote(this.objectIdMap.get(tp.getModel()).toString()) + "" + " x=\"" + p.x + "\" y=\"" + p.y + "\" />");
            if (this.pm == null) continue;
            this.pm.setProgress(++this.progress);
            this.pm.setNote(tp.getModel().getShortDisplayName());
        }
        for (Relationship r : this.playPen.getRelationships()) {
            this.ioo.println(out, "<table-link relationship-ref=" + this.quote(this.objectIdMap.get(r.getModel()).toString()) + " pk-x=\"" + r.getPkConnectionPoint().x + "\"" + " pk-y=\"" + r.getPkConnectionPoint().y + "\"" + " fk-x=\"" + r.getFkConnectionPoint().x + "\"" + " fk-y=\"" + r.getFkConnectionPoint().y + "\" />");
        }
        --this.ioo.indent;
        this.ioo.println(out, "</play-pen>");
    }

    private void saveProfiles(PrintWriter out) {
        if (!(this.getProfileManager() instanceof TableProfileManager)) {
            throw new ArchitectRuntimeException(new ArchitectException("Session.getProfileManager should be a TableProfileManager"));
        }
        TableProfileManager profmgr = (TableProfileManager)this.getProfileManager();
        this.ioo.println(out, "<profiles topNCount=\"" + profmgr.getProfileSettings().getTopNCount() + "\">");
        ++this.ioo.indent;
        List<TableProfileResult> tableResults = profmgr.getTableResults();
        for (TableProfileResult tableResult : tableResults) {
            this.printCommonItems(tableResult);
            this.ioo.print(out, " rowCount=\"" + tableResult.getRowCount() + "\"");
            this.ioo.niprintln(out, "/>");
            List<ColumnProfileResult> columnProfileResults = tableResult.getColumnProfileResults();
            for (ColumnProfileResult cpr : columnProfileResults) {
                List<ColumnValueCount> valueCount;
                this.printCommonItems(cpr);
                this.ioo.niprint(out, " avgLength=\"" + cpr.getAvgLength() + "\"");
                this.ioo.niprint(out, " minLength=\"" + cpr.getMinLength() + "\"");
                this.ioo.niprint(out, " maxLength=\"" + cpr.getMaxLength() + "\"");
                this.ioo.niprint(out, " nullCount=\"" + cpr.getNullCount() + "\"");
                this.ioo.niprint(out, " distinctValueCount=\"" + cpr.getDistinctValueCount() + "\"");
                this.ioo.niprintln(out, ">");
                ++this.ioo.indent;
                if (cpr.getAvgValue() != null) {
                    this.ioo.println(out, "<avgValue type=\"" + cpr.getAvgValue().getClass().getName() + "\" value=\"" + ArchitectUtils.escapeXML(String.valueOf(cpr.getAvgValue())) + "\"/>");
                }
                if (cpr.getMaxValue() != null) {
                    this.ioo.println(out, "<maxValue type=\"" + cpr.getMaxValue().getClass().getName() + "\" value=\"" + ArchitectUtils.escapeXML(String.valueOf(cpr.getMaxValue())) + "\"/>");
                }
                if (cpr.getMinValue() != null) {
                    this.ioo.println(out, "<minValue type=\"" + cpr.getMinValue().getClass().getName() + "\" value=\"" + ArchitectUtils.escapeXML(String.valueOf(cpr.getMinValue())) + "\"/>");
                }
                if ((valueCount = cpr.getValueCount()) != null) {
                    for (ColumnValueCount count : valueCount) {
                        this.ioo.println(out, "<topNvalue count=\"" + count.getCount() + "\" type=\"" + (count.getValue() == null ? "" : count.getValue().getClass().getName()) + "\" value=\"" + ArchitectUtils.escapeXML(String.valueOf(count.getValue())) + "\"/>");
                    }
                }
                --this.ioo.indent;
                this.ioo.println(out, "</profile-result>");
            }
        }
        this.ioo.println(out, "</profiles>");
        --this.ioo.indent;
    }

    private void printCommonItems(ProfileResult profileResult) {
        Object profiledObject = profileResult.getProfiledObject();
        this.ioo.print(this.out, "<profile-result ref-id=\"" + this.objectIdMap.get(profiledObject) + "\"" + " type=\"" + profileResult.getClass().getName() + "\"" + " createStartTime=\"" + profileResult.getCreateStartTime() + "\"" + " createEndTime=\"" + profileResult.getCreateEndTime() + "\"" + " exception=\"" + (profileResult.getException() == null ? "false" : "true") + "\"");
        if (profileResult.getException() != null) {
            this.ioo.niprint(this.out, " exception-type=\"" + ArchitectUtils.escapeXML(profileResult.getException().getClass().getName()) + "\"");
            this.ioo.niprint(this.out, " exception-message=\"" + ArchitectUtils.escapeXML(profileResult.getException().getMessage()) + "\"");
        }
    }

    private void saveSQLObject(PrintWriter out, SQLObject o) throws IOException, ArchitectException {
        String type;
        String id = (String)this.objectIdMap.get(o);
        if (id != null) {
            this.ioo.println(out, "<reference ref-id=\"" + ArchitectUtils.escapeXML(id) + "\" />");
            return;
        }
        TreeMap<String, Object> propNames = new TreeMap<String, Object>();
        propNames.put("physicalName", o.getPhysicalName());
        propNames.put("name", o.getName());
        if (o instanceof SQLDatabase) {
            id = "DB" + this.objectIdMap.size();
            type = "database";
            propNames.put("dbcs-ref", this.dbcsIdMap.get(((SQLDatabase)o).getDataSource()));
        } else if (o instanceof SQLCatalog) {
            id = "CAT" + this.objectIdMap.size();
            type = "catalog";
            propNames.put("nativeTerm", ((SQLCatalog)o).getNativeTerm());
        } else if (o instanceof SQLSchema) {
            id = "SCH" + this.objectIdMap.size();
            type = "schema";
            propNames.put("nativeTerm", ((SQLSchema)o).getNativeTerm());
        } else if (o instanceof SQLTable) {
            id = "TAB" + this.objectIdMap.size();
            type = "table";
            propNames.put("remarks", ((SQLTable)o).getRemarks());
            propNames.put("objectType", ((SQLTable)o).getObjectType());
            propNames.put("primaryKeyName", ((SQLTable)o).getPrimaryKeyName());
            propNames.put("physicalPrimaryKeyName", ((SQLTable)o).getPhysicalPrimaryKeyName());
            if (this.pm != null) {
                this.pm.setProgress(++this.progress);
                this.pm.setNote(o.getShortDisplayName());
            }
        } else if (o instanceof SQLTable.Folder) {
            id = "FOL" + this.objectIdMap.size();
            type = "folder";
            propNames.put("type", new Integer(((SQLTable.Folder)o).getType()));
        } else if (o instanceof SQLColumn) {
            id = "COL" + this.objectIdMap.size();
            type = "column";
            SQLColumn sourceCol = ((SQLColumn)o).getSourceColumn();
            if (sourceCol != null) {
                propNames.put("source-column-ref", this.objectIdMap.get(sourceCol));
            }
            propNames.put("type", new Integer(((SQLColumn)o).getType()));
            propNames.put("sourceDataTypeName", ((SQLColumn)o).getSourceDataTypeName());
            propNames.put("scale", new Integer(((SQLColumn)o).getScale()));
            propNames.put("precision", new Integer(((SQLColumn)o).getPrecision()));
            propNames.put("nullable", new Integer(((SQLColumn)o).getNullable()));
            propNames.put("remarks", ((SQLColumn)o).getRemarks());
            propNames.put("defaultValue", ((SQLColumn)o).getDefaultValue());
            propNames.put("primaryKeySeq", ((SQLColumn)o).getPrimaryKeySeq());
            propNames.put("autoIncrement", new Boolean(((SQLColumn)o).isAutoIncrement()));
            propNames.put("referenceCount", new Integer(((SQLColumn)o).getReferenceCount()));
        } else if (o instanceof SQLRelationship) {
            id = "REL" + this.objectIdMap.size();
            type = "relationship";
            propNames.put("pk-table-ref", this.objectIdMap.get(((SQLRelationship)o).getPkTable()));
            propNames.put("fk-table-ref", this.objectIdMap.get(((SQLRelationship)o).getFkTable()));
            propNames.put("updateRule", new Integer(((SQLRelationship)o).getUpdateRule()));
            propNames.put("deleteRule", new Integer(((SQLRelationship)o).getDeleteRule()));
            propNames.put("deferrability", new Integer(((SQLRelationship)o).getDeferrability()));
            propNames.put("pkCardinality", new Integer(((SQLRelationship)o).getPkCardinality()));
            propNames.put("fkCardinality", new Integer(((SQLRelationship)o).getFkCardinality()));
            propNames.put("identifying", new Boolean(((SQLRelationship)o).isIdentifying()));
        } else if (o instanceof SQLRelationship.ColumnMapping) {
            id = "CMP" + this.objectIdMap.size();
            type = "column-mapping";
            propNames.put("pk-column-ref", this.objectIdMap.get(((SQLRelationship.ColumnMapping)o).getPkColumn()));
            propNames.put("fk-column-ref", this.objectIdMap.get(((SQLRelationship.ColumnMapping)o).getFkColumn()));
        } else if (o instanceof SQLExceptionNode) {
            id = "EXC" + this.objectIdMap.size();
            type = "sql-exception";
            propNames.put("message", ((SQLExceptionNode)o).getMessage());
        } else if (o instanceof SQLIndex) {
            id = "IDX" + this.objectIdMap.size();
            type = "index";
            SQLIndex index = (SQLIndex)o;
            propNames.put("unique", index.isUnique());
            propNames.put("qualifier", index.getQualifier());
            propNames.put("index-type", index.getType().name());
            propNames.put("primaryKeyIndex", index.isPrimaryKeyIndex());
            propNames.put("filterCondition", index.getFilterCondition());
        } else if (o instanceof SQLIndex.Column) {
            id = "IDC" + this.objectIdMap.size();
            type = "index-column";
            SQLIndex.Column col = (SQLIndex.Column)o;
            if (col.getColumn() != null) {
                propNames.put("column-ref", this.objectIdMap.get(col.getColumn()));
            }
            propNames.put("ascending", col.isAscending());
            propNames.put("descending", col.isDescending());
        } else {
            throw new UnsupportedOperationException("Whoops, the SQLObject type " + o.getClass().getName() + " is not supported!");
        }
        this.objectIdMap.put(o, id);
        boolean skipChildren = false;
        this.ioo.print(out, "<" + type + " id=" + this.quote(id) + " ");
        if (o.allowsChildren() && o.isPopulated() && o.getChildCount() == 1 && o.getChild(0) instanceof SQLExceptionNode) {
            this.ioo.niprint(out, "populated=\"false\" ");
            skipChildren = true;
        } else if (!this.savingEntireSource && !o.isPopulated()) {
            this.ioo.niprint(out, "populated=\"false\" ");
        } else {
            this.ioo.niprint(out, "populated=\"true\" ");
        }
        for (Object key : propNames.keySet()) {
            Object value = propNames.get(key);
            if (value == null) continue;
            this.ioo.niprint(out, key + "=" + this.quote(value.toString()) + " ");
        }
        if (!skipChildren && o.allowsChildren() && (this.savingEntireSource || o.isPopulated())) {
            this.ioo.niprintln(out, ">");
            Iterator children = o.getChildren().iterator();
            ++this.ioo.indent;
            while (children.hasNext()) {
                SQLObject child = (SQLObject)children.next();
                if (child instanceof SQLRelationship) continue;
                this.saveSQLObject(out, child);
            }
            if (o instanceof SQLDatabase) {
                this.saveRelationships(out, (SQLDatabase)o);
            }
            --this.ioo.indent;
            this.ioo.println(out, "</" + type + ">");
        } else {
            this.ioo.niprintln(out, "/>");
        }
    }

    private String quote(String str) {
        return "\"" + ArchitectUtils.escapeXML(str) + "\"";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String argName) {
        this.name = argName;
    }

    public DBTree getSourceDatabases() {
        return this.sourceDatabases;
    }

    public void setSourceDatabases(DBTree argSourceDatabases) {
        this.sourceDatabases = argSourceDatabases;
    }

    public void setSourceDatabaseList(List databases) throws ArchitectException {
        this.sourceDatabases.setModel(new DBTreeModel(databases, this.session));
    }

    public SQLDatabase getTargetDatabase() {
        return this.playPen.getDatabase();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File argFile) {
        this.file = argFile;
    }

    public PlayPen getPlayPen() {
        return this.playPen;
    }

    public void addAllTablesFrom(SQLDatabase db) throws ArchitectException {
        SQLDatabase ppdb = this.playPen.getDatabase();
        for (SQLObject table : db.getChildren()) {
            ppdb.addChild(table);
        }
    }

    public void setPlayPen(PlayPen argPlayPen) {
        this.playPen = argPlayPen;
        UserSettings sprefs = ArchitectFrame.getMainInstance().getSprefs();
        if (sprefs != null) {
            this.playPen.setRenderingAntialiased(sprefs.getBoolean("SwingUserSettings.PLAYPEN_RENDER_ANTIALIASED", false));
        }
        new ProjectModificationWatcher(this.playPen);
    }

    public GenericDDLGenerator getDDLGenerator() {
        return this.ddlGenerator;
    }

    public void setDDLGenerator(GenericDDLGenerator generator) {
        this.ddlGenerator = generator;
    }

    public CompareDMSettings getCompareDMSettings() {
        return this.compareDMSettings;
    }

    public void setCompareDMSettings(CompareDMSettings compareDMSettings) {
        this.compareDMSettings = compareDMSettings;
    }

    public boolean isSavingEntireSource() {
        return this.savingEntireSource;
    }

    public void setSavingEntireSource(boolean argSavingEntireSource) {
        this.savingEntireSource = argSavingEntireSource;
    }

    public PLExport getPLExport() {
        return this.plExport;
    }

    public void setPLExport(PLExport v) {
        this.plExport = v;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Project modified: " + modified));
        }
        this.modified = modified;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public ProfileManager getProfileManager() {
        return this.session.getProfileManager();
    }

    public JDialog getProfileDialog() {
        this.profileDialog.pack();
        return this.profileDialog;
    }

    private class ProjectModificationWatcher
    implements SQLObjectListener,
    PlayPenComponentListener {
        public ProjectModificationWatcher(PlayPen pp) {
            try {
                ArchitectUtils.listenToHierarchy((SQLObjectListener)this, pp.getDatabase());
            }
            catch (ArchitectException e) {
                logger.error((Object)"Can't listen to business model for changes", (Throwable)e);
            }
            PlayPenContentPane ppcp = pp.contentPane;
            ppcp.addPlayPenComponentListener(this);
        }

        public void dbChildrenInserted(SQLObjectEvent e) {
            SwingUIProject.this.setModified(true);
            SQLObject[] newKids = e.getChildren();
            for (int i = 0; i < newKids.length; ++i) {
                try {
                    ArchitectUtils.listenToHierarchy((SQLObjectListener)this, newKids[i]);
                    continue;
                }
                catch (ArchitectException e1) {
                    logger.error((Object)("Couldn't listen to SQLObject hierarchy rooted at " + newKids[i]), (Throwable)e1);
                }
            }
        }

        public void dbChildrenRemoved(SQLObjectEvent e) {
            SwingUIProject.this.setModified(true);
            SQLObject[] oldKids = e.getChildren();
            for (int i = 0; i < oldKids.length; ++i) {
                oldKids[i].removeSQLObjectListener(this);
            }
        }

        public void dbObjectChanged(SQLObjectEvent e) {
            SwingUIProject.this.setModified(true);
        }

        public void dbStructureChanged(SQLObjectEvent e) {
            try {
                ArchitectUtils.listenToHierarchy((SQLObjectListener)this, e.getSQLSource());
            }
            catch (ArchitectException e1) {
                logger.error((Object)"dbStructureChanged listener: Failed to listen to new project hierarchy", (Throwable)e1);
            }
        }

        public void componentMoved(PlayPenComponentEvent e) {
        }

        public void componentResized(PlayPenComponentEvent e) {
            SwingUIProject.this.setModified(true);
        }

        public void componentMoveStart(PlayPenComponentEvent e) {
            SwingUIProject.this.setModified(true);
        }

        public void componentMoveEnd(PlayPenComponentEvent e) {
            SwingUIProject.this.setModified(true);
        }
    }

    private class ProfileResultTopNValueFactory
    extends AbstractObjectCreationFactory {
        private ProfileResultTopNValueFactory() {
        }

        public Object createObject(Attributes attributes) throws ArchitectException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            String className = attributes.getValue("type");
            int count = Integer.valueOf(attributes.getValue("count"));
            String value = attributes.getValue("value");
            if (className == null || className.length() == 0) {
                return new ColumnValueCount(null, count);
            }
            if (className.equals(BigDecimal.class.getName())) {
                return new ColumnValueCount(new BigDecimal(value), count);
            }
            if (className.equals(Timestamp.class.getName())) {
                return new ColumnValueCount(new Timestamp(Timestamp.valueOf(value).getTime()), count);
            }
            if (className.equals(String.class.getName())) {
                return new ColumnValueCount(new String(value), count);
            }
            return new ColumnValueCount(new String(value), count);
        }
    }

    private class ProfileResultValueFactory
    extends AbstractObjectCreationFactory {
        private ProfileResultValueFactory() {
        }

        public Object createObject(Attributes attributes) throws ArchitectException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            String className = attributes.getValue("type");
            if (className == null) {
                throw new ArchitectException("Missing mandatory attribute \"type\" in <avgValue> or <minValue> or <maxValue> element");
            }
            if (className.equals(BigDecimal.class.getName())) {
                return new BigDecimal(attributes.getValue("value"));
            }
            if (className.equals(Timestamp.class.getName())) {
                return new Timestamp(Timestamp.valueOf(attributes.getValue("value")).getTime());
            }
            if (className.equals(String.class.getName())) {
                return new String(attributes.getValue("value"));
            }
            return new String(attributes.getValue("value"));
        }
    }

    private class ProfileResultFactory
    extends AbstractObjectCreationFactory {
        TableProfileResult tableProfileResult;

        private ProfileResultFactory() {
        }

        public Object createObject(Attributes attributes) throws ArchitectException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            String refid = attributes.getValue("ref-id");
            String className = attributes.getValue("type");
            if (refid == null) {
                throw new ArchitectException("Missing mandatory attribute \"ref-id\" in <profile-result> element");
            }
            if (className == null) {
                throw new ArchitectException("Missing mandatory attribute \"type\" in <profile-result> element");
            }
            if (className.equals(TableProfileResult.class.getName())) {
                SQLTable t = (SQLTable)SwingUIProject.this.objectIdMap.get(refid);
                this.tableProfileResult = new TableProfileResult(t, SwingUIProject.this.session.getProfileManager());
                this.tableProfileResult.finish(this.tableProfileResult.getCreateEndTime());
                return this.tableProfileResult;
            }
            if (className.equals(ColumnProfileResult.class.getName())) {
                SQLColumn c = (SQLColumn)SwingUIProject.this.objectIdMap.get(refid);
                if (this.tableProfileResult == null) {
                    throw new IllegalArgumentException("Column result does not have a parent");
                }
                return new ColumnProfileResult(c, this.tableProfileResult);
            }
            throw new ArchitectException("Profile result type \"" + className + "\" not recognised");
        }
    }

    private class ProfileManagerFactory
    extends AbstractObjectCreationFactory {
        private ProfileManagerFactory() {
        }

        public Object createObject(Attributes attributes) throws ArchitectException {
            return SwingUIProject.this.session.getProfileManager();
        }
    }

    private class CompareDMStuffSettingFactory
    extends AbstractObjectCreationFactory {
        private boolean source;

        public CompareDMStuffSettingFactory(boolean source) {
            this.source = source;
        }

        public Object createObject(Attributes attributes) {
            if (this.source) {
                return SwingUIProject.this.getCompareDMSettings().getSourceSettings();
            }
            return SwingUIProject.this.getCompareDMSettings().getTargetSettings();
        }
    }

    private class CompareDMSettingFactory
    extends AbstractObjectCreationFactory {
        private CompareDMSettingFactory() {
        }

        public Object createObject(Attributes attributes) {
            return SwingUIProject.this.getCompareDMSettings();
        }
    }

    private class FileFactory
    extends AbstractObjectCreationFactory {
        private FileFactory() {
        }

        public Object createObject(Attributes attributes) {
            return new File(attributes.getValue("path"));
        }
    }

    private class DDLGeneratorFactory
    extends AbstractObjectCreationFactory {
        private DDLGeneratorFactory() {
        }

        public Object createObject(Attributes attributes) throws SQLException {
            try {
                GenericDDLGenerator ddlg = (GenericDDLGenerator)Class.forName(attributes.getValue("type")).newInstance();
                ddlg.setTargetCatalog(attributes.getValue("target-catalog"));
                ddlg.setTargetSchema(attributes.getValue("target-schema"));
                return ddlg;
            }
            catch (Exception e) {
                logger.debug((Object)"Couldn't create DDL Generator instance. Returning generic instance.", (Throwable)e);
                return new GenericDDLGenerator();
            }
        }
    }

    private class PPRelationshipFactory
    extends AbstractObjectCreationFactory {
        private PPRelationshipFactory() {
        }

        public Object createObject(Attributes attributes) {
            Relationship r = null;
            try {
                SQLRelationship rel = (SQLRelationship)SwingUIProject.this.objectIdMap.get(attributes.getValue("relationship-ref"));
                r = new Relationship(SwingUIProject.this.playPen, rel);
                SwingUIProject.this.playPen.addRelationship(r);
                int pkx = Integer.parseInt(attributes.getValue("pk-x"));
                int pky = Integer.parseInt(attributes.getValue("pk-y"));
                int fkx = Integer.parseInt(attributes.getValue("fk-x"));
                int fky = Integer.parseInt(attributes.getValue("fk-y"));
                r.setPkConnectionPoint(new Point(pkx, pky));
                r.setFkConnectionPoint(new Point(fkx, fky));
            }
            catch (ArchitectException e) {
                logger.error((Object)"Couldn't create relationship component", (Throwable)e);
            }
            catch (NumberFormatException e) {
                logger.warn((Object)"Didn't set connection points because of integer parse error");
            }
            catch (NullPointerException e) {
                logger.debug((Object)"No pk/fk connection points specified in save file; not setting custom connection points");
            }
            return r;
        }
    }

    private class TablePaneFactory
    extends AbstractObjectCreationFactory {
        private TablePaneFactory() {
        }

        public Object createObject(Attributes attributes) {
            int x = Integer.parseInt(attributes.getValue("x"));
            int y = Integer.parseInt(attributes.getValue("y"));
            SQLTable tab = (SQLTable)SwingUIProject.this.objectIdMap.get(attributes.getValue("table-ref"));
            TablePane tp = new TablePane(tab, SwingUIProject.this.playPen);
            SwingUIProject.this.playPen.addTablePane(tp, new Point(x, y));
            return tp;
        }
    }

    private class SQLIndexColumnFactory
    extends AbstractObjectCreationFactory {
        private SQLIndexColumnFactory() {
        }

        public Object createObject(Attributes attributes) {
            SQLIndex.Column col = SwingUIProject.this.currentIndex.new SQLIndex.Column();
            String id = attributes.getValue("id");
            if (id != null) {
                SwingUIProject.this.objectIdMap.put(id, col);
            } else {
                logger.warn((Object)"No ID found in index-column element while loading project!");
            }
            String referencedColId = attributes.getValue("column-ref");
            if (referencedColId != null) {
                SQLColumn column = (SQLColumn)SwingUIProject.this.objectIdMap.get(referencedColId);
                col.setColumn(column);
            }
            return col;
        }
    }

    private class SQLIndexFactory
    extends AbstractObjectCreationFactory {
        private SQLIndexFactory() {
        }

        public Object createObject(Attributes attributes) {
            SQLIndex index = new SQLIndex();
            logger.debug((Object)("Loading index: " + attributes.getValue("name")));
            String id = attributes.getValue("id");
            if (id != null) {
                SwingUIProject.this.objectIdMap.put(id, index);
            } else {
                logger.warn((Object)"No ID found in index element while loading project!");
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                logger.debug((Object)("Attribute: \"" + attributes.getQName(i) + "\" Value:" + attributes.getValue(i)));
            }
            index.setType(SQLIndex.IndexType.valueOf(attributes.getValue("index-type")));
            SwingUIProject.this.currentIndex = index;
            return index;
        }
    }

    private class ColumnMappingFactory
    extends AbstractObjectCreationFactory {
        private ColumnMappingFactory() {
        }

        public Object createObject(Attributes attributes) {
            String pkColumnId;
            SQLRelationship.ColumnMapping cmap = new SQLRelationship.ColumnMapping();
            String id = attributes.getValue("id");
            if (id != null) {
                SwingUIProject.this.objectIdMap.put(id, cmap);
            } else {
                logger.warn((Object)"No ID found in column-mapping element while loading project!");
            }
            String fkColumnId = attributes.getValue("fk-column-ref");
            if (fkColumnId != null) {
                cmap.setFkColumn((SQLColumn)SwingUIProject.this.objectIdMap.get(fkColumnId));
            }
            if ((pkColumnId = attributes.getValue("pk-column-ref")) != null) {
                cmap.setPkColumn((SQLColumn)SwingUIProject.this.objectIdMap.get(pkColumnId));
            }
            return cmap;
        }
    }

    private class SQLRelationshipFactory
    extends AbstractObjectCreationFactory {
        private SQLRelationshipFactory() {
        }

        public Object createObject(Attributes attributes) {
            SQLRelationship rel = new SQLRelationship();
            String id = attributes.getValue("id");
            if (id != null) {
                SwingUIProject.this.objectIdMap.put(id, rel);
            } else {
                logger.warn((Object)"No ID found in relationship element while loading project!");
            }
            String fkTableId = attributes.getValue("fk-table-ref");
            String pkTableId = attributes.getValue("pk-table-ref");
            if (fkTableId != null && pkTableId != null) {
                SQLTable fkTable = (SQLTable)SwingUIProject.this.objectIdMap.get(fkTableId);
                SQLTable pkTable = (SQLTable)SwingUIProject.this.objectIdMap.get(pkTableId);
                try {
                    rel.attachRelationship(pkTable, fkTable, false);
                }
                catch (ArchitectException e) {
                    logger.error((Object)("Couldn't attach relationship to pktable \"" + pkTable.getName() + "\" and fktable \"" + fkTable.getName() + "\""), (Throwable)e);
                    JOptionPane.showMessageDialog(null, "Failed to attach relationship to pktable \"" + pkTable.getName() + "\" and fktable \"" + fkTable.getName() + "\":\n" + e.getMessage());
                }
            } else {
                JOptionPane.showMessageDialog(null, "Missing pktable or fktable references for relationship id \"" + id + "\"");
            }
            return rel;
        }
    }

    private class SQLExceptionFactory
    extends AbstractObjectCreationFactory {
        private SQLExceptionFactory() {
        }

        public Object createObject(Attributes attributes) {
            SQLExceptionNode exc = new SQLExceptionNode(null, null);
            String id = attributes.getValue("id");
            if (id != null) {
                SwingUIProject.this.objectIdMap.put(id, exc);
            } else {
                logger.warn((Object)"No ID found in exception element while loading project!");
            }
            exc.setMessage(attributes.getValue("message"));
            return exc;
        }
    }

    private class SQLColumnFactory
    extends AbstractObjectCreationFactory {
        private SQLColumnFactory() {
        }

        public Object createObject(Attributes attributes) {
            SQLColumn col = new SQLColumn();
            String id = attributes.getValue("id");
            if (id != null) {
                SwingUIProject.this.objectIdMap.put(id, col);
            } else {
                logger.warn((Object)"No ID found in column element while loading project!");
            }
            String sourceId = attributes.getValue("source-column-ref");
            if (sourceId != null) {
                col.setSourceColumn((SQLColumn)SwingUIProject.this.objectIdMap.get(sourceId));
            }
            return col;
        }
    }

    private class SQLFolderFactory
    extends AbstractObjectCreationFactory {
        private SQLFolderFactory() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object createObject(Attributes attributes) {
            int type = -1;
            String typeStr = attributes.getValue("type");
            if (typeStr == null) {
                String name = attributes.getValue("name");
                if (name.equals("Columns")) {
                    type = 1;
                    return new SQLTable.Folder(type, true);
                } else if (name.equals("Imported Keys")) {
                    type = 2;
                    return new SQLTable.Folder(type, true);
                } else {
                    if (!name.equals("Exported Keys")) throw new IllegalStateException("Could not determine folder type from name");
                    type = 3;
                }
                return new SQLTable.Folder(type, true);
            }
            try {
                type = Integer.parseInt(typeStr);
                return new SQLTable.Folder(type, true);
            }
            catch (NumberFormatException ex) {
                throw new IllegalStateException("Could not parse folder type id \"" + typeStr + "\"");
            }
        }
    }

    private class SQLTableFactory
    extends AbstractObjectCreationFactory {
        private SQLTableFactory() {
        }

        public Object createObject(Attributes attributes) throws ArchitectException {
            SQLTable tab = new SQLTable();
            String id = attributes.getValue("id");
            String pkName = attributes.getValue("primaryKeyName");
            if (id != null) {
                SwingUIProject.this.objectIdMap.put(id, tab);
                SwingUIProject.this.objectIdMap.put(id + "." + pkName, tab);
            } else {
                logger.warn((Object)"No ID found in table element while loading project!");
            }
            String populated = attributes.getValue("populated");
            if (populated != null && populated.equals("false")) {
                try {
                    tab.initFolders(false);
                }
                catch (ArchitectException e) {
                    logger.error((Object)("Couldn't add folder to table \"" + tab.getName() + "\""), (Throwable)e);
                    JOptionPane.showMessageDialog(null, "Failed to add folder to table:\n" + e.getMessage());
                }
            }
            return tab;
        }
    }

    private class SQLSchemaFactory
    extends AbstractObjectCreationFactory {
        private SQLSchemaFactory() {
        }

        public Object createObject(Attributes attributes) {
            String populated = attributes.getValue("populated");
            boolean startPopulated = populated != null && populated.equals("true");
            SQLSchema schema = new SQLSchema(startPopulated);
            String id = attributes.getValue("id");
            if (id != null) {
                SwingUIProject.this.objectIdMap.put(id, schema);
            } else {
                logger.warn((Object)"No ID found in database element while loading project!");
            }
            return schema;
        }
    }

    private class SQLDatabaseFactory
    extends AbstractObjectCreationFactory {
        private SQLDatabaseFactory() {
        }

        public Object createObject(Attributes attributes) {
            String populated;
            SQLDatabase db = new SQLDatabase();
            String id = attributes.getValue("id");
            if (id != null) {
                SwingUIProject.this.objectIdMap.put(id, db);
            } else {
                logger.warn((Object)"No ID found in database element while loading project!");
            }
            String dbcsid = attributes.getValue("dbcs-ref");
            if (dbcsid != null) {
                db.setDataSource((ArchitectDataSource)SwingUIProject.this.dbcsIdMap.get(dbcsid));
            }
            if ((populated = attributes.getValue("populated")) != null && populated.equals("false")) {
                db.setPopulated(false);
            }
            return db;
        }
    }

    private class TargetDBFactory
    extends AbstractObjectCreationFactory {
        private TargetDBFactory() {
        }

        public Object createObject(Attributes attributes) throws Exception {
            SQLDatabase ppdb = SwingUIProject.this.playPen.getDatabase();
            String dbcsid = attributes.getValue("dbcs-ref");
            if (dbcsid != null) {
                ppdb.setDataSource((ArchitectDataSource)SwingUIProject.this.dbcsIdMap.get(dbcsid));
            }
            return ppdb;
        }
    }

    private class DBCSFactory
    extends AbstractObjectCreationFactory {
        private DBCSFactory() {
        }

        public Object createObject(Attributes attributes) {
            ArchitectDataSource dbcs = new ArchitectDataSource();
            String id = attributes.getValue("id");
            if (id != null) {
                SwingUIProject.this.dbcsIdMap.put(id, dbcs);
            } else {
                logger.info((Object)"No ID found in dbcs element while loading project! (this is normal for playpen db, but bad for other data sources!");
            }
            return dbcs;
        }
    }
}

