/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ListDataEvent;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class ScrollablePopupMenu
extends JComboBox {
    boolean keySelection = false;
    myBasicComboBoxUI myCBUI;

    public ScrollablePopupMenu(ComboBoxModel aModel) {
        super(aModel);
        this.setup();
    }

    public ScrollablePopupMenu(Object[] items) {
        super(items);
        this.setup();
    }

    public ScrollablePopupMenu(Vector items) {
        super(items);
        this.setup();
    }

    private void setup() {
        this.myCBUI = new myBasicComboBoxUI();
        this.setUI(this.myCBUI);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    ScrollablePopupMenu.this.keySelection = false;
                    ScrollablePopupMenu.this.fireActionEvent();
                    return;
                }
                if (!ScrollablePopupMenu.this.myCBUI.getPopup().isVisible()) {
                    ke.consume();
                }
                ScrollablePopupMenu.this.keySelection = true;
            }
        });
        this.setPreferredSize(new Dimension(0, 0));
        this.setVisible(true);
    }

    public void showPopup(int x, int y) {
        this.setLocation(x, y);
        this.myCBUI.getPopup().show();
    }

    public ComboPopup getPopup() {
        return this.myCBUI.getPopup();
    }

    public void setSelectedItem(Object anObject) {
        Object oldSelection = this.selectedItemReminder;
        if (oldSelection == null || !oldSelection.equals(anObject)) {
            if (anObject != null && !this.isEditable()) {
                boolean found = false;
                for (int i = 0; i < this.dataModel.getSize(); ++i) {
                    if (!anObject.equals(this.dataModel.getElementAt(i))) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return;
                }
            }
            this.dataModel.setSelectedItem(anObject);
            if (this.selectedItemReminder != this.dataModel.getSelectedItem()) {
                this.selectedItemChanged();
            }
        }
    }

    public void contentsChanged(ListDataEvent e) {
        Object oldSelection = this.selectedItemReminder;
        Object newSelection = this.dataModel.getSelectedItem();
        if (oldSelection == null || !oldSelection.equals(newSelection)) {
            this.selectedItemChanged();
        }
        if (!this.keySelection) {
            this.fireActionEvent();
        }
    }

    class myBasicComboBoxUI
    extends BasicComboBoxUI {
        myBasicComboBoxUI() {
        }

        public ComboPopup getPopup() {
            return this.popup;
        }
    }
}

