/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.diff;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.Monitorable;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.diff.ArchitectDiffException;
import ca.sqlpower.architect.diff.DiffChunk;
import ca.sqlpower.architect.diff.DiffType;
import ca.sqlpower.architect.diff.SQLObjectComparator;
import ca.sqlpower.architect.diff.SQLRelationshipComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareSQL
implements Monitorable {
    private static final Logger logger = Logger.getLogger(CompareSQL.class);
    static final Comparator<SQLObject> comparator = new SQLObjectComparator();
    private TreeSet<SQLTable> sourceTableSet;
    private TreeSet<SQLTable> targetTableSet;
    private Integer jobSize;
    private int progress;
    private boolean finished;
    List<DiffChunk<SQLObject>> results;
    private String currentTableName;

    public CompareSQL(Collection<SQLTable> sourceTables, Collection<SQLTable> targetTables) throws ArchitectDiffException {
        boolean sourceValid = true;
        boolean targetValid = true;
        this.sourceTableSet = new TreeSet<SQLObject>(comparator);
        this.sourceTableSet.addAll(sourceTables);
        this.targetTableSet = new TreeSet<SQLObject>(comparator);
        this.targetTableSet.addAll(targetTables);
        if (this.sourceTableSet.size() != sourceTables.size()) {
            sourceValid = false;
        }
        if (this.targetTableSet.size() != targetTables.size()) {
            targetValid = false;
        }
        if (!sourceValid || !targetValid) {
            String error = !sourceValid && !targetValid ? "Your source and target both have tables with duplicate names." : (!sourceValid ? "Your source has tables with the same name as each other." : "Your target has tables with the same name as each other.");
            throw new ArchitectDiffException(error);
        }
        this.results = new ArrayList<DiffChunk<SQLObject>>();
        this.setProgress(0);
        this.setJobSize(this.targetTableSet.size() * 2 + this.sourceTableSet.size() * 2);
        this.setFinished(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DiffChunk<SQLObject>> generateTableDiffs() throws ArchitectException {
        try {
            SQLTable targetTable;
            boolean targetContinue;
            SQLTable sourceTable;
            boolean sourceContinue;
            Iterator<SQLTable> sourceIter = this.sourceTableSet.iterator();
            Iterator<SQLTable> targetIter = this.targetTableSet.iterator();
            if (sourceIter.hasNext()) {
                sourceContinue = true;
                sourceTable = sourceIter.next();
            } else {
                sourceContinue = false;
                sourceTable = null;
            }
            if (targetIter.hasNext()) {
                targetContinue = true;
                targetTable = targetIter.next();
            } else {
                targetContinue = false;
                targetTable = null;
            }
            while (sourceContinue && targetContinue) {
                if (comparator.compare(sourceTable, targetTable) < 0) {
                    this.results.add(new DiffChunk<SQLTable>(sourceTable, DiffType.LEFTONLY));
                    this.incProgress(1);
                    if (sourceIter.hasNext()) {
                        sourceTable = sourceIter.next();
                    } else {
                        sourceContinue = false;
                    }
                }
                if (comparator.compare(sourceTable, targetTable) > 0) {
                    this.results.add(new DiffChunk<SQLTable>(targetTable, DiffType.RIGHTONLY));
                    this.incProgress(1);
                    if (targetIter.hasNext()) {
                        targetTable = targetIter.next();
                    } else {
                        targetContinue = false;
                    }
                }
                if (comparator.compare(sourceTable, targetTable) != 0) continue;
                this.results.add(new DiffChunk<SQLTable>(sourceTable, DiffType.SAME));
                this.incProgress(2);
                this.results.addAll(this.generateColumnDiffs(sourceTable, targetTable));
                if (!targetIter.hasNext() && !sourceIter.hasNext()) {
                    targetContinue = false;
                    sourceContinue = false;
                }
                if (targetIter.hasNext()) {
                    targetTable = targetIter.next();
                } else {
                    targetContinue = false;
                }
                if (sourceIter.hasNext()) {
                    sourceTable = sourceIter.next();
                    continue;
                }
                sourceContinue = false;
            }
            while (sourceContinue) {
                this.results.add(new DiffChunk<SQLTable>(sourceTable, DiffType.LEFTONLY));
                this.incProgress(1);
                if (sourceIter.hasNext()) {
                    sourceTable = sourceIter.next();
                    continue;
                }
                sourceContinue = false;
            }
            while (targetContinue) {
                this.results.add(new DiffChunk<SQLTable>(targetTable, DiffType.RIGHTONLY));
                this.incProgress(1);
                if (targetIter.hasNext()) {
                    targetTable = targetIter.next();
                    continue;
                }
                targetContinue = false;
            }
            this.results.addAll(this.generateRelationshipDiffs(this.sourceTableSet, this.targetTableSet));
        }
        finally {
            this.setJobSize(null);
            this.setFinished(true);
        }
        return this.results;
    }

    private List<DiffChunk<SQLObject>> generateRelationshipDiffs(Collection<SQLTable> sourceTables, Collection<SQLTable> targetTables) throws ArchitectException {
        SQLRelationship targetRel;
        boolean targetContinue;
        SQLRelationship sourceRel;
        boolean sourceContinue;
        SQLRelationshipComparator relComparator = new SQLRelationshipComparator();
        TreeSet<SQLRelationship> sourceRels = new TreeSet<SQLRelationship>(relComparator);
        TreeSet<SQLRelationship> targetRels = new TreeSet<SQLRelationship>(relComparator);
        for (SQLTable t : sourceTables) {
            this.incProgress(1);
            if (t.getImportedKeys() == null) continue;
            sourceRels.addAll(t.getImportedKeys());
        }
        for (SQLTable t : targetTables) {
            this.incProgress(1);
            if (t.getImportedKeys() == null) continue;
            targetRels.addAll(t.getImportedKeys());
        }
        logger.debug((Object)("Source relationships: " + sourceRels));
        logger.debug((Object)("Target relationships: " + targetRels));
        ArrayList<DiffChunk<SQLObject>> diffs = new ArrayList<DiffChunk<SQLObject>>();
        Iterator sourceIter = sourceRels.iterator();
        Iterator targetIter = targetRels.iterator();
        if (sourceIter.hasNext()) {
            sourceContinue = true;
            sourceRel = (SQLRelationship)sourceIter.next();
        } else {
            sourceContinue = false;
            sourceRel = null;
        }
        if (targetIter.hasNext()) {
            targetContinue = true;
            targetRel = (SQLRelationship)targetIter.next();
        } else {
            targetContinue = false;
            targetRel = null;
        }
        while (sourceContinue && targetContinue) {
            if (relComparator.compare(sourceRel, targetRel) < 0) {
                diffs.add(new DiffChunk<SQLRelationship>(sourceRel, DiffType.LEFTONLY));
                if (sourceIter.hasNext()) {
                    sourceRel = (SQLRelationship)sourceIter.next();
                } else {
                    sourceContinue = false;
                }
            }
            if (relComparator.compare(sourceRel, targetRel) > 0) {
                diffs.add(new DiffChunk<SQLRelationship>(targetRel, DiffType.RIGHTONLY));
                if (targetIter.hasNext()) {
                    targetRel = (SQLRelationship)targetIter.next();
                } else {
                    targetContinue = false;
                }
            }
            if (relComparator.compare(sourceRel, targetRel) != 0) continue;
            diffs.add(new DiffChunk<SQLRelationship>(sourceRel, DiffType.SAME));
            if (!targetIter.hasNext() && !sourceIter.hasNext()) {
                targetContinue = false;
                sourceContinue = false;
            }
            if (targetIter.hasNext()) {
                targetRel = (SQLRelationship)targetIter.next();
            } else {
                targetContinue = false;
            }
            if (sourceIter.hasNext()) {
                sourceRel = (SQLRelationship)sourceIter.next();
                continue;
            }
            sourceContinue = false;
        }
        while (sourceContinue) {
            diffs.add(new DiffChunk<SQLRelationship>(sourceRel, DiffType.LEFTONLY));
            if (sourceIter.hasNext()) {
                sourceRel = (SQLRelationship)sourceIter.next();
                continue;
            }
            sourceContinue = false;
        }
        while (targetContinue) {
            diffs.add(new DiffChunk<SQLRelationship>(targetRel, DiffType.RIGHTONLY));
            if (targetIter.hasNext()) {
                targetRel = (SQLRelationship)targetIter.next();
                continue;
            }
            targetContinue = false;
        }
        return diffs;
    }

    private List<DiffChunk<SQLObject>> generateColumnDiffs(SQLTable sourceTable, SQLTable targetTable) throws ArchitectException {
        boolean keyChangeFlag = false;
        TreeSet<SQLObject> sourceColumnList = new TreeSet<SQLObject>(comparator);
        TreeSet<SQLObject> targetColumnList = new TreeSet<SQLObject>(comparator);
        boolean sourceColContinue = false;
        boolean targetColContinue = false;
        Iterator<SQLObject> sourceColIter = null;
        Iterator<SQLObject> targetColIter = null;
        SQLColumn sourceColumn = null;
        SQLColumn targetColumn = null;
        ArrayList<DiffChunk<SQLObject>> diffs = new ArrayList<DiffChunk<SQLObject>>();
        if (sourceTable != null) {
            sourceColumnList.addAll(sourceTable.getColumns());
        }
        if (targetTable != null) {
            targetColumnList.addAll(targetTable.getColumns());
        }
        if (sourceColumnList.size() == 0) {
            sourceColumnList = null;
            sourceColContinue = false;
        } else {
            sourceColIter = sourceColumnList.iterator();
            sourceColumn = (SQLColumn)sourceColIter.next();
            sourceColContinue = true;
        }
        if (targetColumnList.size() == 0) {
            targetColumnList = null;
            targetColContinue = false;
        } else {
            targetColIter = targetColumnList.iterator();
            targetColumn = (SQLColumn)targetColIter.next();
            targetColContinue = true;
        }
        while (sourceColContinue && targetColContinue) {
            if (comparator.compare(sourceColumn, targetColumn) < 0) {
                diffs.add(new DiffChunk<SQLColumn>(sourceColumn, DiffType.LEFTONLY));
                if (sourceColIter.hasNext()) {
                    sourceColumn = (SQLColumn)sourceColIter.next();
                } else {
                    sourceColContinue = false;
                }
            }
            if (comparator.compare(sourceColumn, targetColumn) > 0) {
                diffs.add(new DiffChunk<SQLColumn>(targetColumn, DiffType.RIGHTONLY));
                if (targetColIter.hasNext()) {
                    targetColumn = (SQLColumn)targetColIter.next();
                } else {
                    targetColContinue = false;
                }
            }
            if (comparator.compare(sourceColumn, targetColumn) != 0) continue;
            if (targetColumn.isPrimaryKey() != sourceColumn.isPrimaryKey()) {
                keyChangeFlag = true;
            }
            if (targetColumn.getType() != sourceColumn.getType() || targetColumn.getPrecision() != sourceColumn.getPrecision() || targetColumn.getScale() != sourceColumn.getScale() || targetColumn.getNullable() != sourceColumn.getNullable()) {
                diffs.add(new DiffChunk<SQLColumn>(targetColumn, DiffType.MODIFIED));
            } else {
                diffs.add(new DiffChunk<SQLColumn>(sourceColumn, DiffType.SAME));
            }
            if (targetColIter.hasNext()) {
                targetColumn = (SQLColumn)targetColIter.next();
            } else {
                targetColContinue = false;
            }
            if (sourceColIter.hasNext()) {
                sourceColumn = (SQLColumn)sourceColIter.next();
            } else {
                sourceColContinue = false;
            }
            if (!sourceColContinue || targetColContinue) continue;
        }
        while (sourceColContinue) {
            diffs.add(new DiffChunk<SQLColumn>(sourceColumn, DiffType.LEFTONLY));
            if (sourceColIter.hasNext()) {
                sourceColumn = (SQLColumn)sourceColIter.next();
                continue;
            }
            sourceColContinue = false;
        }
        while (targetColContinue) {
            diffs.add(new DiffChunk<SQLColumn>(targetColumn, DiffType.RIGHTONLY));
            if (targetColIter.hasNext()) {
                targetColumn = (SQLColumn)targetColIter.next();
                continue;
            }
            targetColContinue = false;
        }
        if (keyChangeFlag) {
            diffs.add(new DiffChunk<SQLTable>(targetTable, DiffType.KEY_CHANGED));
        }
        return diffs;
    }

    @Override
    public synchronized Integer getJobSize() {
        return this.jobSize;
    }

    @Override
    public synchronized int getProgress() {
        return this.progress;
    }

    @Override
    public synchronized boolean hasStarted() throws ArchitectException {
        return true;
    }

    @Override
    public synchronized boolean isFinished() throws ArchitectException {
        return this.finished;
    }

    @Override
    public synchronized String getMessage() {
        return this.currentTableName;
    }

    @Override
    public synchronized void setCancelled(boolean cancelled) {
        cancelled = true;
    }

    private synchronized void setJobSize(Integer jobSize) {
        this.jobSize = jobSize;
    }

    private synchronized void setProgress(int progress) {
        this.progress = progress;
    }

    private synchronized void incProgress(int amount) {
        this.progress += amount;
    }

    public synchronized void setFinished(boolean finished) {
        this.finished = finished;
    }
}

