/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLIndex;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.GenericTypeDescriptor;
import ca.sqlpower.architect.profile.ProfileFunctionDescriptor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MySqlDDLGenerator
extends GenericDDLGenerator {
    public static final String GENERATOR_VERSION = "$Revision: 1.6 $";
    private static final Logger logger = Logger.getLogger(MySqlDDLGenerator.class);
    private static HashSet reservedWords = new HashSet();

    protected void createTypeMap() throws SQLException {
        this.typeMap = new HashMap();
        this.typeMap.put(-5, new GenericTypeDescriptor("BIGINT", -5, 38L, null, null, 1, true, false));
        this.typeMap.put(-7, new GenericTypeDescriptor("TINYINT", -7, 1L, null, null, 1, true, false));
        this.typeMap.put(2004, new GenericTypeDescriptor("LONGBLOB", 2004, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(1, new GenericTypeDescriptor("CHAR", 1, 2000L, "'", "'", 1, true, false));
        this.typeMap.put(2005, new GenericTypeDescriptor("LONGTEXT", 2005, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(91, new GenericTypeDescriptor("DATE", 91, 0L, "'", "'", 1, false, false));
        this.typeMap.put(3, new GenericTypeDescriptor("DECIMAL", 3, 38L, null, null, 1, true, true));
        this.typeMap.put(8, new GenericTypeDescriptor("DOUBLE PRECISION", 8, 38L, null, null, 1, false, false));
        this.typeMap.put(6, new GenericTypeDescriptor("DOUBLE PRECISION", 6, 38L, null, null, 1, false, false));
        this.typeMap.put(4, new GenericTypeDescriptor("INT", 4, 38L, null, null, 1, true, false));
        this.typeMap.put(2, new GenericTypeDescriptor("NUMERIC", 2, 38L, null, null, 1, true, true));
        this.typeMap.put(7, new GenericTypeDescriptor("DOUBLE PRECISION", 7, 38L, null, null, 1, false, false));
        this.typeMap.put(5, new GenericTypeDescriptor("SMALLINT", 5, 38L, null, null, 1, true, false));
        this.typeMap.put(92, new GenericTypeDescriptor("TIME", 92, 0L, "'", "'", 1, false, false));
        this.typeMap.put(93, new GenericTypeDescriptor("TIMESTAMP", 93, 0L, "'", "'", 1, false, false));
        this.typeMap.put(-6, new GenericTypeDescriptor("TINYINT", -6, 38L, null, null, 1, true, false));
        this.typeMap.put(-2, new GenericTypeDescriptor("BINARY", -2, 65535L, null, null, 1, true, false));
        this.typeMap.put(-4, new GenericTypeDescriptor("VARBINARY", -4, 65535L, null, null, 1, true, false));
        this.typeMap.put(-3, new GenericTypeDescriptor("VARBINARY", -3, 65535L, null, null, 1, true, false));
        this.typeMap.put(-1, new GenericTypeDescriptor("VARCHAR", -1, 65535L, "'", "'", 1, true, false));
        this.typeMap.put(12, new GenericTypeDescriptor("VARCHAR", 12, 65535L, "'", "'", 1, true, false));
    }

    protected void createProfileFunctionMap() {
        this.profileFunctionMap = new HashMap();
        this.profileFunctionMap.put("BIGINT", new ProfileFunctionDescriptor("BIGINT", -5, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("BINARY", new ProfileFunctionDescriptor("BINARY", -2, true, false, false, false, true, true, true, true));
        this.profileFunctionMap.put("BIT", new ProfileFunctionDescriptor("TINYINT", -7, true, false, false, false, true, true, true, true));
        this.profileFunctionMap.put("BLOB", new ProfileFunctionDescriptor("LONGBLOB", 2004, true, false, false, false, true, true, true, true));
        this.profileFunctionMap.put("CHAR", new ProfileFunctionDescriptor("CHAR", 1, true, false, false, false, true, true, true, true));
        this.profileFunctionMap.put("CLOB", new ProfileFunctionDescriptor("LONGTEXT", 2005, true, false, false, false, true, true, true, true));
        this.profileFunctionMap.put("DATE", new ProfileFunctionDescriptor("DATE", 91, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("DECIMAL", new ProfileFunctionDescriptor("DECIMAL", 3, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("DOUBLE", new ProfileFunctionDescriptor("DOUBLE PRECISION", 8, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("FLOAT", new ProfileFunctionDescriptor("DOUBLE PRECISION", 6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("INTEGER", new ProfileFunctionDescriptor("INT", 4, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("LONGVARBINARY", new ProfileFunctionDescriptor("VARBINARY", -4, false, false, false, false, true, true, true, true));
        this.profileFunctionMap.put("LONGVARCHAR", new ProfileFunctionDescriptor("VARCHAR", -1, false, false, false, false, true, true, true, true));
        this.profileFunctionMap.put("NUMERIC", new ProfileFunctionDescriptor("NUMERIC", 2, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("REAL", new ProfileFunctionDescriptor("DOUBLE PRECISION", 7, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("SMALLINT", new ProfileFunctionDescriptor("SMALLINT", 5, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("TIME", new ProfileFunctionDescriptor("TIME", 92, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("TIMESTAMP", new ProfileFunctionDescriptor("TIMESTAMP", 93, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("TINYINT", new ProfileFunctionDescriptor("TINYINT", -6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("VARBINARY", new ProfileFunctionDescriptor("VARBINARY", -3, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("VARCHAR", new ProfileFunctionDescriptor("VARCHAR", 12, true, true, true, false, true, true, true, true));
    }

    public boolean isReservedWord(String word) {
        return reservedWords.contains(word.toUpperCase());
    }

    public String getCatalogTerm() {
        return "Database";
    }

    public String getSchemaTerm() {
        return null;
    }

    public void dropRelationship(SQLRelationship r) {
        this.print("\n ALTER TABLE ");
        this.print(this.toQualifiedName(r.getFkTable()));
        this.print(" DROP FOREIGN KEY ");
        this.print(r.getName());
        this.endStatement(DDLStatement.StatementType.DROP, r);
    }

    protected void writePrimaryKey(SQLTable t) throws ArchitectException {
        boolean firstCol = true;
        for (SQLColumn col : t.getColumns()) {
            if (col.getPrimaryKeySeq() == null) break;
            if (firstCol) {
                this.println("");
                this.print("ALTER TABLE ");
                this.print(this.toQualifiedName(t));
                this.print(" ADD CONSTRAINT ");
                this.print("PRIMARY KEY (");
                firstCol = false;
            } else {
                this.print(", ");
            }
            this.print(col.getPhysicalName());
        }
        if (!firstCol) {
            this.print(")");
            this.endStatement(DDLStatement.StatementType.ADD_PK, t);
        }
    }

    public void addIndex(SQLIndex index) throws ArchitectException {
        if (index.getType() == SQLIndex.IndexType.STATISTIC) {
            return;
        }
        this.checkDupIndexname(index);
        this.println("");
        this.print("CREATE ");
        if (index.isUnique()) {
            this.print("UNIQUE ");
        }
        this.print("INDEX ");
        this.print(index.getName());
        this.print("\n ON ");
        this.print(this.toQualifiedName(index.getParentTable()));
        this.print("\n ( ");
        boolean first = true;
        for (SQLIndex.Column c : index.getChildren()) {
            if (!first) {
                this.print(", ");
            }
            this.print(c.getName());
            this.print(c.isAscending() ? " ASC" : "");
            this.print(c.isDescending() ? " DESC" : "");
            first = false;
        }
        this.print(" )");
        this.endStatement(DDLStatement.StatementType.CREATE, index);
    }

    static {
        reservedWords.add("ADD");
        reservedWords.add("ALL");
        reservedWords.add("ALTER");
        reservedWords.add("ANALYZE");
        reservedWords.add("AND");
        reservedWords.add("AS");
        reservedWords.add("ASC");
        reservedWords.add("ASENSITIVE");
        reservedWords.add("BEFORE");
        reservedWords.add("BETWEEN");
        reservedWords.add("BIGINT");
        reservedWords.add("BINARY");
        reservedWords.add("BLOB");
        reservedWords.add("BOTH");
        reservedWords.add("BY");
        reservedWords.add("CALL");
        reservedWords.add("CASCADE");
        reservedWords.add("CASE");
        reservedWords.add("CHANGE");
        reservedWords.add("CHAR");
        reservedWords.add("CHARACTER");
        reservedWords.add("CHECK");
        reservedWords.add("COLLATE");
        reservedWords.add("COLUMN");
        reservedWords.add("CONDITION");
        reservedWords.add("CONNECTION");
        reservedWords.add("CONSTRAINT");
        reservedWords.add("CONTINUE");
        reservedWords.add("CONVERT");
        reservedWords.add("CREATE");
        reservedWords.add("CROSS");
        reservedWords.add("CURRENT_DATE");
        reservedWords.add("CURRENT_TIME");
        reservedWords.add("CURRENT_TIMESTAMP");
        reservedWords.add("CURRENT_USER");
        reservedWords.add("CURSOR");
        reservedWords.add("DATABASE");
        reservedWords.add("DATABASES");
        reservedWords.add("DAY_HOUR");
        reservedWords.add("DAY_MICROSECOND");
        reservedWords.add("DAY_MINUTE");
        reservedWords.add("DAY_SECOND");
        reservedWords.add("DEC");
        reservedWords.add("DECIMAL");
        reservedWords.add("DECLARE");
        reservedWords.add("DEFAULT");
        reservedWords.add("DELAYED");
        reservedWords.add("DELETE");
        reservedWords.add("DESC");
        reservedWords.add("DESCRIBE");
        reservedWords.add("DETERMINISTIC");
        reservedWords.add("DISTINCT");
        reservedWords.add("DISTINCTROW");
        reservedWords.add("DIV");
        reservedWords.add("DOUBLE");
        reservedWords.add("DROP");
        reservedWords.add("DUAL");
        reservedWords.add("EACH");
        reservedWords.add("ELSE");
        reservedWords.add("ELSEIF");
        reservedWords.add("ENCLOSED");
        reservedWords.add("ESCAPED");
        reservedWords.add("EXISTS");
        reservedWords.add("EXIT");
        reservedWords.add("EXPLAIN");
        reservedWords.add("FETCH");
        reservedWords.add("FLOAT");
        reservedWords.add("FLOAT4");
        reservedWords.add("FLOAT8");
        reservedWords.add("FOR");
        reservedWords.add("FORCE");
        reservedWords.add("FOREIGN");
        reservedWords.add("FROM");
        reservedWords.add("FULLTEXT");
        reservedWords.add("GRANT");
        reservedWords.add("GROUP");
        reservedWords.add("HAVING");
        reservedWords.add("HIGH_PRIORITY");
        reservedWords.add("HOUR_MICROSECOND");
        reservedWords.add("HOUR_MINUTE");
        reservedWords.add("HOUR_SECOND");
        reservedWords.add("IF");
        reservedWords.add("IGNORE");
        reservedWords.add("IN");
        reservedWords.add("INDEX");
        reservedWords.add("INFILE");
        reservedWords.add("INNER");
        reservedWords.add("INOUT");
        reservedWords.add("INSENSITIVE");
        reservedWords.add("INSERT");
        reservedWords.add("INT");
        reservedWords.add("INT1");
        reservedWords.add("INT2");
        reservedWords.add("INT3");
        reservedWords.add("INT4");
        reservedWords.add("INT8");
        reservedWords.add("INTEGER");
        reservedWords.add("INTERVAL");
        reservedWords.add("INTO");
        reservedWords.add("IS");
        reservedWords.add("ITERATE");
        reservedWords.add("JOIN");
        reservedWords.add("KEY");
        reservedWords.add("KEYS");
        reservedWords.add("KILL");
        reservedWords.add("LEADING");
        reservedWords.add("LEAVE");
        reservedWords.add("LEFT");
        reservedWords.add("LIKE");
        reservedWords.add("LIMIT");
        reservedWords.add("LINES");
        reservedWords.add("LOAD");
        reservedWords.add("LOCALTIME");
        reservedWords.add("LOCALTIMESTAMP");
        reservedWords.add("LOCK");
        reservedWords.add("LONG");
        reservedWords.add("LONGBLOB");
        reservedWords.add("LONGTEXT");
        reservedWords.add("LOOP");
        reservedWords.add("LOW_PRIORITY");
        reservedWords.add("MATCH");
        reservedWords.add("MEDIUMBLOB");
        reservedWords.add("MEDIUMINT");
        reservedWords.add("MEDIUMTEXT");
        reservedWords.add("MIDDLEINT");
        reservedWords.add("MINUTE_MICROSECOND");
        reservedWords.add("MINUTE_SECOND");
        reservedWords.add("MOD");
        reservedWords.add("MODIFIES");
        reservedWords.add("NATURAL");
        reservedWords.add("NO_WRITE_TO_BINLOG");
        reservedWords.add("NOT");
        reservedWords.add("NULL");
        reservedWords.add("NUMERIC");
        reservedWords.add("ON");
        reservedWords.add("OPTIMIZE");
        reservedWords.add("OPTION");
        reservedWords.add("OPTIONALLY");
        reservedWords.add("OR");
        reservedWords.add("ORDER");
        reservedWords.add("OUT");
        reservedWords.add("OUTER");
        reservedWords.add("OUTFILE");
        reservedWords.add("PRECISION");
        reservedWords.add("PRIMARY");
        reservedWords.add("PROCEDURE");
        reservedWords.add("PURGE");
        reservedWords.add("RAID0");
        reservedWords.add("READ");
        reservedWords.add("READS");
        reservedWords.add("REAL");
        reservedWords.add("REFERENCES");
        reservedWords.add("REGEXP");
        reservedWords.add("RELEASE");
        reservedWords.add("RENAME");
        reservedWords.add("REPEAT");
        reservedWords.add("REPLACE");
        reservedWords.add("REQUIRE");
        reservedWords.add("RESTRICT");
        reservedWords.add("RETURN");
        reservedWords.add("REVOKE");
        reservedWords.add("RIGHT");
        reservedWords.add("RLIKE");
        reservedWords.add("SCHEMA");
        reservedWords.add("SCHEMAS");
        reservedWords.add("SECOND_MICROSECOND");
        reservedWords.add("SELECT");
        reservedWords.add("SENSITIVE");
        reservedWords.add("SEPARATOR");
        reservedWords.add("SET");
        reservedWords.add("SHOW");
        reservedWords.add("SMALLINT");
        reservedWords.add("SONAME");
        reservedWords.add("SPATIAL");
        reservedWords.add("SPECIFIC");
        reservedWords.add("SQL");
        reservedWords.add("SQL_BIG_RESULT");
        reservedWords.add("SQL_CALC_FOUND_ROWS");
        reservedWords.add("SQL_SMALL_RESULT");
        reservedWords.add("SQLEXCEPTION");
        reservedWords.add("SQLSTATE");
        reservedWords.add("SQLWARNING");
        reservedWords.add("SSL");
        reservedWords.add("STARTING");
        reservedWords.add("STRAIGHT_JOIN");
        reservedWords.add("TABLE");
        reservedWords.add("TERMINATED");
        reservedWords.add("THEN");
        reservedWords.add("TINYBLOB");
        reservedWords.add("TINYINT");
        reservedWords.add("TINYTEXT");
        reservedWords.add("TO");
        reservedWords.add("TRAILING");
        reservedWords.add("TRIGGER");
        reservedWords.add("UNDO");
        reservedWords.add("UNION");
        reservedWords.add("UNIQUE");
        reservedWords.add("UNLOCK");
        reservedWords.add("UNSIGNED");
        reservedWords.add("UPDATE");
        reservedWords.add("USAGE");
        reservedWords.add("USE");
        reservedWords.add("USING");
        reservedWords.add("UTC_DATE");
        reservedWords.add("UTC_TIME");
        reservedWords.add("UTC_TIMESTAMP");
        reservedWords.add("VALUES");
        reservedWords.add("VARBINARY");
        reservedWords.add("VARCHAR");
        reservedWords.add("VARCHARACTER");
        reservedWords.add("VARYING");
        reservedWords.add("WHEN");
        reservedWords.add("WHERE");
        reservedWords.add("WHILE");
        reservedWords.add("WITH");
        reservedWords.add("WRITE");
        reservedWords.add("X509");
        reservedWords.add("XOR");
        reservedWords.add("YEAR_MONTH");
        reservedWords.add("ZEROFILL");
    }
}

