/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.DBCSSource;
import ca.sqlpower.sql.DBCSSourceSupport;
import ca.sqlpower.sql.DatabaseListReadException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XMLFileDBCSSource
implements DBCSSource,
Serializable {
    private String xmlFileName;
    private List cachedDbcsList;
    private long cachedDbcsListRefreshTime;

    public XMLFileDBCSSource(String xmlFileName) {
        this.xmlFileName = xmlFileName;
    }

    public synchronized List getDBCSList() throws IllegalStateException, DatabaseListReadException {
        File dbcsFile = new File(this.xmlFileName);
        if (this.cachedDbcsList == null || dbcsFile.lastModified() >= this.cachedDbcsListRefreshTime) {
            InputStream dbXMLFile = null;
            try {
                dbXMLFile = new BufferedInputStream(new FileInputStream(dbcsFile));
                this.cachedDbcsList = new ArrayList(DBCSSourceSupport.getListUsingXMLStream(dbXMLFile));
                this.cachedDbcsListRefreshTime = System.currentTimeMillis();
            }
            catch (IOException e) {
                throw new DatabaseListReadException(e);
            }
            finally {
                try {
                    if (dbXMLFile != null) {
                        dbXMLFile.close();
                    }
                }
                catch (IOException e) {
                    throw new DatabaseListReadException(e);
                }
            }
        }
        return this.cachedDbcsList;
    }
}

