/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.testing;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import junit.framework.AssertionFailedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtils {
    public static boolean equals(Object o1, Object o2) {
        Class<?> c2;
        if (o1 == o2) {
            return true;
        }
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        Class<?> c1 = o1.getClass();
        if (c1 != (c2 = o2.getClass())) {
            System.err.println("Warn: classes are different");
            return false;
        }
        Map<String, Prop> props = TestUtils.getProperties(c1);
        ArrayList propNames = new ArrayList(props.keySet());
        for (String name : propNames) {
            System.err.println("Trying property " + name);
            if (TestUtils.propsEquals(props.get((Object)name).rawField, o1, o2)) continue;
            return false;
        }
        return true;
    }

    public static void assertNoDefaultProperties(Object o) throws Exception {
        if (o == null) {
            throw new NullPointerException("Object may not be null");
        }
        Class<?> c = o.getClass();
        Map<String, Prop> props = TestUtils.getProperties(c);
        ArrayList propNames = new ArrayList(props.keySet());
        for (String name : propNames) {
            Prop p = props.get(name);
            Object target = null;
            if (p.rawField != null) {
                target = p.rawField.get(o);
            } else if (p.getter != null) {
                target = p.getter.invoke(o, new Object[0]);
            }
            System.out.printf("Field %s, value %s%n", name, target);
            if (target != null && !target.equals(Boolean.FALSE)) continue;
            throw new AssertionFailedError("property " + p.name + " is default");
        }
        System.out.println("assertNoDefaultProperties didn't find any problems");
    }

    private static Map<String, Prop> getProperties(Class c1) {
        Method[] methods;
        Field[] fields;
        HashMap<String, Prop> propsMap = new HashMap<String, Prop>();
        Field[] fieldArray = fields = c1.getDeclaredFields();
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            String name;
            Prop p;
            Field f = fieldArray[n];
            int mods = f.getModifiers();
            if (!Modifier.isPrivate(mods) && (p = (Prop)propsMap.get(name = f.getName())) == null) {
                p = new Prop(name);
                propsMap.put(name, p);
            }
            ++n;
        }
        Method[] methodArray = methods = c1.getDeclaredMethods();
        n2 = 0;
        int n3 = methodArray.length;
        while (n2 < n3) {
            String name;
            Method m = methodArray[n2];
            int mods = m.getModifiers();
            if (!Modifier.isPrivate(mods) && (name = m.getName()).startsWith("get") && !name.startsWith("set")) {
                String propName = name.substring(3);
                Prop p = (Prop)propsMap.get(propName);
                if (p == null) {
                    p = new Prop(propName);
                    propsMap.put(propName, p);
                }
                if (name.startsWith("get")) {
                    p.getter = m;
                } else if (name.startsWith("set")) {
                    p.setter = m;
                } else {
                    throw new IllegalStateException("invalid name " + name);
                }
            }
            ++n2;
        }
        return propsMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean propsEquals(Member member, Object o1, Object o2) {
        Object v2;
        Object v1;
        block9: {
            block8: {
                Method m;
                block7: {
                    if (member == null) {
                        System.err.println("Warning: member is null in propsEquals");
                        return false;
                    }
                    try {
                        if (member instanceof Field) {
                            Field f = (Field)member;
                            System.out.println(String.format("EqualsUtils.propsEquals(%s)", f.getName()));
                            Object val1 = f.get(o1);
                            Object val2 = f.get(o2);
                            System.err.println(val1);
                            System.err.println(val2);
                            return val1.equals(val2);
                        }
                        if (!(member instanceof Method)) throw new IllegalArgumentException("Internal error: member " + member + " neither Method nor Field");
                        m = (Method)member;
                        String methodName = m.getName();
                        if (!methodName.startsWith("set")) break block7;
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                v1 = m.invoke(o1, new Object[0]);
                v2 = m.invoke(o2, new Object[0]);
                if (v1 != null || v2 != null) break block8;
                return true;
            }
            if (v1 != null && v2 != null) break block9;
            return false;
        }
        return v1.equals(v2);
    }

    static class Prop {
        String name;
        Field rawField;
        Method getter;
        Method setter;

        Prop(String name) {
            this.name = name;
        }
    }
}

