/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.lang;

import com.darwinsys.lang.GetOpt;
import com.darwinsys.lang.GetOptDesc;
import junit.framework.TestCase;

public class GetOptConstructorTest
extends TestCase {
    public void testOK() {
        GetOpt getopt = new GetOpt("tn:");
        GetOptConstructorTest.assertEquals((int)2, (int)getopt.options.length);
        GetOptDesc tDesc = getopt.options[0];
        GetOptConstructorTest.assertTrue(('t' == tDesc.getArgLetter() ? 1 : 0) != 0);
        GetOptConstructorTest.assertEquals(null, (String)tDesc.getArgName());
        GetOptConstructorTest.assertFalse((boolean)tDesc.takesArgument());
        GetOptDesc nDesc = getopt.options[1];
        GetOptConstructorTest.assertTrue(('n' == nDesc.getArgLetter() ? 1 : 0) != 0);
        GetOptConstructorTest.assertEquals(null, (String)nDesc.getArgName());
        GetOptConstructorTest.assertTrue((boolean)nDesc.takesArgument());
    }

    public void testForNull() {
        try {
            String bad = null;
            new GetOpt(bad);
            GetOptConstructorTest.fail((String)"GetOpt(null) did not throw expected exception");
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Caught expected exception " + ex);
        }
    }

    public void testForNoLetter() {
        try {
            new GetOpt("---");
            GetOptConstructorTest.fail((String)"GetOpt(::) did not throw expected exception");
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Caught expected exception " + ex);
        }
        new GetOpt("f:c:");
        new GetOpt("foo");
    }

    public void testForLeadingColon() {
        try {
            new GetOpt(":a:b");
            GetOptConstructorTest.fail((String)"GetOpt(::) did not throw expected exception");
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Caught expected exception " + ex);
        }
    }

    public void testForExtraCruft() {
        String bad = "abc@";
        try {
            new GetOpt(bad);
            GetOptConstructorTest.fail((String)("GetOpt(" + bad + ") did not throw expected exception"));
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Caught expected exception " + ex);
        }
    }
}

