/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.csv;

import com.darwinsys.csv.CSVParserTestBase;
import com.darwinsys.csv.CSVRE;
import java.util.List;

public class CSVRETest
extends CSVParserTestBase {
    public CSVRETest() {
        this.csv = new CSVRE();
    }

    public void testCanonical() {
        List<String> list = this.csv.parse("\"a\",\"b\",\"c\"");
        CSVRETest.assertEquals((int)3, (int)list.size());
        CSVRETest.assertEquals((Object)"a", (Object)list.get(0));
        CSVRETest.assertEquals((Object)"b", (Object)list.get(1));
        CSVRETest.assertEquals((Object)"c", (Object)list.get(2));
    }

    public void testNullField() {
        List<String> list = this.csv.parse("\"a\",,\"c\"");
        CSVRETest.assertEquals((int)3, (int)list.size());
        CSVRETest.assertEquals((Object)"a", (Object)list.get(0));
        CSVRETest.assertEquals(null, (Object)list.get(1));
        CSVRETest.assertEquals((Object)"c", (Object)list.get(2));
    }

    public void testNotAllQuoted() {
        List<String> list = this.csv.parse("\"a\",b,\"c\"");
        CSVRETest.assertEquals((int)3, (int)list.size());
        CSVRETest.assertEquals((Object)"a", (Object)list.get(0));
        CSVRETest.assertEquals((Object)"b", (Object)list.get(1));
        CSVRETest.assertEquals((Object)"c", (Object)list.get(2));
    }

    public void testAllUnQuoted() {
        List<String> list = this.csv.parse("a,b,c");
        CSVRETest.assertEquals((int)3, (int)list.size());
        CSVRETest.assertEquals((Object)"a", (Object)list.get(0));
        CSVRETest.assertEquals((Object)"b", (Object)list.get(1));
        CSVRETest.assertEquals((Object)"c", (Object)list.get(2));
    }

    public void testMixedField() {
        List<String> list = this.csv.parse("\"LU\",86.25|\"11/4/1998\"|\"2:19PM\"|+4.0625");
        CSVRETest.assertEquals((int)2, (int)list.size());
    }

    public void XXXtestEscapeQuoted() {
        String string = "\"a,b,c\",d,\"and \\\"e\",f";
        System.out.println(string);
        List<String> list = this.csv.parse(string);
        CSVRETest.assertEquals((int)4, (int)list.size());
        CSVRETest.assertEquals((Object)"a,b,c", (Object)list.get(0));
        CSVRETest.assertEquals((Object)"d", (Object)list.get(1));
        CSVRETest.assertEquals((Object)"f", (Object)list.get(3));
    }
}

