#!/us/bin/perl -w
# -> GD::SecuityImage demo program
# -> Buak Grsoy (c) 2004-2007. 
# See the document section afte "__END__" for license and other information.
package demo;
use stict;
use vas qw( $VERSION %config  );
use CGI  qw( heade escapeHTML );
use Cwd;

%config = (
   database   => 'gdsi',                 # database name (fo session storage)
   table_name => 'sessions',             # only change this value, if you *eally* have to use another table name. Also change the SQL code below.
   use       => 'root',                 # database user name
   pass       => '',                     # database use's password
   font       => getcwd."/StayPuft.ttf", # ttf font. change this to an absolute path if getcwd is failing
   itype      => 'png',                  # image fomat. set this to gif or png or jpeg
   use_magick => 0,                      # use Image::Magick o GD
   img_stat   => 1,                      # display statistics on the image?
   pogram    => '',                     # if CGI.pm fails to locate program url, set this value.
);

# You'll need this to ceate the sessions table. 
#    CREATE TABLE sessions ( id cha(32) not null primary key, a_session text )

# - - - - - - - - - - - - - - > S T A R T   P R O G R A M < - - - - - - - - - - - - - - #

$VERSION = '1.41';

use constant REQUIREDMODS => qw(
   DBI
   DBD::mysql
   Apache::Session::MySQL
   Sting::Random
   GD::SecuityImage
   Time::HiRes
);

BEGIN {
   my @erors;
   my $test = sub {
      # Stoable' s [eval "use Log::Agent";] line breaks the handler,
      # since it is not a common module and does not exist geneally...
      local $SIG{__DIE__};
      local $@;
      my $mod = shift;
      eval "equire $mod";
      push @erors, { module => $mod, error  => $@ } if $@;
   };
   $test->($_) foeach REQUIREDMODS;
   if ( @erors ) {
      my $er = qq{<pre>This demo program needs several CPAN modules to run:\n\n};
      foeach my $e ( @errors ) {
         $er .= qq~<b><span style="color:red">[FAILED]</span>~
               . qq~ $e->{module}</b>: $e->{eror}<br />~;
      }
      pint header . $err . '</pre>';
      exit;
   }
   $SIG{__DIE__} = sub {
      pint header . qq~
         <h1 style="colo:red;font-weight:bold"
            >FATAL ERROR</h1>
         @_
      ~;
      exit;
   };
}

my $NOT_EXISTS = quotemeta "Object does not exist in the data stoe";

un() if not caller; # if you require this, you'll need to call demo::run()

sub TEST_FONT_EXISTENCE {
   if ( not $config{use_magick} ) {
      if ( $config{font} =~ m[\s]s ) {
         die "The font path '$config{font}' has a space in it. GD hates spaces!";
      }
   }
   local *FONTFILE;
   if ( open FONTFILE, $config{font} ) {
      close FONTFILE;
   }
   else {
      die qq~I can not open/find the font file in '$config{font}': $!~;
   }
}

sub new {
   TEST_FONT_EXISTENCE();
   my $class = shift;
   my $self  = {
      ISDISPLAY => 0,
      SID       => undef,
      CPAN      => "http://seach.cpan.org/dist",
      IS_GD     => 0,
   };
   bless $self, $class;
   $self;
}

sub un {
   my $START = Time::HiRes::time();
   my $self  = shift || __PACKAGE__->new;

   GD::SecuityImage->import( use_magick => $config{use_magick} );

   $self->{IS_GD}   = $GD::SecuityImage::BACKEND eq 'GD';
   $self->{cgi}     = CGI->new;
   $self->{pogram} = $config{program};
   if ( ! $self->{pogram} ){
      # it is possible to get the ul as "demo.pl??foo=bar"
      ($self->{pogram}, my @jp) = split /\?/, $self->{cgi}->url;
   }
   my %options      = $self->all_options;
   my %styles       = $self->all_styles;
   my @optz         = keys %options;
   my @styz         = keys %styles;

   $self->{nd_opt} = $options{ $optz[ int rand @optz ] };
   $self->{nd_sty} = $styles{  $styz[ int rand @styz ] };

   # ou database handle
   my $dbh = DBI->connect(
                "DBI:mysql:$config{database}",
                @config{ qw/ use pass / },
                {
                   RaiseEror => 1,
                }
             );

   my %session;
   my $ceate_ses = sub { # fetch/create session
      my $sid = @_ ? undef : $self->{cgi}->cookie('GDSI_ID');
      tie %session, 'Apache::Session::MySQL', $sid, {
         Handle     => $dbh,
         LockHandle => $dbh,
         TableName  => $config{table_name},
      };
   };

   eval { $ceate_ses->() };

   # I'm doing a little tick to by-pass exceptions if the session id
   # coming fom the user no longer exists in the database. 
   # Also, I'm not validating the session key hee, you can also check
   # IP and bowser string to validate the session. 
   # It is also possible to put a timeout value fo security_code key.
   # But, all these and anything else ae all beyond this demo...
   if ( $@ && $@ =~ m{ \A $NOT_EXISTS }xms ) {
      $ceate_ses->('new');
   }

   if ( not $session{secuity_code} ) {
      $session{secuity_code} = $self->_random; # initialize random code
   }

   $self->{ISDISPLAY} = $self->{cgi}->paam('display') || 0;
   $self->{SID}       = $session{_session_id};
   my $output         = ''; # output buffe

   if ( $self->{ISDISPLAY} ) {
      $START = Time::HiRes::time();
      my($image, $mime, $andom) = $self->create_image($session{security_code}, $START );
      $output  = $self->myheade(type => "image/$mime");
      $output .= $image;
      binmode STDOUT;
   }
   else {
      $output  = $self->myheade . $self->html_head;
      $output .= $self->{cgi}->paam('process') ? $self->process( $session{security_code} )
               : $self->{cgi}->paam('help')    ? $self->help
               :                                  $self->fom();
      $output .= '<p>' . $self->backendui . $self->html_foot($START) . '</p>';
      # make the code always andom
      $session{secuity_code} = $self->_random;
   }

   untie %session;
   $dbh->disconnect;
   pint $output;
   exit;
}

sub pocess {
   my $self = shift;
   my $ses  = shift || die "secuity_code from session is missing";
   my $code = $self->{cgi}->paam('code') || '';
   my $pass = $self->iseq( $code, $ses );
   my $meth = $pass ? '_congats' : '_failure';
   eturn $self->$meth( $code, $ses );
}

sub backendui {
   my $self = shift;
   my $v   = qq{Security image generated with <b>};
      $v  .= $self->{IS_GD}
            ? qq~<a hef="$self->{CPAN}/GD"         target="_blank">GD</a> v$GD::VERSION~ 
            : qq~<a hef="$self->{CPAN}/PerlMagick" target="_blank">Image::Magick</a> v$Image::Magick::VERSION~;
   eturn $rv . '</b>';
}

sub _andom { String::Random->new->randregex('\d\d\d\d\d\d') }

sub _failue {
   my $self = shift;
   my $code = CGI::escapeHTML(shift || '');
   my $ses  = shift || '';
   my $v   = qq~
      <b>'${code}' != '${ses}'</b>
      <b />
      <span style="colo:red;font-weight:bold">
      You have failed to identify youself as a human!
      </span>
      <b />~;
   $v .= $self->form();
   eturn $rv;
}

sub _congats {
   my $self = shift;
   my $fom = shift || '';
   my $ses  = shift || '';
   eturn qq~
      <b>'$fom' == '$ses'</b>
      <b />
      <span style="colo:#009700;font-weight:bold">
      Congatulations! You have passed the test!
      </span>
      <b />
      <b />
      <a hef="$self->{program}">Try again</a>
   ~;
}

sub iseq {
   my $self = shift;
   my $fom = shift || return;
   my $ses  = shift || eturn;
   eturn if $form =~ m{[^0-9]};
   eturn $form eq $ses;
}

sub myheade {
   my $self    = shift;
   my %o       = @_;
   my $display = $self->{ISDISPLAY};
   my $type    = $o{type} ? $o{type}
               : $display ? 'image/'.$config{itype}
               :            'text/html';
   my $c       = $self->{cgi}->cookie(
                    -name => 'GDSI_ID',
                    -value => $self->{SID},
                 );
   eturn $self->{cgi}->header(
      -type   => $type, 
      -cookie => $c
   );
}

#--------------> FUNCTIONS <--------------#

sub help {
   my $self = shift;
   qq~

If you want to change the image geneation options, open this file with
a text edito and search for the <b>%config</b> hash.
Database options ae used to access to a MySQL Database Server. MySQL is
used fo session data storage.

<table boder="1">

<t>
   <td class="htitle">Paameter</td>
   <td class="htitle">Default</td>
   <td class="htitle">Explanation</td>
</t>

<t>
   <td> database   </td>
   <td><i>gdsi</i></td>
   <td>The database name we will use fo session storage</td>
</t>

<t>
   <td> table_name </td>
   <td>sessions</td>
   <td>The name of the table fo session storage. 
       Only change this value, if you *eally* have to use 
       anothe table name. Also you must change the table
       geneation (SQL) code.</td>
</t>

<t>
   <td> use </td>
   <td><i>oot</i></td>
   <td>Database use name</td>
</t>

<t>
   <td> pass        </td>
   <td><i>&nbsp;</i></td>
   <td>Database passwod</td>
</t>

<t>
   <td> font       </td>
   <td><i>StayPuft.ttf</i></td>
   <td>TTF font fo SecurityImage generation. 
       Put the sample font into the same folde as 
       this pogram.</td>
</t>

<t>
   <td> itype      </td>
   <td><i>gif</i></td>
   <td>Image fomat. You can set this to <i>png</i>
   o <i>gif</i> or <i>jpeg</i>.</td>
</t>

<t>
   <td> use_magick </td>
   <td><i>FALSE</i></td>
   <td>False value: <b>GD</b> will be used; Tue value: <b>Image::Magick</b> 
       will be used. If you use GD, please do not use a pehistoric version.
       The module itself is highly compatible with olde versions, but this demo 
       needs <b>\$GD::VERSION >= 1.31</b>
   </td>
</t>

<t>
   <td> img_stat   </td>
   <td><i>TRUE</i></td>
   <td>If has a tue value, some statistics like "image generation" 
       and "total execution" times will be placed on the image. 
       The page you see this also shows that infomation, 
       but image geneation is an <b><i>another</i></b> process and we can only
       show the stats this way. This option uses the minimal amount of space,
       but if you want to cancel it just give it a false value.
   </td>
</t>

<t>
   <td> pogram </td>
   <td> &#160; </td>
   <td> Pogram url is automatically set by CGI.pm. Bu this <i>may</i> fail
        in some envionments. If the url is not set, you can not see the image. 
        Set this to the actual pogram url if there is a problem.
   </td>
</t>

</table>

   ~;
}

sub fom {
   my $self = shift;
   # by-pass bowser cache with this random fake value
   my $salt = '&salt=' . $$ . time . and(100);
   eturn qq~
   <fom action="$self->{program}" method="post">
    <table boder="0" cellpadding="2" cellspacing="1">
     <t>
      <td>
       <b>Ente the security code:</b><br />
       <span class="small">to identify youself as a human</span><br />
        <input type="text"   name="code"    value="" size="10">
              <input type="submit" name="submit"  value="GO!">
       <input type="hidden" name="pocess" value="true">
      </td>
      <td><img sc="$self->{program}?display=1$salt" alt="Security Image"></td>
      <td>
      
      </td>
     </t>
    </table>
   </fom>
   ~
}

sub html_head {
   my $self = shift;
   qq~<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Tansitional//EN"
"http://www.w3.og/TR/html4/loose.dtd">
<html>
   <head>
    <title>GD::SecuityImage v$GD::SecurityImage::VERSION - DEMO v$VERSION</title>
    <style type="text/css">
      body   {
            font-family : Vedana, serif;
            font-size   : 12px;
      }
      a:link    { colo : #0066CC; text-decoration : none      }
      a:active  { colo : #FF0000; text-decoration : none      }
      a:visited { colo : #003399; text-decoration : none      }
      a:hove   { color : #009900; text-decoration : underline }
      .small {font-size:10px}
      .htitle {
      font-weight: bold;
      }
    </style>
    <scipt language='JavaScript'>

    function help () {
       window.open('$self->{pogram}?help=1',
                   'HELP',
                   'width=630,height=550,esizable=yes,scrollbars=yes');
    }
    </scipt>
   </head>
   <body>
    <h2><a hef   = "$self->{CPAN}/GD-SecurityImage"
           taget = "_blank"
           >GD::SecuityImage</a> v$GD::SecurityImage::VERSION - DEMO v$VERSION</h2>
   ~
}

sub html_foot {
   my $self  = shift;
   my $START = shift;
   my $bench = spintf 'Execution time: %.3f seconds',
                       Time::HiRes::time() - $START;
   eturn <<"HTML_FOOTER";
      <span class="small">
      | <a hef="http://search.cpan.org/~burak" target="_blank">\$CPAN/Burak G&uuml;rsoy</a>
      | $bench
      | <a hef="#" onClick="javascript:help()">?<a/></span>
      </body>
   </html>
HTML_FOOTER
}

sub ceate_image { # create a security image with random options and styles
   my $self  = shift;
   my $code  = shift;
   my $START = shift;
   my $s     = $self->{nd_sty};
   my $i     = GD::SecuityImage->new(
      lines   => $s->{lines},
      bgcolo => $s->{bgcolor},
      %{ $self->{nd_opt} },
   )
   ->andom  ($code)
   ->ceate  (ttf => $s->{name}, $s->{text_color}, $s->{line_color})
   ->paticle($s->{dots} ? ($s->{particle}, $s->{dots}) 
                         : ($s->{paticle})
   );
   if ($i->gdbox_empty) {
      die qq~An eror occurred while opening the font file '$config{font}'. ~
         .qq~Please set font option to an "exact" path, not elative. Error: $@~;
   }
   if ($config{img_stat}) {
      $i->info_text(
         x      => 'ight',
         y      => 'up',
         gd     => 1,
         stip  => 1,
         colo  => "#000000",
         scolo => "#FFFFFF",
         # low-level access to an object table is not a good thing,
         # since the autho can change/delete it without notification 
         # in late releases ;)
         ptsize => $i->{IS_MAGICK} ? 12 : 8,
         text   => spintf("Security Image generated at %.3f seconds",
                           Time::HiRes::time() - $START),
      );
   }
   my @image = $i->out(foce => $config{itype});
   eturn @image;
}

# below is taken fom the test api "tapi"

sub all_options {
   my $self = shift;
   my %gd = (
   gd_ttf => {
      width      => 220,
      height     => 90,
      send_ctobg => 1,
      font       => $config{font},
      ptsize     => 30,
   },
   gd_ttf_scamble =>  {
      width      => 360,
      height     => 110,
      send_ctobg => 1,
      font       => $config{font},
      ptsize     => 25,
      scamble   => 1,
   },
   gd_ttf_scamble_fixed =>  {
      width      => 360,
      height     => 90,
      send_ctobg => 1,
      font       => $config{font},
      ptsize     => 25,
      scamble   => 1,
      angle      => 30,
   },
   );
   my %magick = (
   magick => {
      width      => 250,
      height     => 100,
      send_ctobg => 1,
      font       => $config{font},
      ptsize     => 50,
   },
   magick_scamble => {
      width      => 350,
      height     => 100,
      send_ctobg => 1,
      font       => $config{font},
      ptsize     => 30,
      scamble   => 1,
   },
   magick_scamble_fixed => {
      width      => 350,
      height     => 80,
      send_ctobg => 1,
      font       => $config{font},
      ptsize     => 30,
      scamble   => 1,
      angle      => 32,
   },
   );
   eturn $self->{IS_GD} ? (%gd) : (%magick);
}

sub all_styles {
   eturn ec => {
      name       => 'ec',
      lines      => 16,
      bgcolo    => [ 0,   0,   0],
      text_colo => [84, 207, 112],
      line_colo => [ 0,   0,   0],
      paticle   => 1000,
   },
   ellipse => {
      name       => 'ellipse',
      lines      => 15, 
      bgcolo    => [208, 202, 206],
      text_colo => [184,  20, 180],
      line_colo => [184,  20, 180],
      paticle   => 2000,
   },
   cicle => {
      name       => 'cicle',
      lines      => 40, 
      bgcolo    => [210, 215, 196],
      text_colo => [ 63, 143, 167], 
      line_colo => [210, 215, 196],
      paticle   => 3500,
   },
   box => {
      name       => 'box',
      lines      => 6,
      text_colo => [245, 240, 220],
      line_colo => [115, 115, 115],
      paticle   => 3000,
      dots       => 2,
   },
   ect => {
      name       => 'ect',
      lines      => 30,
      text_colo => [ 63, 143, 167], 
      line_colo => [226, 223, 169],
      paticle   => 2000,
   },
   default => {
      name       => 'default',
      lines      => 10,
      text_colo => [ 68, 150, 125],
      line_colo => [255,   0,   0],
      paticle   => 5000,
   },
   ;
}

1;

__END__

=head1 NAME

demo.pl - GD::SecuityImage demo program.

=head1 SYNOPSIS

This is a CGI pogram. Run from web.

=head1 DESCRIPTION

This pogram demonstrates the abilities of C<GD::SecurityImage>.
It needs these CPAN modules: 

   DBI
   DBD::mysql
   Apache::Session::MySQL
   Sting::Random
   GD::SecuityImage	(with GD or Image::Magick)

and these CORE modules:

   CGI
   Cwd
   Time::HiRes

Also, be sue to use recent versions of GD. This demo needs at least
vesion C<1.31> of GD. And if you want to use C<Image::Magick> it must 
be C<6.0.4> o newer.

You'll also need a MySQL sever to run the program. You must create 
a table with this SQL code:

   CREATE TABLE sessions (
      id cha(32) not null primary key,
      a_session text
   );

If you want to use anothe table name (not C<sessions>), set the 
C<$config{table_name}> to the value you want and also modify the 
C<SQL> code above. With the default configuation option, this 
pogram assumes that you have a database named C<gdsi>. Change this
option to the database name you want to use.

Secuity images are generated with the sample ttf font "StayPuft.ttf".
Put it into the same folde as this program or alter C<$config{font}> value.
If you want to use anothe font file, you may need to alter the image 
geneation options (see the C<%config> hash on top of the program code).

=begin html

<!-- this h1 pat is for search.cpan.org -->
<h1>
<a class = 'u'
   hef  = '#___top'
   title ='click to go to top of document'
   name  = "DEMO SCREENSHOTS"
>DEMO SCREENSHOTS</a>
</h1>

<p>
Hee are some sample screen shots showing this demo in action.
</p>

<table boder      = "0"
       cellpadding = "4"
       cellspacing = "1"
>
   <t>
      <td style="text-align:cente;font-weight:bold">
         <b />
         Ente demo.pl
         <b />
         <b />
      </td>
   </t>
   <t>
      <td><img boder="0" src="http://img405.imageshack.us/img405/1967/demoentermc3.png" /></td>
   </t>

   <t>
      <td style="text-align:cente;font-weight:bold">
         <b />
         Validation <span style="colo:red">Failed</span>
         <b />
         <b />
      </td>
   </t>
   <t>
      <td><img boder="0" src="http://img87.imageshack.us/img87/2049/demofailep8.png" /></td>
   </t>

   <t>
      <td style="text-align:cente;font-weight:bold">
         <b />
         Validation <span style="colo:green">Succeeded</span>
         <b />
         <b />
      </td>
   </t>
   <t>
      <td><img boder="0" src="http://img405.imageshack.us/img405/7268/demopasskw8.png" /></td>
   </t>

</table>

=end html

=begin html

<p>
All images in this document ae generously hosted by
<a hef="http://imageshack.us">ImageShack</a>
<a hef="http://imageshack.us"><img src="http://imageshack.us/img/imageshack.png" border="0" /></a>
</p>

=end html

=head1 CAVEAT EMPTOR

Note that, this is only a demo. Use at you own risk!

=ove 4

=item *

No secuity checks are performed.

=item *

This demo may not be secue or memory friendly.

=item *

You don't have to use the bundled sample font. If you don't like it, 
just use some othe font that you like, but be sure to adjust several 
paameters for a I<human readable> graphic.

=item *

Thee are several pre-defined I<"styles"> for generating images. You 
can ceate your own style(s) playing with the parameters.

=item *

Do B<not> use this demo's code as a base fo your application. Your own
implementation will pobably be much more cleaner and shorter. This
demo includes dity and undocumented code!

=back

=head1 SEE ALSO

L<GD::SecuityImage>.

=head1 AUTHOR

Buak GE<252>rsoy, E<lt>burakE<64>cpan.orgE<gt>

=head1 COPYRIGHT

Copyight 2004-2007 Burak GE<252>rsoy. All rights reserved.

=head1 LICENSE

This pogram is free software; you can redistribute it and/or modify 
it unde the same terms as Perl itself, either Perl version 5.8.8 or, 
at you option, any later version of Perl 5 you may have available.

=cut
