/* 
 *  @OPENGROUP_COPYRIGHT@
 *  COPYRIGHT NOTICE
 *  Copyright (c) 1990, 1991, 1992, 1993 Open Software Foundation, Inc.
 *  Copyright (c) 1996, 1997, 1998, 1999, 2000 The Open Group
 *  ALL RIGHTS RESERVED (MOTIF). See the file named COPYRIGHT.MOTIF for
 *  the full copyright text.
 *  
 *  This software is subject to an open license. It may only be
 *  used on, with or for operating systems which are themselves open
 *  source systems. You must contact The Open Group for a license
 *  allowing distribution and sublicensing of this software on, with,
 *  or for operating systems which are not Open Source programs.
 *  
 *  See http://www.opengroup.org/openmotif/license for full
 *  details of the license agreement. Any use, reproduction, or
 *  distribution of the program constitutes recipient's acceptance of
 *  this agreement.
 *  
 *  EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE PROGRAM IS
 *  PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT LIMITATION, ANY
 *  WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY
 *  OR FITNESS FOR A PARTICULAR PURPOSE
 *  
 *  EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER RECIPIENT
 *  NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED
 *  AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 *  ANY WAY OUT OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE
 *  EXERCISE OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
*/ 
/* (c) Copyright 1992, Integrated Computer Solutions, Inc. */


#ifndef	_XmTableLayoutP_h
#define	_XmTableLayoutP_h

#include	<Xm/XmP.h>
#include	<Xm/ManagerP.h>
#include	<Xm/PrimitiveP.h>
#include	<TableLayout.h>

/* the boiler plate for the widget itself */

typedef struct _TableLayoutClassPart {
	char	*mystuff;		/* Make the compiler happy */
} TableLayoutClassPart;


typedef struct _XmTableLayoutClassRec {
	CoreClassPart		core_class;
	CompositeClassPart	composite_class;
	ConstraintClassPart	constraint_class;
	XmManagerClassPart	manager_class;
	TableLayoutClassPart	tablelayout_class;
} XmTableLayoutClassRec;

extern XmTableLayoutClassRec	xmTableLayoutClassRec;

typedef struct _XmTableLayoutAxis {
	char	tag[8];		/* for debugging printouts */
	int	n;		/* how many things */
	int	firstScroll;	/* thing where scrolling begins (res) */
	Dimension margin;	/* space between things (res) */

	int	firstVis;	/* first one that is visable */
	int	lastVis;	/* last one visable */
	long	*width;		/* how wide each column is.  Always correct,
				 * even for columns off the scroll region
				 */
	long	*disp;		/* where it begins on the image.  May be < 0
				 * if not in scroll region.
				 */
	long	totalWidth;	/* width needed for the whole table */
	Widget	sb;		/* my scroll bar */
	long	sbX, sbY;	/* where it begins */
	short	moved;		/* have we repositioned it */
	short	mapped;		/* have we been displayed yet */
	short	size, value;	/* cache current size and value to optimize
				 * away setvalue calls to prevent flicker */
	short	oldMin, oldMax;	/* more of the same */
	Widget	inherit;	/* Inherit widths from someone else */
} XmTableLayoutAxis;

typedef struct _XmTableLayoutPart {
	int		row, col;	/* current position (RO) */
	short		fillMode;	/* pad last column or row */
	short		deferSizingChildren;	/* childrenNeedExpose */
	short		mustDisplay;
	short		mustLayout;		/* must perform layout soon */
	short		doLayout;
	short		inGeometryManager;	/* prevent recursion */
	short		inDoLayout;		/* prevent recursion */
	short		inDrawChildren;		/* prevent recursion */
	short		inInitialize;		/* prevent geometry during setup */
	XtIntervalId	timerId;	/* Timer to defer scroll bar
					 * drag processing */
	short		scrollDir;	/* last scroll direction, 0 for
					 * towards end, 1 for head */
	XmTableLayoutAxis	cols;
	XmTableLayoutAxis	rows;

	GC		gc;		/* for drawing the table */
	XtCallbackProc	clickCallback;	/* call back to client when clicked */
	XtCallbackProc	dragCallback;	/* call back to client when dragged */
	XtCallbackProc	drawCallback;	/* call back to client for imaging */
	XtCallbackProc	dropCallback;	/* call back to client when dragged */
} XmTableLayoutPart;


typedef struct _XmTableLayoutRec {
	CorePart	core;
	CompositePart	composite;
	ConstraintPart	constraint;
	XmManagerPart  manager;
	XmTableLayoutPart	tablelayout;
} XmTableLayoutRec;

typedef struct _XmTableLayoutConstraintsPart {
	int	row;		/* my position in the table */
	int	col;
	int	rowSpan;	/* how many rows/cols I span */
	int	colSpan;
	int	ignore;		/* which dimensions to ignore in layout */
	int	gravity;	/* how to align me */

	Dimension	h, w;	/* desired size from creation and explicit
				 * geometry requests from the child
				 */
	int	placed;		/* Have I been placed on the table yet */
} XmTableLayoutConstraintsPart, *XmTableLayoutConstraints;

typedef struct _XmTableLayoutConstraintsRec {
	XmManagerConstraintPart manager;
	XmTableLayoutConstraintsPart	tablelayout;
} XmTableLayoutConstraintsRec, *XmTableLayoutConstraintsPtr;

#endif	/* _XmTableLayoutP_h */
