/* 
 *  @OPENGROUP_COPYRIGHT@
 *  COPYRIGHT NOTICE
 *  Copyright (c) 1990, 1991, 1992, 1993 Open Software Foundation, Inc.
 *  Copyright (c) 1996, 1997, 1998, 1999, 2000 The Open Group
 *  ALL RIGHTS RESERVED (MOTIF). See the file named COPYRIGHT.MOTIF for
 *  the full copyright text.
 *  
 *  This software is subject to an open license. It may only be
 *  used on, with or for operating systems which are themselves open
 *  source systems. You must contact The Open Group for a license
 *  allowing distribution and sublicensing of this software on, with,
 *  or for operating systems which are not Open Source programs.
 *  
 *  See http://www.opengroup.org/openmotif/license for full
 *  details of the license agreement. Any use, reproduction, or
 *  distribution of the program constitutes recipient's acceptance of
 *  this agreement.
 *  
 *  EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE PROGRAM IS
 *  PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT LIMITATION, ANY
 *  WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY
 *  OR FITNESS FOR A PARTICULAR PURPOSE
 *  
 *  EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER RECIPIENT
 *  NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED
 *  AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 *  ANY WAY OUT OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE
 *  EXERCISE OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
*/ 
/* 
 * HISTORY
*/ 
/* (c) Copyright 1989, Massachusetts Institute of Technology */
/*   Author:  Jim Fulton, MIT X Consortium */
/* (c) Copyright 1992, Integrated Computer Solutions, Inc. */
/*   Author:  Chris D. Peterson */

#ifndef _XmPannerP_h
#define _XmPannerP_h

#include <Xm/PrimitiveP.h>
#include <Xm/Panner.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _XmPannerClassPart { /* new fields in widget class */
    XtPointer extension;
} XmPannerClassPart;

typedef struct _XmPannerClassRec {	/* Panner widget class */
    CoreClassPart core_class;
    XmPrimitiveClassPart primitive_class;
    XmPannerClassPart panner_class;
} XmPannerClassRec;

typedef struct {
  Boolean doing;	       	/* tmp graphics in progress */
  Boolean showing;		/* true if tmp graphics displayed */
  Position startx, starty;	/* initial position of slider */
  Position dx, dy;		/* offset loc for tmp graphics */
  Position x, y;	       	/* location for tmp graphics */
} tmpstruct;


typedef struct XmPannerPart {	/* new fields in widget */
    /* resources... */
    XtCallbackList report_callbacks;	/* callback/Callback */
    Boolean resize_to_pref;		/* resizeToPreferred/Boolean */
    Pixel foreground;			/* foreground/Foreground */
    Dimension default_scale;		/* defaultScale/DefaultScale */
    Dimension canvas_width;		/* canvasWidth/CanvasWidth */
    Dimension canvas_height;		/* canvasHeight/CanvasHeight */
    Position slider_x;			/* sliderX/SliderX */
    Position slider_y;			/* sliderY/SliderY */
    Dimension slider_width;		/* sliderWidth/SliderWidth */
    Dimension slider_height;		/* sliderHeight/SliderHeight */
    Dimension internal_border;		/* internalBorderWidth/BorderWidth */
    Boolean rubber_band;		/* true = rubber band, false = move */
    /* private data... */
    struct _XmPannerPrivateRec *private;
} XmPannerPart;

typedef struct _XmPannerRec {
    CorePart core;
    XmPrimitivePart primitive;
    XmPannerPart panner;
} XmPannerRec;

#define XmPannerIndex (XmPrimitiveIndex + 1)

#define XmPanner_report_callbacks(w) 	(((XmPannerWidget)(w))->panner.report_callbacks)
#define XmPanner_resize_to_pref(w) 	(((XmPannerWidget)(w))->panner.resize_to_pref)
#define XmPanner_foreground(w) 		(((XmPannerWidget)(w))->panner.foreground)
#define XmPanner_default_scale(w) 	(((XmPannerWidget)(w))->panner.default_scale)
#define XmPanner_canvas_width(w) 	(((XmPannerWidget)(w))->panner.canvas_width)
#define XmPanner_canvas_height(w) 	(((XmPannerWidget)(w))->panner.canvas_height)
#define XmPanner_slider_x(w) 		(((XmPannerWidget)(w))->panner.slider_x)
#define XmPanner_slider_y(w)		(((XmPannerWidget)(w))->panner.slider_y)
#define XmPanner_slider_width(w) 	(((XmPannerWidget)(w))->panner.slider_width)
#define XmPanner_slider_height(w) 	(((XmPannerWidget)(w))->panner.slider_height)
#define XmPanner_internal_border(w) 	(((XmPannerWidget)(w))->panner.internal_border)
#define XmPanner_rubber_band(w) 	(((XmPannerWidget)(w))->panner.rubber_band)

#define XmPanner_private(w) (((XmPannerWidget)(w))->panner.private)

#define XmPanner_slider_gc(w) 	(XmPanner_private(w)->slider_gc)
#define XmPanner_xor_gc(w) 	(XmPanner_private(w)->xor_gc)
#define XmPanner_haspect(w) 	(XmPanner_private(w)->haspect)
#define XmPanner_vaspect(w) 	(XmPanner_private(w)->vaspect)
#define XmPanner_tmp(w) 	(XmPanner_private(w)->tmp)
#define XmPanner_knob_x(w) 	(XmPanner_private(w)->knob_x)
#define XmPanner_knob_y(w) 	(XmPanner_private(w)->knob_y)
#define XmPanner_knob_width(w) 	(XmPanner_private(w)->knob_width)
#define XmPanner_knob_height(w) (XmPanner_private(w)->knob_height)
#define XmPanner_last_x(w) 	(XmPanner_private(w)->last_x)
#define XmPanner_last_y(w) 	(XmPanner_private(w)->last_y)

#define PANNER_HSCALE(pw,val) (XmPanner_haspect((pw)) * ((double) (val)))
#define PANNER_VSCALE(pw,val) (XmPanner_vaspect((pw)) * ((double) (val)))

#define PANNER_DSCALE(pw,val) (Dimension)  \
  (((unsigned long) (val)) * (unsigned long) XmPanner_default_scale((pw)) / 100L)

#define PANNER_OUTOFRANGE -30000

/*
 * external declarations
 */

extern XmPannerClassRec xmPannerClassRec;

#ifdef __cplusplus
}	/* Closes scope of 'extern "C"' declaration */
#endif

#ifdef _NO_PROTO

extern void _XmPrimitiveEnter() ;
extern void _XmPrimitiveLeave() ;

#else

extern void _XmPrimitiveEnter(
                        Widget wid,
                        XEvent *event,
                        String *params,
                        Cardinal *num_params) ;
extern void _XmPrimitiveLeave(
                        Widget wid,
                        XEvent *event,
                        String *params,
                        Cardinal *num_params) ;

#endif
#endif /* _XmPannerP_h */

