#!/usr/bin/perl

############################################################################
# convert2pscal
# 
# A script to convert the data files from MyCalendar (a web based CGI calendar
# from http://www.fuzzymonkey.org/perl/) to the .holiday file needed by pscal
# (a really neat shell script that can output postscript calendars from
# http://freshmeat.net/redir/pscal/8419/url_homepage/)
############################################################################

# First lets make the .holiday file that pscal needs in your $HOME directory
open (HOLIDAY_FILE, ">./.holiday") || die "Could not open .holiday for writing! $!\n";

# now lets take a look at our data files
@files = glob("*.txt");

foreach $file (@files){
    print "Adding entires from $file\n";
    ($month,$year)=split(/-/,"$file");
    $year =~ s/\.txt//gi; #get read of the .text left over from filename
    #print "$month and $year\n";
    if(open(MONTHFILE,"$file")){
        while(<MONTHFILE>){
            chomp;
            ($day,$apps) = split(/\t/,"$_");
            @appointments = split(/##/,"$apps");
            foreach $appointment (@appointments){
                print HOLIDAY_FILE "$month:$day:$appointment\n";
            }
            #print "$day has these apps $apps\n";
        }
        close MONTHFILE;
    }else{
        print "warning could not open $file for reading.  $!";
    }
}
close HOLIDAY_FILE;
print "done.

The results have been saved in .holiday in this directory.  Make sure that you
have downloaded pscal and installed it before proceeding.  There should be
a README.MAKING-PRINTABLE-CALENDARS in this directory that you can read
for links of where to get this program.

Would you like for me to attempt to copy this file to your home directory ($ENV{'HOME'}/.holiday) and to run pscal for you (yes/no)?";

$input = <>;
if($input =~ /^y/i){
	`cp -f .holiday $ENV{'HOME'}/`;
	unless(-e "$ENV{'HOME'}/.holiday"){
		die("Sorry, I could not copy the holiday file.  Perhaps you 
don't have permissions to write to the $ENV{'HOME'} directory!  You will need 
to copy the .holiday file to your HOME directory manually and then run pscal.  
Run 'pscal -help' for more information about how to use it.");
	}
	$year = "";
	until($year =~ /^2[0-9]{3,3}$/){
		print "Years must be in the format of 2001, etc.  ";
		print "What year do you want to print a calendar for?";
		$year = <>;
		chomp($year);
	}
	print "printing the entire year of $year ... \n";
	open(CALENDAR,">>calendar$year.ps")|| die("Could not write out the calendar: $!");
	for($month=1;$month <13;$month++){
		print "Adding calendar for $month/$year\n";
		$output = `pscal $month $year`;
		print CALENDAR $output;
	}
	close(CALENDAR);
	print "Your calendar is now saved in calendar$year.ps in the same
directory as this script.  You may now send it to the printer or convert it
to a pdf file if you have ps2pdf installed.  In order to print your file, enter
the command that you use to print files on your system (typically lpr).  If you
have ps2pdf installed and would like to convert it to a pdff ile, enter ps2pdf
as the caommand.  Just hit ENTER to accept the default of 'lpr' [lpr]: ";
	$input = <>;
	chomp($input);
	if(!($input)){$input = 'lpr'};
	print "\nattempting $input calendar$year.ps\n";
	`$input calendar$year.ps`;
	print "\nThank you for using MyCalendar and this niftly little script
to help you make printable copies.  Please send suggestions or 
improvements to mike\@fuzzymonkey.org.\n";
	
}else {
	print "In order to print this yourself, you should move this to 
	your \$HOME/ directory and then run `pscal month year` to create 
	your calendar.
	
	Thank you for using this script !\n";
}
