% ASEC ASEC Inverse Secant Function
% 
% Usage
% 
% Computes the inverse secant of its argument.  The general
% syntax for its use is
% 
%   y = asec(x)
% 
% where x is an n-dimensional array of numerical type.

function y = asec(x)
  if (nargin == 0 || ~isnumeric(x))
    error('asec expects a single, numeric input');
  end
  y = acos(1.f./x);
  
