% UPPER UPPER Convert strings to upper case
% 
% Usage
% 
% The upper function converts a string to upper case with
% the syntax
% 
%    y = upper(x)
% 
% where x is a string, in which case all of the lower case
% characters in x (defined as the range 'a'-'z') are
% converted to upper case.  Alternately, you can call upper
% with a cell array of strings
% 
%    y = upper(c)
% 
% in which case each string in the cell array is converted to upper case.
function y = upper(x)
  if (isstr(x))
    y = upper_string(x);
  elseif (iscell(x))
    y = cell(size(x));
    for i=1:numel(x)
      y{i} = upper_string(x{i});
    end
  else
    error('upper expects a string or cell array of strings as an argument');
  end

function y = upper_string(x)
  if (isstr(x))
    y = string(x + ('A'-'a')*(x>='a' && x<='z'));
  else
    y = x;
  end;
