#!/usr/local/bin/python2.5
# -*- coding: UTF-8 -*-

# Copyright 2006-2007 (C) Raster Software Vigo (Sergio Costas)
# Copyright 2006-2007 (C) Peter Gill - win32 parts

# This file is part of DeVeDe
#
# DeVeDe is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# DeVeDe is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import pygtk # for testing GTK version number
pygtk.require ('2.0')
import gtk
import gtk.glade

import devede_dialogs
import devede_xml_menu


class menu_options:

	def __init__(self,gladefile,global_vars):
		
		self.global_vars=global_vars
		
		self.tree=gtk.glade.XML(gladefile,"wmenu_properties",domain="devede")
		self.tree.signal_autoconnect(self)
		self.window=self.tree.get_widget("wmenu_properties")
		
		menu_filename=global_vars["menu_bg"]
		if menu_filename==None:
			menu_filename=global_vars["path"]+"background.png"
		w=self.tree.get_widget("menu_bg_file")
		w.set_filename(menu_filename)
		filter=gtk.FileFilter()
		filter.add_mime_type("image/png")
		filter.set_name("PNG pictures")
		w.add_filter(filter)
		
		if global_vars["menu_PAL"]:
			w=self.tree.get_widget("menu_pal")
		else:
			w=self.tree.get_widget("menu_ntsc")
		w.set_active(True)
		
		w=self.tree.get_widget("menufont")
		w.set_font_name(global_vars["fontname"])
		self.window.show()
		retval=self.window.run()
		if retval==-5: # Accept button
			self.set_new_bg()
		self.window.hide()
		self.window.destroy()
		self.window=None
		
	
	def on_menu_default_bg_clicked(self,widget):
		
		self.global_vars["menu_bg"]=self.global_vars["path"]+"background.png"
		w=self.tree.get_widget("menu_bg_file")
		w.set_filename(self.global_vars["menu_bg"])
	
	
	def set_new_bg(self):
		
		w=self.tree.get_widget("menu_bg_file")
		menu_filename=w.get_filename()
		if menu_filename==None:
			menu_filename=self.global_vars["path"]+"background.png"
		self.global_vars["menu_bg"]=menu_filename
		w=self.tree.get_widget("menu_pal")
		if w.get_active():
			self.global_vars["menu_PAL"]=True
		else:
			self.global_vars["menu_PAL"]=False
		w=self.tree.get_widget("menufont")
		self.global_vars["fontname"]=w.get_font_name()
		

class menu_preview:
	
	def menu_preview_expose(self,widget,event):

		""" Callback to repaint the menu preview window when it
			sends the EXPOSE event """

		if self.menu_preview==None:
			return
		cr=self.menu_preview.window.cairo_create()
		cr.set_source_surface(self.sf)
		cr.paint()
		   
	
	def __init__(self,gladefile,structure,global_vars):
		
		""" Shows a window with a preview of the disc menu """
		
		self.menu_preview=None
		newtree=gtk.glade.XML(gladefile,"wmenu_preview",domain="devede")
		newtree.signal_autoconnect(self)
		window=newtree.get_widget("wmenu_preview")
		self.menu_preview=newtree.get_widget("preview_draw")
		clase=devede_xml_menu.xml_files()
		self.sf=clase.create_menu_bg(structure,global_vars["menu_bg"],global_vars["menu_PAL"],global_vars["fontname"],"")

		if self.sf==None:
			devede_dialogs.show_error(gladefile,_("Can't find the menu background.\nCheck the menu options."),arbol)
		else:
			window.show()
			window.run()
			window.hide()
		window.destroy()
		window=None
